/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.annotations.validation;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.annotations.typing.XAnnotationUtil;
import org.eclipse.xtext.xbase.annotations.validation.AnnotationValueValidator;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotationsPackage;
import org.eclipse.xtext.xbase.validation.XbaseValidator;

public class XbaseWithAnnotationsValidator
extends XbaseValidator {
    @Inject
    private XAnnotationUtil annotationUtil;
    @Inject
    private AnnotationValueValidator annotationValueValidator;

    @Override
    protected List<EPackage> getEPackages() {
        ArrayList<EPackage> ePackages = Lists.newArrayList(super.getEPackages());
        ePackages.add(XAnnotationsPackage.eINSTANCE);
        return ePackages;
    }

    @Check
    public void checkAllAttributesConfigured(XAnnotation annotation2) {
        JvmType annotationType = annotation2.getAnnotationType();
        if (annotationType == null || annotationType.eIsProxy() || !(annotationType instanceof JvmAnnotationType)) {
            return;
        }
        Iterable<JvmOperation> attributes = ((JvmAnnotationType)annotationType).getDeclaredOperations();
        for (JvmOperation jvmOperation : attributes) {
            XExpression value = this.annotationUtil.findValue(annotation2, jvmOperation);
            if (value == null) {
                if (jvmOperation.getDefaultValue() != null) continue;
                this.error("The annotation must define the attribute '" + jvmOperation.getSimpleName() + "'.", (EObject)annotation2, null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.missing_attribute_definition", new String[0]);
                continue;
            }
            this.annotationValueValidator.validateAnnotationValue(value, this);
        }
    }
}

