/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.workspace;

import com.google.common.base.Objects;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.workspace.FileProjectConfig;
import org.eclipse.xtext.workspace.ISourceFolder;

public class FileSourceFolder
implements ISourceFolder {
    private final FileProjectConfig parent;
    private final String name;

    public FileSourceFolder(FileProjectConfig parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URI getPath() {
        URI result = URI.createFileURI(this.name).resolve(this.parent.getPath());
        if (result.hasTrailingPathSeparator()) {
            return result;
        }
        return result.appendSegment("");
    }

    public boolean equals(Object obj) {
        if (obj instanceof FileSourceFolder) {
            URI path1 = this.getPath();
            URI path2 = ((FileSourceFolder)obj).getPath();
            return Objects.equal(path1, path2);
        }
        return false;
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    public String toString() {
        return String.valueOf(this.name) + " (" + this.getPath() + ")";
    }
}

