/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util.formallang;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.formallang.FollowerFunction;
import org.eclipse.xtext.util.formallang.Nfa;
import org.eclipse.xtext.util.formallang.NfaFactory;
import org.eclipse.xtext.util.formallang.Production;

public class NfaUtil {
    private static final int DFS_VISITED = 1;
    private static final int DFS_ON_STACK = 2;

    public <S, RESULT> List<RESULT> backtrack(Nfa<S> nfa, RESULT initial, BacktrackHandler<S, RESULT> handler) {
        Stack trace = new Stack();
        trace.push(new BacktrackingItem<RESULT, S>(initial, Collections.singleton(nfa.getStart())));
        S stopState = nfa.getStop();
        block0: while (!trace.isEmpty()) {
            BacktrackingItem item = (BacktrackingItem)trace.peek();
            while (item.followers.hasNext()) {
                Object nextState = item.followers.next();
                RESULT nextResult = handler.handle(nextState, item.result);
                if (nextResult == null) continue;
                Iterable followers = nfa.getFollowers(nextState);
                followers = handler.sortFollowers(nextResult, followers);
                trace.push(new BacktrackingItem(nextResult, followers));
                if (stopState != nextState || !handler.isSolution(nextResult)) continue block0;
                ArrayList result = Lists.newArrayList();
                for (BacktrackingItem backtrackingItem : trace) {
                    result.add(backtrackingItem.result);
                }
                return result;
            }
            trace.pop();
        }
        return null;
    }

    public <S, ITERABLE extends Iterable<? extends S>> boolean canReach(Nfa<S> nfa, Predicate<S> matcher) {
        return this.find(nfa, Collections.singleton(nfa.getStart()), matcher) != null;
    }

    public <S, ITERABLE extends Iterable<? extends S>> boolean canReach(Nfa<S> nfa, S state, Predicate<S> matcher) {
        return this.find(nfa, Collections.singleton(state), matcher) != null;
    }

    public <S, ITERABLE extends Iterable<? extends S>> boolean canReachFinalState(Nfa<S> nfa, S state) {
        return this.find(nfa, Collections.singleton(state), Predicates.equalTo(nfa.getStop())) != null;
    }

    public <S> Set<S> collect(Nfa<S> nfa) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        this.collect(nfa, nfa.getStart(), result);
        return result;
    }

    protected <S> void collect(Nfa<S> nfa, S state, Set<S> visited) {
        if (!visited.add(state)) {
            return;
        }
        for (S s2 : nfa.getFollowers(state)) {
            this.collect(nfa, s2, visited);
        }
    }

    protected <S> void collectDistancesForm(Nfa<S> nfa, S from, int distance, Map<S, Integer> distances, Predicate<S> matches) {
        Integer dist = distances.get(from);
        if (dist != null && dist <= distance) {
            return;
        }
        if (matches.apply(from)) {
            distance = 0;
        }
        distances.put(from, distance);
        if (distance < Integer.MAX_VALUE) {
            ++distance;
        }
        for (S follower : nfa.getFollowers(from)) {
            this.collectDistancesForm(nfa, follower, distance, distances, matches);
        }
    }

    protected <S> void collectedInverseMap(Nfa<S> nfa, S state, Map<S, List<S>> inverseMap, Set<S> visited) {
        if (!visited.add(state)) {
            return;
        }
        for (S follower : nfa.getFollowers(state)) {
            List<S> inverse = inverseMap.get(follower);
            if (inverse == null) {
                inverse = Lists.newArrayList();
                inverseMap.put(follower, inverse);
            }
            inverse.add(state);
            this.collectedInverseMap(nfa, follower, inverseMap, visited);
        }
    }

    protected <S> void collectFollowers(Nfa<S> nfa, S owner, Set<S> result, Set<S> visited, Predicate<S> filter) {
        if (!visited.add(owner)) {
            return;
        }
        if (filter.apply(owner)) {
            result.add(owner);
            return;
        }
        for (S follower : nfa.getFollowers(owner)) {
            this.collectFollowers(nfa, follower, result, visited, filter);
        }
    }

    protected <SRCSTATE, DSTSTATE, P extends Nfa<DSTSTATE>> DSTSTATE create(Nfa<SRCSTATE> source, P result, SRCSTATE src, NfaFactory<P, DSTSTATE, SRCSTATE> factory, Map<SRCSTATE, DSTSTATE> src2dst) {
        DSTSTATE dst = src2dst.get(src);
        if (dst != null) {
            return dst;
        }
        dst = factory.createState(result, src);
        src2dst.put(src, dst);
        ArrayList<DSTSTATE> dstFollower = Lists.newArrayList();
        for (SRCSTATE srcFollower : source.getFollowers(src)) {
            dstFollower.add(this.create(source, result, srcFollower, factory, src2dst));
        }
        factory.setFollowers(result, dst, dstFollower);
        return dst;
    }

    public <SRCSTATE, DSTSTATE, P extends Nfa<DSTSTATE>> P create(Nfa<SRCSTATE> source, NfaFactory<P, DSTSTATE, SRCSTATE> factory) {
        LinkedHashMap<SRCSTATE, DSTSTATE> src2dst = Maps.newLinkedHashMap();
        P result = factory.create(source.getStart(), source.getStop());
        src2dst.put(source.getStop(), result.getStop());
        src2dst.put(source.getStart(), result.getStart());
        ArrayList<DSTSTATE> dstFollower = Lists.newArrayList();
        for (SRCSTATE srcFollower : source.getFollowers(source.getStart())) {
            dstFollower.add(this.create(source, result, srcFollower, factory, (Map<SRCSTATE, DSTSTATE>)src2dst));
        }
        factory.setFollowers(result, result.getStart(), dstFollower);
        return result;
    }

    public <E, T> Nfa<E> create(Production<E, T> production2, FollowerFunction<E> ff, E start, E stop) {
        return this.create(production2, ff, Functions.identity(), new NFAFactory(), start, stop);
    }

    public <S, E, T, P extends Nfa<S>> P create(Production<E, T> production2, FollowerFunction<E> ff, NfaFactory<P, S, ? super T> factory) {
        return this.create(production2, ff, new GetToken<E, T>(production2), factory, null, null);
    }

    public <S, E, T1, T2, P extends Nfa<S>> P create(Production<E, T1> production2, FollowerFunction<E> ff, Function<E, T2> tokenFunc, NfaFactory<P, S, ? super T2> factory, T2 start, T2 stop) {
        LinkedHashMap<Object, S> states = Maps.newLinkedHashMap();
        P nfa = factory.create(start, stop);
        states.put(null, nfa.getStop());
        this.create(production2, nfa, nfa.getStart(), ff.getStarts(production2.getRoot()), ff, tokenFunc, (NfaFactory<P, S, ? super T2>)factory, (Map<E, S>)states);
        return nfa;
    }

    protected <S, E, T1, T2, P extends Nfa<S>> void create(Production<E, T1> production2, P nfa, S state, Iterable<E> followerElements, FollowerFunction<E> followerFunc, Function<E, T2> tokenFunc, NfaFactory<P, S, ? super T2> factory, Map<E, S> ele2state) {
        ArrayList<S> sfollower = Lists.newArrayList();
        for (E follower : followerElements) {
            S fs = ele2state.get(follower);
            if (fs == null) {
                fs = factory.createState(nfa, tokenFunc.apply(follower));
                ele2state.put(follower, fs);
                this.create(production2, nfa, fs, followerFunc.getFollowers(follower), followerFunc, tokenFunc, factory, ele2state);
            }
            sfollower.add(fs);
        }
        factory.setFollowers(nfa, state, sfollower);
    }

    public <S> Map<S, Integer> distanceFromStateMap(Nfa<S> nfa, Predicate<S> matches) {
        LinkedHashMap distances = Maps.newLinkedHashMap();
        this.collectDistancesForm(nfa, nfa.getStart(), Integer.MAX_VALUE, distances, matches);
        return distances;
    }

    public <S> Map<S, Integer> distanceToFinalStateMap(Nfa<S> nfa) {
        final S stop = nfa.getStop();
        return this.distanceToStateMap(nfa, new Predicate<S>(){

            @Override
            public boolean apply(S input) {
                return stop == input;
            }
        });
    }

    public <S> Map<S, Integer> distanceToStateMap(Nfa<S> nfa, Predicate<S> matches) {
        return this.distanceFromStateMap(this.inverse(nfa), matches);
    }

    public <S> boolean equalsIgnoreOrder(Nfa<S> nfa1, Nfa<S> nfa2) {
        return this.equalsIgnoreOrder(nfa1, nfa2, new Function<S, Object>(){

            @Override
            public Object apply(S from) {
                return from;
            }
        });
    }

    public <S> int hashCodeIgnoreOrder(Nfa<S> nfa, Function<S, ? extends Object> keyFunc) {
        int result = 0;
        LinkedList<Object> remaining = new LinkedList<Object>();
        HashSet visited = Sets.newHashSet();
        remaining.add(nfa.getStart());
        while (!remaining.isEmpty()) {
            Object state = remaining.removeFirst();
            Object stateKey = keyFunc.apply((S)state);
            int stateHash = stateKey == null ? 0 : stateKey.hashCode();
            for (Object follower : nfa.getFollowers(state)) {
                Object followerKey = keyFunc.apply((S)follower);
                int followerHash = followerKey == null ? 0 : followerKey.hashCode();
                int edgeHash = stateHash * (followerHash + 1);
                result += edgeHash;
                if (!visited.add(follower)) continue;
                remaining.add(follower);
            }
        }
        return result;
    }

    public <S> boolean equalsIgnoreOrder(Nfa<S> nfa1, Nfa<S> nfa2, Function<S, ? extends Object> keyFunc) {
        if (nfa1 == nfa2) {
            return true;
        }
        if (!Objects.equal(keyFunc.apply(nfa1.getStart()), keyFunc.apply(nfa2.getStart()))) {
            return false;
        }
        return this.equalsIgnoreOrder(nfa1, nfa2, nfa1.getStart(), nfa2.getStart(), keyFunc, Sets.newHashSet());
    }

    public <S> boolean equalsIgnoreOrder(Nfa<S> nfa1, Nfa<S> nfa2, S s1, S s2, Function<S, ? extends Object> keyFunc, Set<S> visited) {
        if (!visited.add(s1)) {
            return true;
        }
        Iterable<S> followers1 = nfa1.getFollowers(s1);
        Iterable<S> followers2 = nfa1.getFollowers(s2);
        if (Iterables.size(followers1) != Iterables.size(followers2)) {
            return false;
        }
        HashMap<Object, S> index = Maps.newHashMap();
        for (S f1 : followers1) {
            if (index.put(keyFunc.apply(f1), f1) == null) continue;
            return false;
        }
        for (S f : followers2) {
            Object key2 = keyFunc.apply(f);
            Object key1s = index.get(key2);
            if (key1s != null && this.equalsIgnoreOrder(nfa1, nfa2, key1s, f, keyFunc, visited)) continue;
            return false;
        }
        return true;
    }

    public <S> String identityString(Nfa<S> nfa, Function<S, String> idFunc) {
        HashMap<String, S> names = Maps.newHashMap();
        HashMap ids = Maps.newHashMap();
        for (S s2 : this.collect(nfa)) {
            String name = idFunc.apply(s2);
            if (name == null) {
                name = "(null)";
            }
            if (s2 == nfa.getStart()) {
                name = "start:" + name;
            } else if (s2 == nfa.getStop()) {
                name = "stop:" + name;
            }
            names.put(name, s2);
        }
        ArrayList<String> sorted = Lists.newArrayList(names.keySet());
        Collections.sort(sorted);
        int i = 0;
        while (i < sorted.size()) {
            ids.put(names.get(sorted.get(i)), i);
            ++i;
        }
        StringBuilder result = new StringBuilder();
        for (String name : sorted) {
            Object state = names.get(name);
            Integer id = (Integer)ids.get(state);
            ArrayList<Integer> followers = Lists.newArrayList();
            for (Object f : nfa.getFollowers(state)) {
                followers.add((Integer)ids.get(f));
            }
            Collections.sort(followers);
            result.append(id);
            result.append(":");
            result.append(name);
            result.append(":");
            int i2 = 0;
            while (i2 < followers.size()) {
                if (i2 != 0) {
                    result.append(",");
                }
                result.append(followers.get(i2));
                ++i2;
            }
            result.append("\n");
        }
        return result.toString();
    }

    public <S> Nfa<S> filter(final Nfa<S> nfa, final Predicate<S> filter) {
        return new Nfa<S>(){

            @Override
            public Set<S> getFollowers(S node) {
                final Object start = nfa.getStart();
                final Object stop = nfa.getStop();
                return NfaUtil.this.filterFollowers(nfa, nfa.getFollowers(node), new Predicate<S>(){

                    @Override
                    public boolean apply(S input) {
                        return input == start || input == stop || filter.apply(input);
                    }
                });
            }

            @Override
            public S getStart() {
                return nfa.getStart();
            }

            @Override
            public S getStop() {
                return nfa.getStop();
            }
        };
    }

    public <S> Set<S> filterFollowers(Nfa<S> nfa, Iterable<S> followers, Predicate<S> filter) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        for (S follower : followers) {
            this.collectFollowers(nfa, follower, result, Sets.newHashSet(), filter);
        }
        return result;
    }

    public <S, ITERABLE extends Iterable<? extends S>> S find(Nfa<S> nfa, Iterable<S> starts, Predicate<S> matcher) {
        HashSet visited = Sets.newHashSet();
        for (S s2 : starts) {
            S r = this.find(nfa, s2, matcher, visited);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    public <S> S find(Nfa<S> nfa, Predicate<S> matcher) {
        HashSet visited = Sets.newHashSet();
        return this.find(nfa, nfa.getStart(), matcher, visited);
    }

    protected <S> S find(Nfa<S> nfa, S state, Predicate<S> matcher, Set<S> visited) {
        if (!visited.add(state)) {
            return null;
        }
        if (matcher.apply(state)) {
            return state;
        }
        for (S s2 : nfa.getFollowers(state)) {
            S r = this.find(nfa, s2, matcher, visited);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    public <S> Set<S> findFirst(Nfa<S> nfa, Iterable<S> starts, Predicate<S> match) {
        LinkedHashSet<Object> current = Sets.newLinkedHashSet(starts);
        LinkedHashSet<S> visited = Sets.newLinkedHashSet();
        while (!current.isEmpty()) {
            LinkedHashSet result = Sets.newLinkedHashSet();
            for (Object s2 : current) {
                if (!match.apply(s2)) continue;
                result.add(s2);
            }
            if (!result.isEmpty()) {
                return result;
            }
            visited.addAll(current);
            LinkedHashSet newCurrent = Sets.newLinkedHashSet();
            for (Object s3 : current) {
                Iterables.addAll(newCurrent, nfa.getFollowers(s3));
            }
            newCurrent.removeAll(visited);
            current = newCurrent;
        }
        return Collections.emptySet();
    }

    public <S> Nfa<S> inverse(Nfa<S> nfa) {
        LinkedHashMap inverseMap = Maps.newLinkedHashMap();
        this.collectedInverseMap(nfa, nfa.getStart(), inverseMap, Sets.newHashSet());
        return new NFAImpl<S>(nfa.getStop(), nfa.getStart(), inverseMap);
    }

    public <S> void removeOrphans(Nfa<S> nfa) {
        Map<S, Integer> distances = this.distanceToFinalStateMap(nfa);
        for (S s2 : this.collect(nfa)) {
            Iterator<S> i = nfa.getFollowers(s2).iterator();
            while (i.hasNext()) {
                if (distances.containsKey(i.next())) continue;
                i.remove();
            }
        }
    }

    public <S extends Comparable<S>> Nfa<S> sort(Nfa<S> nfa) {
        LinkedHashMap<Comparable, ArrayList<Comparable>> followerMap = Maps.newLinkedHashMap();
        for (Comparable state : new NfaUtil().collect(nfa)) {
            ArrayList<Comparable> followers = Lists.newArrayList(nfa.getFollowers(state));
            Collections.sort(followers);
            followerMap.put(state, followers);
        }
        return new NFAImpl<Comparable>((Comparable)nfa.getStart(), (Comparable)nfa.getStop(), followerMap);
    }

    public <S> Nfa<S> sort(Nfa<S> nfa, Comparator<S> comparator) {
        LinkedHashMap<S, ArrayList<S>> followerMap = Maps.newLinkedHashMap();
        for (S state : new NfaUtil().collect(nfa)) {
            ArrayList<S> followers = Lists.newArrayList(nfa.getFollowers(state));
            Collections.sort(followers, comparator);
            followerMap.put(state, followers);
        }
        return new NFAImpl<S>(nfa.getStart(), nfa.getStop(), followerMap);
    }

    public <S, COMP extends Comparable<COMP>> Nfa<S> sort(Nfa<S> nfa, Map<S, COMP> comparator) {
        return this.sort(nfa, new MappedComparator<S, COMP>(comparator));
    }

    public <S> Map<S, Set<S>> findCycles(Nfa<S> nfa) {
        final LinkedHashMap cycles = Maps.newLinkedHashMap();
        IAcceptor cycleAcceptor = new IAcceptor<List<S>>(){

            @Override
            public void accept(List<S> t2) {
                HashSet<Object> cycle = Sets.newHashSet(t2);
                for (Object cycleNode : t2) {
                    Set existingCycle = (Set)cycles.get(cycleNode);
                    if (existingCycle == null) continue;
                    cycle.addAll(existingCycle);
                }
                for (Object n : cycle) {
                    cycles.put(n, cycle);
                }
            }
        };
        this.findCycles(nfa, nfa.getStart(), cycleAcceptor, Maps.newHashMap(), Lists.newLinkedList());
        return cycles;
    }

    public <S> void findCycles(Nfa<S> nfa, IAcceptor<List<S>> cycleAcceptor) {
        this.findCycles(nfa, nfa.getStart(), cycleAcceptor, Maps.newHashMap(), Lists.newLinkedList());
    }

    protected <S> void findCycles(Nfa<S> nfa, S node, IAcceptor<List<S>> cycleAcceptor, Map<S, Integer> dfsMark, LinkedList<S> dfsStack) {
        dfsStack.push(node);
        dfsMark.put(node, 2);
        for (S follower : nfa.getFollowers(node)) {
            Object cycleNode;
            Integer followerMark = dfsMark.get(follower);
            if (followerMark == null) {
                this.findCycles(nfa, follower, cycleAcceptor, dfsMark, dfsStack);
                continue;
            }
            if (followerMark != 2) continue;
            LinkedList cycle = Lists.newLinkedList();
            Iterator stackIter = dfsStack.iterator();
            do {
                cycleNode = stackIter.next();
                cycle.addFirst(cycleNode);
            } while (cycleNode != follower && stackIter.hasNext());
            cycleAcceptor.accept(cycle);
        }
        dfsStack.pop();
        dfsMark.put(node, 1);
    }

    public static interface BacktrackHandler<S, RESULT> {
        public RESULT handle(S var1, RESULT var2);

        public boolean isSolution(RESULT var1);

        public Iterable<S> sortFollowers(RESULT var1, Iterable<S> var2);
    }

    protected static class BacktrackingItem<RESULT, S> {
        protected Iterator<S> followers;
        protected RESULT result;

        public BacktrackingItem(RESULT result, Iterable<S> followers) {
            this.result = result;
            this.followers = followers.iterator();
        }

        public String toString() {
            return this.result == null ? "null" : this.result.toString();
        }
    }

    protected static class GetToken<E, T>
    implements Function<E, T> {
        protected Production<E, T> production;

        public GetToken(Production<E, T> production2) {
            this.production = production2;
        }

        @Override
        public T apply(E from) {
            return this.production.getToken(from);
        }
    }

    public static class MappedComparator<S, COMPARABLE extends Comparable<COMPARABLE>>
    implements Comparator<S> {
        protected final Map<S, COMPARABLE> sortBy;

        public MappedComparator(Map<S, COMPARABLE> sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public int compare(S o1, S o2) {
            Comparable c1 = (Comparable)this.sortBy.get(o1);
            if (c1 == null) {
                return 1;
            }
            Comparable c2 = (Comparable)this.sortBy.get(o2);
            if (c2 == null) {
                return -1;
            }
            return c1.compareTo(c2);
        }
    }

    public static class NFAFactory<S>
    implements NfaFactory<Nfa<S>, S, S> {
        @Override
        public Nfa<S> create(S start, S stop) {
            return new NFAImpl<S>(start, stop, Maps.newLinkedHashMap());
        }

        @Override
        public S createState(Nfa<S> nfa, S token) {
            return token;
        }

        @Override
        public void setFollowers(Nfa<S> nfa, S owner, Iterable<S> followers) {
            ((NFAImpl)nfa).followers.put(owner, Lists.newArrayList(followers));
        }
    }

    public static class NFAImpl<S>
    implements Nfa<S> {
        protected final Map<S, List<S>> followers;
        protected final S start;
        protected final S stop;

        public NFAImpl(S startStates, S finalStates, Map<S, List<S>> followers) {
            this.start = startStates;
            this.stop = finalStates;
            this.followers = followers;
        }

        @Override
        public List<S> getFollowers(S node) {
            List<S> result = this.followers.get(node);
            return result == null ? Collections.emptyList() : result;
        }

        @Override
        public S getStart() {
            return this.start;
        }

        @Override
        public S getStop() {
            return this.stop;
        }
    }
}

