/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.xtext.util.JavaStringConverter;

public class Strings {
    public static final String[] EMPTY_ARRAY = new String[0];
    private static final JavaStringConverter CONVERTER = new JavaStringConverter();
    public static final char SEPARATOR = ':';
    private static final char[] separator = System.getProperty("line.separator").toCharArray();

    public static boolean equalsIgnoreWhitespace(String left, String right) {
        String l = left == null ? "" : left.replaceAll("\\s", "");
        String r = right == null ? "" : right.replaceAll("\\s", "");
        return l.equals(r);
    }

    public static boolean equal(String literal, String name) {
        return Strings.isEmpty(literal) ? Strings.isEmpty(name) : literal.equals(name);
    }

    public static String notNull(Object o) {
        return String.valueOf(o);
    }

    public static String emptyIfNull(String s2) {
        return s2 == null ? "" : s2;
    }

    public static String concat(String separator, List<String> list) {
        return Strings.concat(separator, list, 0);
    }

    public static <T> String toString(Collection<T> list, Function<T, String> toString, String delim) {
        StringBuffer buffer = new StringBuffer();
        Iterator<T> iterator = list.iterator();
        while (iterator.hasNext()) {
            T t2 = iterator.next();
            buffer.append(toString.apply(t2));
            if (!iterator.hasNext()) continue;
            buffer.append(delim);
        }
        return buffer.toString();
    }

    public static String concat(String separator, List<String> list, int skip) {
        StringBuffer buff = new StringBuffer();
        int lastIndex = list.size() - skip;
        int i = 0;
        while (i < lastIndex) {
            buff.append(list.get(i));
            if (i + 1 < lastIndex) {
                buff.append(separator);
            }
            ++i;
        }
        String string = buff.toString();
        return string.trim().length() == 0 ? null : string;
    }

    public static String skipLastToken(String value, String separator) {
        int endIndex = value.lastIndexOf(separator);
        if (endIndex > 0) {
            return value.substring(0, endIndex);
        }
        return value;
    }

    public static String lastToken(String value, String separator) {
        int index = value.lastIndexOf(separator) + separator.length();
        if (index < value.length()) {
            return value.substring(index, value.length());
        }
        return "";
    }

    public static String toFirstUpper(String s2) {
        if (s2 == null || s2.length() == 0 || Character.isUpperCase(s2.charAt(0))) {
            return s2;
        }
        if (s2.length() == 1) {
            return s2.toUpperCase();
        }
        return String.valueOf(s2.substring(0, 1).toUpperCase()) + s2.substring(1);
    }

    public static boolean isEmpty(String s2) {
        return s2 == null || s2.equals("");
    }

    public static String newLine() {
        return System.getProperty("line.separator");
    }

    public static String toPlatformLineSeparator(CharSequence cs) {
        return cs.toString().replaceAll("\r?\n", Strings.newLine());
    }

    public static String toUnixLineSeparator(CharSequence cs) {
        return cs.toString().replaceAll("\r?\n", "\n");
    }

    public static String toFirstLower(String s2) {
        if (s2 == null || s2.length() == 0 || Character.isLowerCase(s2.charAt(0))) {
            return s2;
        }
        if (s2.length() == 1) {
            return s2.toLowerCase();
        }
        return String.valueOf(s2.substring(0, 1).toLowerCase()) + s2.substring(1);
    }

    public static String convertFromJavaString(String string, boolean useUnicode) {
        return CONVERTER.convertFromJavaString(string, useUnicode);
    }

    public static String convertToJavaString(String theString) {
        return CONVERTER.convertToJavaString(theString, true);
    }

    public static String convertToJavaString(String input, boolean useUnicode) {
        return CONVERTER.convertToJavaString(input, useUnicode);
    }

    public static char toHex(int i) {
        return CONVERTER.toHex(i);
    }

    /*
     * Unable to fully structure code
     */
    public static List<String> split(String value, String delimiter) {
        result = new ArrayList<String>();
        lastIndex = 0;
        index = value.indexOf(delimiter, lastIndex);
        pendingEmptyStrings = 0;
        while (index != -1) {
            block4: {
                addMe = value.substring(lastIndex, index);
                if (addMe.length() != 0) ** GOTO lbl13
                ++pendingEmptyStrings;
                break block4;
lbl-1000:
                // 1 sources

                {
                    result.add("");
                    --pendingEmptyStrings;
lbl13:
                    // 2 sources

                    ** while (pendingEmptyStrings > 0)
                }
lbl14:
                // 1 sources

                result.add(addMe);
            }
            lastIndex = index + delimiter.length();
            index = value.indexOf(delimiter, lastIndex);
        }
        if (lastIndex != value.length()) {
            while (pendingEmptyStrings > 0) {
                result.add("");
                --pendingEmptyStrings;
            }
            result.add(value.substring(lastIndex));
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public static List<String> split(String value, char delimiter) {
        result = new ArrayList<String>();
        lastIndex = 0;
        index = value.indexOf(delimiter, lastIndex);
        pendingEmptyStrings = 0;
        while (index != -1) {
            block4: {
                addMe = value.substring(lastIndex, index);
                if (addMe.length() != 0) ** GOTO lbl13
                ++pendingEmptyStrings;
                break block4;
lbl-1000:
                // 1 sources

                {
                    result.add("");
                    --pendingEmptyStrings;
lbl13:
                    // 2 sources

                    ** while (pendingEmptyStrings > 0)
                }
lbl14:
                // 1 sources

                result.add(addMe);
            }
            lastIndex = index + 1;
            index = value.indexOf(delimiter, lastIndex);
        }
        if (lastIndex != value.length()) {
            while (pendingEmptyStrings > 0) {
                result.add("");
                --pendingEmptyStrings;
            }
            result.add(value.substring(lastIndex));
        }
        return result;
    }

    public static String pack(String[] strings) {
        if (strings != null && strings.length > 0) {
            StringBuffer buffer = new StringBuffer();
            String[] stringArray = strings;
            int n = strings.length;
            int n2 = 0;
            while (n2 < n) {
                String s2 = stringArray[n2];
                buffer.append(s2.length());
                buffer.append(':');
                buffer.append(s2);
                ++n2;
            }
            return buffer.toString();
        }
        return null;
    }

    public static String[] unpack(String packed) {
        if (Strings.isEmpty(packed)) {
            return null;
        }
        ArrayList<String> strings = Lists.newArrayList();
        Strings.unpack(strings, packed);
        return strings.toArray(new String[strings.size()]);
    }

    private static void unpack(List<String> strings, String packed) {
        int delimiterIndex = packed.indexOf(":");
        int size = Integer.parseInt(packed.substring(0, delimiterIndex));
        int endIndex = delimiterIndex + 1 + size;
        strings.add(packed.substring(delimiterIndex + 1, endIndex));
        if (endIndex < packed.length()) {
            Strings.unpack(strings, packed.substring(endIndex));
        }
    }

    public static String removeLeadingWhitespace(String indentationString) {
        int i = 0;
        while (i < indentationString.length() && Character.isWhitespace(indentationString.charAt(i))) {
            ++i;
        }
        return indentationString.substring(i);
    }

    public static int countLineBreaks(CharSequence text) {
        return Strings.countLineBreaks(text, 0, text.length());
    }

    public static int countLineBreaks(CharSequence text, int startInclusive, int endExclusive) {
        int result = 0;
        int i = startInclusive;
        while (i < endExclusive) {
            char ch = text.charAt(i);
            if (ch == '\r') {
                ++result;
                if (i + 1 < endExclusive && text.charAt(i + 1) == '\n') {
                    ++i;
                }
            } else if (ch == '\n') {
                ++result;
            }
            ++i;
        }
        return result;
    }

    public static CharSequence trimTrailingLineBreak(CharSequence s2) {
        if (s2 == null) {
            return null;
        }
        if (s2.length() == 0) {
            return s2;
        }
        if (s2.charAt(s2.length() - 1) == '\n') {
            if (s2.length() > 1 && s2.charAt(s2.length() - 2) == '\r') {
                return s2.subSequence(0, s2.length() - 2);
            }
            return s2.subSequence(0, s2.length() - 1);
        }
        if (s2.charAt(s2.length() - 1) == '\r') {
            return s2.subSequence(0, s2.length() - 1);
        }
        return s2;
    }

    public static int countLines(String text) {
        return Strings.countLines(text, separator);
    }

    public static int countLines(String text, char[] separator) {
        return Strings.countLines(text, separator, 0, text.length());
    }

    public static int countLines(String text, char[] separator, int startInclusive, int endExclusive) {
        int line = 0;
        if (separator.length == 1) {
            char c = separator[0];
            int i = startInclusive;
            while (i < endExclusive) {
                if (text.charAt(i) == c) {
                    ++line;
                }
                ++i;
            }
        } else if (separator.length == 2) {
            char c1 = separator[0];
            char c2 = separator[1];
            int i = startInclusive;
            while (i < endExclusive) {
                if (text.charAt(i) == c1 && endExclusive > i + 1 && text.charAt(i + 1) == c2) {
                    ++line;
                    ++i;
                } else if (text.charAt(i) == c2) {
                    ++line;
                }
                ++i;
            }
        } else {
            throw new IllegalArgumentException("Separators with more than two characters are unexpected");
        }
        return line;
    }

    public static String getLeadingWhiteSpace(String original) {
        int i = 0;
        while (i < original.length()) {
            if (!Character.isWhitespace(original.charAt(i))) {
                return original.substring(0, i);
            }
            ++i;
        }
        return original;
    }

    public static String wordWrap(String string, int maxCharsPerLine) {
        StringBuilder document = new StringBuilder();
        StringBuilder line = new StringBuilder();
        StringBuilder word = new StringBuilder();
        StringBuilder ws = new StringBuilder();
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            if (c == '\n') {
                line.append((CharSequence)ws);
                line.append((CharSequence)word);
                line.append("\n");
                document.append((CharSequence)line);
                line = new StringBuilder();
                word = new StringBuilder();
                ws = new StringBuilder();
            } else if (Character.isWhitespace(c)) {
                if (line.length() + word.length() + 1 > maxCharsPerLine) {
                    line.append("\n");
                    document.append((CharSequence)line);
                    line = new StringBuilder();
                    line.append((CharSequence)word);
                    word = new StringBuilder();
                    ws = new StringBuilder();
                    ws.append(c);
                } else if (word.length() == 0) {
                    ws.append(c);
                } else {
                    line.append((CharSequence)ws);
                    line.append((CharSequence)word);
                    word = new StringBuilder();
                    ws = new StringBuilder();
                    ws.append(c);
                }
            } else {
                word.append(c);
            }
            ++i;
        }
        if (line.length() + word.length() + 1 > maxCharsPerLine) {
            document.append((CharSequence)line);
            document.append("\n");
            document.append((CharSequence)word);
        } else {
            document.append((CharSequence)line);
            document.append((CharSequence)ws);
            document.append((CharSequence)word);
        }
        return document.toString();
    }

    public static int getLevenshteinDistance(String from, String to) {
        Preconditions.checkNotNull(from, "from");
        Preconditions.checkNotNull(to, "to");
        boolean COST = true;
        char[] first = (" " + from).toCharArray();
        char[] second = (" " + to).toCharArray();
        int rows = first.length;
        int columns = second.length;
        int[][] metric = new int[rows][columns];
        int column = 1;
        while (column < columns) {
            metric[0][column] = metric[0][column - 1] + 1;
            ++column;
        }
        int row = 1;
        while (row < rows) {
            metric[row][0] = metric[row - 1][0] + 1;
            ++row;
        }
        int swap = Integer.MAX_VALUE;
        int change = Integer.MAX_VALUE;
        int row2 = 1;
        while (row2 < rows) {
            char source = first[row2];
            int column2 = 1;
            while (column2 < columns) {
                char target = second[column2];
                int diagonal = metric[row2 - 1][column2 - 1];
                if (source == target) {
                    metric[row2][column2] = diagonal;
                } else {
                    int insert;
                    int remove;
                    int minimum;
                    change = Integer.MAX_VALUE;
                    if (Character.toLowerCase(source) == Character.toLowerCase(target)) {
                        change = 1 + diagonal;
                    }
                    swap = Integer.MAX_VALUE;
                    if (row2 != 1 && column2 != 1 && source == second[column2 - 1] && first[row2 - 1] == target) {
                        swap = 1 + metric[row2 - 2][column2 - 2];
                    }
                    if (swap < (minimum = 1 + diagonal)) {
                        minimum = swap;
                    }
                    if (1 + (remove = metric[row2][column2 - 1]) < minimum) {
                        minimum = 1 + remove;
                    }
                    if (1 + (insert = metric[row2 - 1][column2]) < minimum) {
                        minimum = 1 + insert;
                    }
                    if (change < minimum) {
                        minimum = change;
                    }
                    metric[row2][column2] = minimum;
                }
                ++column2;
            }
            ++row2;
        }
        return metric[rows - 1][columns - 1];
    }
}

