/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util;

import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public class LineAndColumn {
    private final int line;
    private final int column;

    public static LineAndColumn from(int line, int column) {
        LineAndColumn result = new LineAndColumn(line, column);
        if (line <= 0 || column <= 0) {
            throw new IllegalArgumentException(result.toString());
        }
        return result;
    }

    private LineAndColumn(int line, int column) {
        this.line = line;
        this.column = column;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.line;
        return 31 * result + this.column;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LineAndColumn other = (LineAndColumn)obj;
        if (other.line != this.line) {
            return false;
        }
        return other.column == this.column;
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder(this);
        b.add("line", this.line);
        b.add("column", this.column);
        return b.toString();
    }
}

