/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.tasks;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parsetree.reconstr.IHiddenTokenHelper;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.tasks.ITaskFinder;
import org.eclipse.xtext.tasks.ITaskParser;
import org.eclipse.xtext.tasks.ITaskTagProvider;
import org.eclipse.xtext.tasks.Task;
import org.eclipse.xtext.tasks.TaskTags;

public class DefaultTaskFinder
implements ITaskFinder {
    @Inject
    private ITaskParser parser;
    @Inject
    private ITaskTagProvider taskTagProvider;
    @Inject
    private IHiddenTokenHelper hiddenTokenHelper;
    private Pattern endTagPattern = Pattern.compile("\\*/\\z");

    @Inject(optional=true)
    protected Pattern setEndTag(@Named(value="org.eclipse.xtext.ui.editor.hover.MultiLineDocumentationProvider.endTag") String endTag) {
        this.endTagPattern = Pattern.compile(String.valueOf(endTag) + "\\z");
        return this.endTagPattern;
    }

    @Override
    public List<Task> findTasks(Resource resource) {
        TaskTags taskTags = this.taskTagProvider.getTaskTags(resource);
        if (Iterables.isEmpty(taskTags) || !(resource instanceof XtextResource)) {
            return Collections.emptyList();
        }
        IParseResult parseResult = ((XtextResource)resource).getParseResult();
        if (parseResult == null || parseResult.getRootNode() == null) {
            return Collections.emptyList();
        }
        List<Task> tasks = this.findTasks(parseResult.getRootNode(), taskTags);
        return Collections.unmodifiableList(tasks);
    }

    protected List<Task> findTasks(ICompositeNode node, TaskTags taskTags) {
        ArrayList<Task> result = new ArrayList<Task>();
        node.getLeafNodes().forEach(leaf -> {
            boolean bl = result.addAll(this.findTasks((ILeafNode)leaf, taskTags));
        });
        return result;
    }

    protected List<Task> findTasks(ILeafNode node, TaskTags taskTags) {
        if (!this.canContainTaskTags(node)) {
            return Collections.emptyList();
        }
        List<Task> tasks = this.parser.parseTasks(this.stripText(node, node.getText()), taskTags);
        tasks.forEach(it -> {
            it.setOffset(it.getOffset() + node.getOffset());
            it.setLineNumber(it.getLineNumber() + node.getStartLine() - 1);
        });
        return tasks;
    }

    protected String stripText(ILeafNode node, String text) {
        return this.endTagPattern.matcher(text).replaceAll("");
    }

    protected boolean canContainTaskTags(ILeafNode node) {
        EObject rule = node.getGrammarElement();
        if (rule instanceof AbstractRule) {
            return this.hiddenTokenHelper.isComment((AbstractRule)rule);
        }
        return false;
    }
}

