/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.sequencer;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.analysis.IGrammarConstraintProvider;
import org.eclipse.xtext.serializer.analysis.SerializationContext;
import org.eclipse.xtext.serializer.analysis.SerializationContextMap;
import org.eclipse.xtext.serializer.sequencer.IAssignmentFinder;
import org.eclipse.xtext.serializer.sequencer.IContextFinder;
import org.eclipse.xtext.serializer.sequencer.ISemanticNodeProvider;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService;
import org.eclipse.xtext.serializer.sequencer.TransientValueUtil;
import org.eclipse.xtext.xtext.RuleNames;

public class ContextFinder
implements IContextFinder {
    @Inject
    protected IAssignmentFinder assignmentFinder;
    protected SerializationContextMap<IGrammarConstraintProvider.IConstraint> constraints;
    @Inject
    protected IGrammarConstraintProvider grammarConstraintProvider;
    @Inject
    protected ISemanticNodeProvider nodesProvider;
    @Inject
    protected RuleNames ruleNames;
    @Inject
    protected ITransientValueService transientValues;
    @Inject
    protected TransientValueUtil transientValueUtil;

    protected Set<AbstractElement> findAssignedElements(EObject obj, EStructuralFeature feature, Multimap<AbstractElement, ISerializationContext> assignments) {
        if (feature.isMany()) {
            LinkedHashSet<AbstractElement> r = Sets.newLinkedHashSet();
            ISemanticNodeProvider.INodesForEObjectProvider nodes = this.nodesProvider.getNodesForSemanticObject(obj, null);
            switch (this.transientValues.isListTransient(obj, feature)) {
                case SOME: {
                    List values1 = (List)obj.eGet(feature);
                    int j = 0;
                    int i = 0;
                    while (i < values1.size()) {
                        if (!this.transientValues.isValueInListTransient(obj, i, feature)) {
                            Object value = values1.get(i);
                            INode node = nodes.getNodeForMultiValue(feature, i, j, value);
                            r.addAll(this.assignmentFinder.findAssignmentsByValue(obj, assignments, value, node));
                            ++j;
                        }
                        ++i;
                    }
                    return r;
                }
                case NO: {
                    List values2 = (List)obj.eGet(feature);
                    int i = 0;
                    while (i < values2.size()) {
                        Object value = values2.get(i);
                        INode node = nodes.getNodeForMultiValue(feature, i, i, value);
                        r.addAll(this.assignmentFinder.findAssignmentsByValue(obj, assignments, value, node));
                        ++i;
                    }
                    return r;
                }
            }
            return Collections.emptySet();
        }
        if (this.transientValues.isValueTransient(obj, feature) == ITransientValueService.ValueTransient.YES) {
            return Collections.emptySet();
        }
        Object value = obj.eGet(feature);
        INode node = this.nodesProvider.getNodesForSemanticObject(obj, null).getNodeForSingelValue(feature, value);
        return this.assignmentFinder.findAssignmentsByValue(obj, assignments, value, node);
    }

    protected Multimap<AbstractElement, ISerializationContext> collectAssignments(Multimap<IGrammarConstraintProvider.IConstraint, ISerializationContext> constraints, EStructuralFeature feature) {
        ArrayListMultimap<AbstractElement, ISerializationContext> result = ArrayListMultimap.create();
        for (Map.Entry<IGrammarConstraintProvider.IConstraint, Collection<ISerializationContext>> e : constraints.asMap().entrySet()) {
            IGrammarConstraintProvider.IConstraint constraint = e.getKey();
            Collection<ISerializationContext> contexts = e.getValue();
            IGrammarConstraintProvider.IFeatureInfo featureInfo = constraint.getFeatures()[constraint.getType().getFeatureID(feature)];
            List<IGrammarConstraintProvider.IConstraintElement> assignments = featureInfo.getAssignments();
            for (IGrammarConstraintProvider.IConstraintElement assignment : assignments) {
                result.putAll(assignment.getGrammarElement(), contexts);
            }
        }
        return result;
    }

    @Override
    public Set<ISerializationContext> findByContents(EObject semanticObject, Iterable<ISerializationContext> contextCandidates) {
        if (semanticObject == null) {
            throw new NullPointerException();
        }
        this.initConstraints();
        Multimap<IGrammarConstraintProvider.IConstraint, ISerializationContext> constraints = contextCandidates != null ? this.getConstraints(semanticObject, contextCandidates) : this.getConstraints(semanticObject);
        if (constraints.size() < 2) {
            return Sets.newLinkedHashSet(constraints.values());
        }
        for (IGrammarConstraintProvider.IConstraint cand : Lists.newArrayList(constraints.keySet())) {
            if (this.isValidValueQuantity(cand, semanticObject)) continue;
            constraints.removeAll(cand);
        }
        if (constraints.size() < 2) {
            return Sets.newLinkedHashSet(constraints.values());
        }
        LinkedHashSet<ISerializationContext> result = Sets.newLinkedHashSet(constraints.values());
        for (EStructuralFeature feat : semanticObject.eClass().getEAllStructuralFeatures()) {
            if (this.transientValueUtil.isTransient(semanticObject, feat) != ITransientValueService.ValueTransient.NO || feat.isMany() && ((List)semanticObject.eGet(feat)).isEmpty()) continue;
            Multimap<AbstractElement, ISerializationContext> assignments = this.collectAssignments(constraints, feat);
            Set<AbstractElement> assignedElements = this.findAssignedElements(semanticObject, feat, assignments);
            HashSet<ISerializationContext> keep = Sets.newHashSet();
            for (AbstractElement ele : assignedElements) {
                keep.addAll(assignments.get(ele));
            }
            result.retainAll(keep);
        }
        return result;
    }

    @Override
    public Set<ISerializationContext> findByContentsAndContainer(EObject semanticObject, Iterable<ISerializationContext> contextCandidates) {
        this.initConstraints();
        contextCandidates = this.findContextsByContainer(semanticObject, contextCandidates);
        if (contextCandidates != null && Iterables.size(contextCandidates) < 2) {
            return Sets.newLinkedHashSet(contextCandidates);
        }
        return this.findByContents(semanticObject, contextCandidates);
    }

    protected List<ISerializationContext> createContextsForFeatures(Collection<ISerializationContext> containers, IGrammarConstraintProvider.IFeatureInfo feature, EObject sem) {
        ArrayList<ISerializationContext> result = Lists.newArrayList();
        for (IGrammarConstraintProvider.IConstraintElement assignment : feature.getAssignments()) {
            for (ISerializationContext container2 : containers) {
                result.add(SerializationContext.forChild(container2, assignment.getGrammarElement(), sem));
            }
        }
        return result;
    }

    protected Iterable<ISerializationContext> findContextsByContainer(EObject sem, Iterable<ISerializationContext> contextCandidates) {
        LinkedHashSet<Object> result;
        if (sem.eResource() != null && sem.eResource().getContents().contains(sem)) {
            return Collections.singleton(this.getRootContext(sem));
        }
        EReference ref = sem.eContainmentFeature();
        if (ref == null || contextCandidates != null && Iterables.size(contextCandidates) < 2) {
            return contextCandidates;
        }
        Multimap<IGrammarConstraintProvider.IConstraint, ISerializationContext> containerConstraints = this.getConstraints(sem.eContainer());
        int refID = sem.eContainer().eClass().getFeatureID(ref);
        LinkedHashSet<ISerializationContext> childContexts = Sets.newLinkedHashSet();
        for (Map.Entry<IGrammarConstraintProvider.IConstraint, Collection<ISerializationContext>> e : Lists.newArrayList(containerConstraints.asMap().entrySet())) {
            IGrammarConstraintProvider.IConstraint constraint = e.getKey();
            Collection<ISerializationContext> contexts = e.getValue();
            if (constraint.getFeatures()[refID] == null) {
                containerConstraints.removeAll(constraint);
                continue;
            }
            childContexts.addAll(this.createContextsForFeatures(contexts, constraint.getFeatures()[refID], sem));
        }
        if (contextCandidates != null) {
            result = Sets.newLinkedHashSet(contextCandidates);
            result.retainAll(childContexts);
        } else {
            result = childContexts;
        }
        if (result.size() < 2) {
            return result;
        }
        Iterable<ISerializationContext> filteredContexts = this.findContextsByContainer(sem.eContainer(), containerConstraints.values());
        childContexts = Sets.newLinkedHashSet();
        for (Map.Entry<IGrammarConstraintProvider.IConstraint, Collection<ISerializationContext>> e : Lists.newArrayList(containerConstraints.asMap().entrySet())) {
            if (!this.intersect(filteredContexts, (Iterable<ISerializationContext>)e.getValue())) continue;
            childContexts.addAll(this.createContextsForFeatures(e.getValue(), e.getKey().getFeatures()[refID], sem));
        }
        result.retainAll(childContexts);
        return result;
    }

    @Override
    @Deprecated
    public Iterable<EObject> findContextsByContents(EObject semanticObject, Iterable<EObject> contextCandidates) {
        List<ISerializationContext> candidates = SerializationContext.fromEObjects(contextCandidates, semanticObject);
        return SerializationContext.fromIContexts(this.findByContents(semanticObject, candidates));
    }

    @Override
    @Deprecated
    public Iterable<EObject> findContextsByContentsAndContainer(EObject semanticObject, Iterable<EObject> contextCandidates) {
        List<ISerializationContext> candidates = SerializationContext.fromEObjects(contextCandidates, semanticObject);
        return SerializationContext.fromIContexts(this.findByContentsAndContainer(semanticObject, candidates));
    }

    protected Multimap<IGrammarConstraintProvider.IConstraint, ISerializationContext> getConstraints(EObject sem) {
        EClass type = sem == null ? null : sem.eClass();
        ArrayListMultimap<IGrammarConstraintProvider.IConstraint, ISerializationContext> result = ArrayListMultimap.create();
        for (SerializationContextMap.Entry<IGrammarConstraintProvider.IConstraint> e : this.constraints.values()) {
            IGrammarConstraintProvider.IConstraint constraint = e.getValue();
            for (ISerializationContext context : e.getContexts()) {
                if (constraint.getType() != type) continue;
                result.put(constraint, context);
            }
        }
        return result;
    }

    protected Multimap<IGrammarConstraintProvider.IConstraint, ISerializationContext> getConstraints(EObject sem, Iterable<ISerializationContext> contextCandidates) {
        EClass type = sem == null ? null : sem.eClass();
        ArrayListMultimap<IGrammarConstraintProvider.IConstraint, ISerializationContext> result = ArrayListMultimap.create();
        for (ISerializationContext ctx : contextCandidates) {
            IGrammarConstraintProvider.IConstraint constraint = this.constraints.get(ctx);
            if (constraint == null || constraint.getType() != type) continue;
            result.put(constraint, ctx);
        }
        return result;
    }

    protected ISerializationContext getRootContext(EObject sem) {
        for (AbstractRule rule : this.ruleNames.getAllRules()) {
            if (!GrammarUtil.isEObjectRule(rule)) continue;
            return SerializationContext.fromEObject(rule, sem);
        }
        throw new RuntimeException("There is no parser rule in the grammar.");
    }

    public void initConstraints() {
        if (this.constraints == null) {
            this.constraints = this.grammarConstraintProvider.getConstraints(this.ruleNames.getContextGrammar());
        }
    }

    protected boolean intersect(Iterable<ISerializationContext> it1, Iterable<ISerializationContext> it2) {
        for (ISerializationContext i1 : it1) {
            for (ISerializationContext i2 : it2) {
                if (!i1.equals(i2)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isValidValueQuantity(IGrammarConstraintProvider.IConstraint constraint, EObject semanicObj) {
        if (constraint == null) {
            return false;
        }
        int featureID = 0;
        while (featureID < semanicObj.eClass().getFeatureCount()) {
            IGrammarConstraintProvider.IFeatureInfo featureInfo = constraint.getFeatures()[featureID];
            EStructuralFeature feature = semanicObj.eClass().getEStructuralFeature(featureID);
            if (feature.isMany()) {
                int count = this.transientValueUtil.countNonTransientListValues(semanicObj, feature);
                if (count > featureInfo.getUpperBound()) {
                    return false;
                }
                if (count < featureInfo.getLowerBound()) {
                    return false;
                }
            } else {
                ITransientValueService.ValueTransient valueTransient = this.transientValues.isValueTransient(semanicObj, feature);
                switch (valueTransient) {
                    case NO: {
                        if (featureInfo == null) {
                            return false;
                        }
                        if (featureInfo.getUpperBound() > 0) break;
                        return false;
                    }
                    case YES: {
                        if (featureInfo == null || featureInfo.getLowerBound() <= 0) break;
                        return false;
                    }
                }
            }
            ++featureID;
        }
        return true;
    }
}

