/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.analysis;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Parameter;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.grammaranalysis.impl.CfgAdapter;
import org.eclipse.xtext.grammaranalysis.impl.GrammarElementTitleSwitch;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.analysis.IGrammarPDAProvider;
import org.eclipse.xtext.serializer.analysis.ISerState;
import org.eclipse.xtext.serializer.analysis.SerializationContext;
import org.eclipse.xtext.serializer.analysis.SerializationContextMap;
import org.eclipse.xtext.serializer.analysis.SerializerPDA;
import org.eclipse.xtext.util.formallang.FollowerFunctionImpl;
import org.eclipse.xtext.util.formallang.Pda;
import org.eclipse.xtext.util.formallang.PdaFactory;
import org.eclipse.xtext.util.formallang.PdaUtil;
import org.eclipse.xtext.util.formallang.Production;
import org.eclipse.xtext.xtext.FlattenedGrammarAccess;
import org.eclipse.xtext.xtext.OriginalElement;
import org.eclipse.xtext.xtext.RuleFilter;
import org.eclipse.xtext.xtext.RuleNames;
import org.eclipse.xtext.xtext.RuleWithParameterValues;

@Singleton
public class GrammarPDAProvider
implements IGrammarPDAProvider {
    private static Logger LOG = Logger.getLogger(GrammarPDAProvider.class);
    @Inject
    protected SerializerPDA.SerializerPDAElementFactory factory;
    @Inject
    protected PdaUtil pdaUtil;

    protected ISerializationContext createContext(ParserRule original, Set<Parameter> params) {
        SerializationContext context = new SerializationContext.RuleContext(null, original);
        if (params != null && !params.isEmpty()) {
            context = new SerializationContext.ParameterValueContext(context, params);
        }
        return context;
    }

    protected Pda<ISerState, RuleCall> createPDA(Grammar flattened, ParserRule entryRule) {
        SerializerParserRuleCfg cfg = new SerializerParserRuleCfg(flattened, entryRule);
        SerializerParserRuleFollowerFunction ff = new SerializerParserRuleFollowerFunction(cfg);
        SerializerPDA pda = this.pdaUtil.create(cfg, ff, new ToOriginal(this.factory));
        return pda;
    }

    @Override
    public SerializationContextMap<Pda<ISerState, RuleCall>> getGrammarPDAs(Grammar grammar) {
        RuleNames names = RuleNames.getRuleNames(grammar, true);
        RuleFilter filter = new RuleFilter();
        filter.setDiscardTerminalRules(true);
        filter.setDiscardUnreachableRules(false);
        filter.setDiscardRuleTypeRef(false);
        Grammar flattened = new FlattenedGrammarAccess(names, filter).getFlattenedGrammar();
        SerializationContextMap.Builder<Pda<ISerState, RuleCall>> result = SerializationContextMap.builder();
        for (ParserRule rule : GrammarUtil.allParserRules(flattened)) {
            RuleWithParameterValues withParams = RuleWithParameterValues.findInEmfObject(rule);
            AbstractRule original = withParams.getOriginal();
            if (!(original instanceof ParserRule) || !this.isValidRule((ParserRule)original)) continue;
            ISerializationContext context = this.createContext((ParserRule)original, withParams.getParamValues());
            try {
                Pda<ISerState, RuleCall> pda = this.createPDA(grammar, rule);
                result.put(context, pda);
            }
            catch (Exception e) {
                LOG.error("Error creating PDA for context '" + context + "': " + e.getMessage(), e);
            }
        }
        return result.create();
    }

    protected boolean isValidRule(ParserRule rule) {
        return GrammarUtil.isEObjectRule(rule) && !rule.isFragment();
    }

    protected static class SerializerParserRuleCfg
    extends CfgAdapter {
        private final ParserRule entryRule;

        public SerializerParserRuleCfg(Grammar grammar, ParserRule entryRule) {
            super(grammar);
            this.entryRule = entryRule;
        }

        @Override
        public AbstractElement getCall(AbstractElement ele) {
            if (GrammarUtil.isEObjectRuleCall(ele) && !GrammarUtil.isAssigned(ele)) {
                return ((RuleCall)ele).getRule().getAlternatives();
            }
            return null;
        }

        @Override
        public AbstractElement getRoot() {
            return this.entryRule.getAlternatives();
        }
    }

    protected static class SerializerParserRuleFollowerFunction
    extends FollowerFunctionImpl<AbstractElement, AbstractElement> {
        public SerializerParserRuleFollowerFunction(Production<AbstractElement, AbstractElement> production2) {
            super(production2);
        }
    }

    protected static class ToOriginal
    implements PdaFactory<SerializerPDA, ISerState, RuleCall, AbstractElement> {
        private final SerializerPDA.SerializerPDAElementFactory delegate;
        private final Map<AbstractElement, ISerState> pops = Maps.newHashMap();
        private final Map<AbstractElement, ISerState> pushs = Maps.newHashMap();
        private final Map<AbstractElement, ISerState> states = Maps.newHashMap();

        public ToOriginal(SerializerPDA.SerializerPDAElementFactory delegate) {
            this.delegate = delegate;
        }

        @Override
        public SerializerPDA create(AbstractElement start, AbstractElement stop) {
            return this.delegate.create(this.original(start), this.original(stop));
        }

        @Override
        public ISerState createPop(SerializerPDA pda, AbstractElement token) {
            AbstractElement original = this.original(token);
            ISerState state = this.pops.get(original);
            if (state == null) {
                state = this.delegate.createPop(pda, original);
                this.pops.put(original, state);
            }
            return state;
        }

        @Override
        public ISerState createPush(SerializerPDA pda, AbstractElement token) {
            AbstractElement original = this.original(token);
            ISerState state = this.pushs.get(original);
            if (state == null) {
                state = this.delegate.createPush(pda, original);
                this.pushs.put(original, state);
            }
            return state;
        }

        @Override
        public ISerState createState(SerializerPDA nfa, AbstractElement token) {
            AbstractElement original = this.original(token);
            ISerState state = this.states.get(original);
            if (state == null) {
                state = this.delegate.createState(nfa, original);
                this.states.put(original, state);
            }
            return state;
        }

        protected AbstractElement original(AbstractElement ele) {
            if (ele == null) {
                return null;
            }
            AbstractElement original = OriginalElement.findInEmfObject(ele).getOriginal();
            if (original == null) {
                String name = new GrammarElementTitleSwitch().showQualified().showAssignments().apply(ele);
                throw new IllegalStateException("no original grammar element found for  " + name);
            }
            return original;
        }

        @Override
        public void setFollowers(SerializerPDA nfa, ISerState owner, Iterable<ISerState> followers) {
            LinkedHashSet<ISerState> all = Sets.newLinkedHashSet(owner.getFollowers());
            Iterables.addAll(all, followers);
            this.delegate.setFollowers(nfa, owner, (Iterable<ISerState>)all);
        }
    }
}

