/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.analysis;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Parameter;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.grammaranalysis.impl.GrammarElementTitleSwitch;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.analysis.Context2NameFunction;
import org.eclipse.xtext.serializer.analysis.GrammarElementDeclarationOrder;
import org.eclipse.xtext.serializer.analysis.IContextTypePDAProvider;
import org.eclipse.xtext.serializer.analysis.IGrammarConstraintProvider;
import org.eclipse.xtext.serializer.analysis.ISemanticSequencerNfaProvider;
import org.eclipse.xtext.serializer.analysis.ISerState;
import org.eclipse.xtext.serializer.analysis.SerializationContext;
import org.eclipse.xtext.serializer.analysis.SerializationContextMap;
import org.eclipse.xtext.util.formallang.Nfa;
import org.eclipse.xtext.util.formallang.NfaToProduction;
import org.eclipse.xtext.util.formallang.NfaUtil;
import org.eclipse.xtext.util.formallang.Pda;
import org.eclipse.xtext.util.formallang.ProductionFactory;
import org.eclipse.xtext.util.formallang.ProductionFormatter;

@Singleton
public class GrammarConstraintProvider
implements IGrammarConstraintProvider {
    private static final IGrammarConstraintProvider.IConstraintElement UNINITIALIZED = new ConstraintElement(null, null, null, false, false);
    private Map<Grammar, SerializationContextMap<IGrammarConstraintProvider.IConstraint>> cache = Maps.newHashMap();
    @Inject
    protected Context2NameFunction context2Name;
    @Inject
    private ISemanticSequencerNfaProvider nfaProvider;
    @Inject
    private IContextTypePDAProvider typeProvider;
    @Inject
    private NfaUtil nfaUtil;

    protected Multimap<Parameter, Boolean> collectAllParameterValues(IGrammarConstraintProvider.IConstraint constraint) {
        LinkedHashSet<Parameter> all = Sets.newLinkedHashSet();
        List<ISerializationContext> contexts = constraint.getContexts();
        for (ISerializationContext context : contexts) {
            all.addAll(((SerializationContext)context).getDeclaredParameters());
        }
        LinkedHashMultimap<Parameter, Boolean> values = LinkedHashMultimap.create();
        for (ISerializationContext ctx : contexts) {
            Set<Parameter> params = ctx.getEnabledBooleanParameters();
            for (Parameter param : all) {
                values.put(param, params != null && params.contains(param));
            }
        }
        return values;
    }

    protected String findBestConstraintName(Grammar grammar, SerializationContextMap<Pda<ISerState, RuleCall>> typePDAs, IGrammarConstraintProvider.IConstraint constraint) {
        LinkedHashSet<ParserRule> relevantRules = Sets.newLinkedHashSet();
        LinkedHashSet<Action> relevantActions = Sets.newLinkedHashSet();
        LinkedHashSet<ParserRule> contextRules = Sets.newLinkedHashSet();
        for (ISerializationContext ctx : constraint.getContexts()) {
            ParserRule rule = ctx.getParserRule();
            if (rule == null) continue;
            contextRules.add(rule);
        }
        for (ISemanticSequencerNfaProvider.ISemState s2 : this.nfaUtil.collect(constraint.getNfa())) {
            AbstractElement element = s2.getAssignedGrammarElement();
            if (element == null) continue;
            relevantRules.add(GrammarUtil.containingParserRule(element));
        }
        for (ISerializationContext ctx : constraint.getContexts()) {
            for (Object s3 : this.nfaUtil.collect((Nfa)typePDAs.get(ctx))) {
                AbstractElement element = s3.getGrammarElement();
                if (!(element instanceof Action) || ((Action)element).getFeature() != null) continue;
                relevantRules.add(GrammarUtil.containingParserRule(element));
            }
        }
        if (relevantRules.isEmpty()) {
            LinkedHashSet<ParserRule> allRules = Sets.newLinkedHashSet(contextRules);
            for (ISerializationContext iSerializationContext : constraint.getContexts()) {
                Action action = iSerializationContext.getAssignedAction();
                if (action == null) continue;
                allRules.add(GrammarUtil.containingParserRule(action));
            }
            relevantRules.addAll(allRules);
        }
        for (ISerializationContext ctx : constraint.getContexts()) {
            ParserRule rule;
            Action action = ctx.getAssignedAction();
            if (action == null || contextRules.contains(rule = GrammarUtil.containingParserRule(action)) || !relevantRules.contains(rule)) continue;
            relevantActions.add(action);
        }
        ArrayList<String> actions2 = Lists.newArrayList();
        ArrayList<String> arrayList = Lists.newArrayList();
        Multimap<Parameter, Boolean> parameterValues = this.collectAllParameterValues(constraint);
        for (Action a : relevantActions) {
            actions2.add(this.context2Name.getUniqueActionName(a));
        }
        for (ParserRule rule : relevantRules) {
            StringBuilder segments = new StringBuilder();
            for (Parameter param : rule.getParameters()) {
                Collection<Boolean> values = parameterValues.get(param);
                if (values.size() != 1) continue;
                segments.append(String.valueOf(param.getName()) + "$" + values.iterator().next() + "$");
            }
            if (segments.length() == 0) {
                arrayList.add(rule.getName());
                continue;
            }
            arrayList.add(String.valueOf(rule.getName()) + "$" + segments);
        }
        Collections.sort(arrayList);
        String result = Joiner.on("_").join(arrayList);
        if (!actions2.isEmpty()) {
            Collections.sort(actions2);
            result = String.valueOf(result) + "_" + Joiner.on('_').join(actions2);
        }
        return result;
    }

    @Override
    public SerializationContextMap<IGrammarConstraintProvider.IConstraint> getConstraints(Grammar grammar) {
        SerializationContextMap<IGrammarConstraintProvider.IConstraint> cached = this.cache.get(grammar);
        if (cached != null) {
            return cached;
        }
        SerializationContextMap.Builder<Constraint> builder = SerializationContextMap.builder();
        GrammarElementDeclarationOrder.get(grammar);
        SerializationContextMap<Nfa<ISemanticSequencerNfaProvider.ISemState>> nfas = this.nfaProvider.getSemanticSequencerNFAs(grammar);
        for (SerializationContextMap.Entry<Nfa<ISemanticSequencerNfaProvider.ISemState>> e : nfas.values()) {
            Nfa<ISemanticSequencerNfaProvider.ISemState> nfa = e.getValue();
            for (EClass type : e.getTypes()) {
                Constraint constraint = new Constraint(grammar, type, nfa);
                List<ISerializationContext> contexts = e.getContexts(type);
                constraint.contexts.addAll(contexts);
                builder.put(contexts, constraint);
            }
        }
        SerializationContextMap<IGrammarConstraintProvider.IConstraint> result = builder.create();
        SerializationContextMap<Pda<ISerState, RuleCall>> typePDAs = this.typeProvider.getContextTypePDAs(grammar);
        for (SerializationContextMap.Entry e : result.values()) {
            Constraint constraint = (Constraint)e.getValue();
            constraint.setName(this.findBestConstraintName(grammar, typePDAs, constraint));
        }
        this.cache.put(grammar, result);
        return result;
    }

    protected static class Constraint
    implements IGrammarConstraintProvider.IConstraint {
        private IGrammarConstraintProvider.IConstraintElement body = UNINITIALIZED;
        private final List<ISerializationContext> contexts = Lists.newArrayList();
        private IGrammarConstraintProvider.IFeatureInfo[] features = null;
        private final Grammar grammar;
        private String identity;
        private String name;
        private final Nfa<ISemanticSequencerNfaProvider.ISemState> nfa;
        private final EClass type;

        public Constraint(Grammar grammar, EClass type, Nfa<ISemanticSequencerNfaProvider.ISemState> nfa) {
            this.grammar = grammar;
            this.type = type;
            this.nfa = nfa;
        }

        protected int[] computeLowerBounds() {
            int[] bounds = new int[this.type.getFeatureCount()];
            int i = 0;
            while (i < bounds.length) {
                bounds[i] = this.computeLowerBound(i);
                ++i;
            }
            return bounds;
        }

        private int computeLowerBound(int featureId) {
            ISemanticSequencerNfaProvider.ISemState currentNode = this.nfa.getStart();
            ISemanticSequencerNfaProvider.ISemState stopNode = this.nfa.getStop();
            HashMap<ISemanticSequencerNfaProvider.ISemState, DijkstraNode> idAndDistance = Maps.newHashMap();
            idAndDistance.put(currentNode, new DijkstraNode());
            TreeSet<Object> unvisited = new TreeSet<Object>(Comparator.comparing(s2 -> ((DijkstraNode)map.get((Object)s2)).distance).thenComparing(s2 -> ((DijkstraNode)map.get((Object)s2)).id));
            int nextStateId = 1;
            do {
                int currentDistance = ((DijkstraNode)idAndDistance.get((Object)currentNode)).distance;
                if (currentNode == stopNode) {
                    return currentDistance;
                }
                for (ISemanticSequencerNfaProvider.ISemState follower : currentNode.getFollowers()) {
                    int increment;
                    DijkstraNode fdn = (DijkstraNode)idAndDistance.get(follower);
                    int n = increment = follower.getFeatureID() == featureId ? 1 : 0;
                    if (fdn == null) {
                        fdn = new DijkstraNode();
                        fdn.id = nextStateId++;
                        fdn.distance = currentDistance + increment;
                        idAndDistance.put(follower, fdn);
                        unvisited.add(follower);
                        continue;
                    }
                    fdn.distance = Math.min(fdn.distance, currentDistance + increment);
                    if (!unvisited.remove(follower)) continue;
                    unvisited.add(follower);
                }
                unvisited.remove(currentNode);
            } while ((currentNode = (ISemanticSequencerNfaProvider.ISemState)unvisited.pollFirst()) != null);
            throw new AssertionError((Object)"Stop state is not reachable.");
        }

        protected int[] computeUpperBounds() {
            NfaUtil nfaUtil = new NfaUtil();
            Map<ISemanticSequencerNfaProvider.ISemState, Set<ISemanticSequencerNfaProvider.ISemState>> cycles = nfaUtil.findCycles(this.nfa);
            int[] bounds = new int[this.type.getFeatureCount()];
            for (Set<ISemanticSequencerNfaProvider.ISemState> cycle : cycles.values()) {
                for (ISemanticSequencerNfaProvider.ISemState node : cycle) {
                    int featureId = node.getFeatureID();
                    if (featureId < 0) continue;
                    bounds[featureId] = Integer.MAX_VALUE;
                }
            }
            int i = 0;
            while (i < bounds.length) {
                if (bounds[i] != Integer.MAX_VALUE) {
                    bounds[i] = this.computeUpperBound(i, this.nfa.getStart(), cycles, Maps.newHashMap());
                }
                ++i;
            }
            return bounds;
        }

        private int computeUpperBound(int featureId, ISemanticSequencerNfaProvider.ISemState node, Map<ISemanticSequencerNfaProvider.ISemState, Set<ISemanticSequencerNfaProvider.ISemState>> cycles, Map<ISemanticSequencerNfaProvider.ISemState, Integer> computedDistances) {
            Integer distance = computedDistances.get(node);
            if (distance != null) {
                return distance;
            }
            if (cycles.containsKey(node)) {
                Set<ISemanticSequencerNfaProvider.ISemState> cycle = cycles.get(node);
                int maxDistance = 0;
                for (ISemanticSequencerNfaProvider.ISemState cycleNode : cycle) {
                    for (ISemanticSequencerNfaProvider.ISemState follower : cycleNode.getFollowers()) {
                        if (cycle.contains(follower)) continue;
                        int followerDistance = this.computeUpperBound(featureId, follower, cycles, computedDistances);
                        maxDistance = Math.max(maxDistance, followerDistance);
                    }
                }
                for (ISemanticSequencerNfaProvider.ISemState cycleNode : cycle) {
                    computedDistances.put(cycleNode, maxDistance);
                }
                return maxDistance;
            }
            int increment = node.getFeatureID() == featureId ? 1 : 0;
            int maxDistance = 0;
            for (ISemanticSequencerNfaProvider.ISemState follower : node.getFollowers()) {
                int followerDistance = this.computeUpperBound(featureId, follower, cycles, computedDistances);
                maxDistance = Math.max(maxDistance, followerDistance + increment);
            }
            computedDistances.put(node, maxDistance);
            return maxDistance;
        }

        @Override
        public int compareTo(IGrammarConstraintProvider.IConstraint o) {
            return this.getName().compareTo(o.getName());
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            return this.getIdentity().equals(((Constraint)obj).getIdentity());
        }

        @Override
        public IGrammarConstraintProvider.IConstraintElement getBody() {
            if (this.body == UNINITIALIZED) {
                GrammarElementDeclarationOrder order;
                ConstraintElementFactory factory = new ConstraintElementFactory(this);
                NfaToProduction n2p = new NfaToProduction().excludeStartAndStop();
                IGrammarConstraintProvider.IConstraintElement element = n2p.nfaToGrammar(this.nfa, ISemanticSequencerNfaProvider.GET_ASSIGNED_GRAMMAR_ELEMENT, order = GrammarElementDeclarationOrder.get(this.grammar), factory);
                this.body = element.getType() == IGrammarConstraintProvider.ConstraintElementType.GROUP && element.getChildren().isEmpty() ? null : element;
            }
            return this.body;
        }

        @Override
        public List<ISerializationContext> getContexts() {
            return this.contexts;
        }

        @Override
        public IGrammarConstraintProvider.IFeatureInfo[] getFeatures() {
            if (this.features == null) {
                if (this.type == null) {
                    this.features = new IGrammarConstraintProvider.IFeatureInfo[0];
                } else {
                    int count = this.type.getFeatureCount();
                    this.features = new IGrammarConstraintProvider.IFeatureInfo[count];
                    int[] lowerBounds = this.computeLowerBounds();
                    int[] upperBounds = this.computeUpperBounds();
                    int i = 0;
                    while (i < count) {
                        EStructuralFeature feature = this.type.getEStructuralFeature(i);
                        this.features[i] = new FeatureInfo(this, feature, upperBounds[i], lowerBounds[i]);
                        ++i;
                    }
                }
            }
            return this.features;
        }

        protected String getIdentity() {
            if (this.identity == null) {
                String nfaString = new NfaUtil().identityString(this.nfa, new Function<ISemanticSequencerNfaProvider.ISemState, String>(){

                    @Override
                    public String apply(ISemanticSequencerNfaProvider.ISemState input) {
                        AbstractElement element = input.getAssignedGrammarElement();
                        return element == null ? null : EcoreUtil.getURI(element).toString();
                    }
                });
                String typeString = this.type == null ? "null" : String.valueOf(this.type.getName()) + "@" + this.type.getEPackage().getNsURI();
                this.identity = String.valueOf(typeString) + "\n" + nfaString;
            }
            return this.identity;
        }

        @Override
        public String getName() {
            return String.valueOf(this.name) + "_" + (this.type == null ? "null" : this.type.getName());
        }

        @Override
        public Nfa<ISemanticSequencerNfaProvider.ISemState> getNfa() {
            return this.nfa;
        }

        @Override
        public String getSimpleName() {
            return this.name;
        }

        @Override
        public EClass getType() {
            return this.type;
        }

        public int hashCode() {
            return this.getIdentity().hashCode();
        }

        protected void setName(String name) {
            this.name = name;
        }

        public String toString() {
            String typeName = this.getType() == null ? "null" : this.getType().getName();
            String body = this.getBody() != null ? this.getBody().toString() : "{" + typeName + "}";
            return String.valueOf(this.getName()) + " returns " + typeName + ": " + body + ";";
        }

        private static class DijkstraNode {
            int id;
            int distance;

            private DijkstraNode() {
            }
        }
    }

    protected static class ConstraintElement
    implements IGrammarConstraintProvider.IConstraintElement {
        private final Collection<IGrammarConstraintProvider.IConstraintElement> children;
        private final IGrammarConstraintProvider.IConstraint constraint;
        private final AbstractElement element;
        private final boolean many;
        private final boolean optional;
        private IGrammarConstraintProvider.IConstraintElement parent;
        private final IGrammarConstraintProvider.ConstraintElementType type;

        public ConstraintElement(IGrammarConstraintProvider.IConstraint constraint, IGrammarConstraintProvider.ConstraintElementType type, AbstractElement element, boolean many, boolean optional) {
            this.constraint = constraint;
            this.type = type;
            this.element = element;
            this.children = null;
            this.many = many;
            this.optional = optional;
        }

        public ConstraintElement(IGrammarConstraintProvider.IConstraint constraint, IGrammarConstraintProvider.ConstraintElementType type, Collection<IGrammarConstraintProvider.IConstraintElement> children, boolean many, boolean optional) {
            this.constraint = constraint;
            this.type = type;
            this.element = null;
            this.children = children;
            this.many = many;
            this.optional = optional;
            for (IGrammarConstraintProvider.IConstraintElement child : children) {
                ((ConstraintElement)child).parent = this;
            }
        }

        @Override
        public Collection<IGrammarConstraintProvider.IConstraintElement> getChildren() {
            return this.children == null ? Collections.emptyList() : this.children;
        }

        @Override
        public IGrammarConstraintProvider.IConstraintElement getContainer() {
            return this.parent;
        }

        @Override
        public IGrammarConstraintProvider.IConstraint getContainingConstraint() {
            return this.constraint;
        }

        public String getFeatureName() {
            if (this.element instanceof Action) {
                return ((Action)this.element).getFeature();
            }
            Assignment assignment = GrammarUtil.containingAssignment(this.element);
            if (assignment != null) {
                return assignment.getFeature();
            }
            return null;
        }

        @Override
        public AbstractElement getGrammarElement() {
            return this.element;
        }

        @Override
        public IGrammarConstraintProvider.ConstraintElementType getType() {
            return this.type;
        }

        @Override
        public boolean isMany() {
            return this.many;
        }

        @Override
        public boolean isOptional() {
            return this.optional;
        }

        public String toString() {
            GrammarElementTitleSwitch t2s = new GrammarElementTitleSwitch().hideCardinality().showActionsAsRuleCalls().showAssignments();
            ProductionFormatter<ConstraintElement, AbstractElement> formatter = new ProductionFormatter<ConstraintElement, AbstractElement>();
            formatter.setTokenToString(t2s);
            return formatter.format(new IGrammarConstraintProvider.ConstraintElementProduction(this.getContainingConstraint()), this, true);
        }
    }

    protected static class ConstraintElementFactory
    implements ProductionFactory<IGrammarConstraintProvider.IConstraintElement, AbstractElement> {
        private final IGrammarConstraintProvider.IConstraint constraint;

        public ConstraintElementFactory(IGrammarConstraintProvider.IConstraint constraint) {
            this.constraint = constraint;
        }

        @Override
        public IGrammarConstraintProvider.IConstraintElement createForAlternativeChildren(boolean m4, boolean o, Iterable<IGrammarConstraintProvider.IConstraintElement> c) {
            return new ConstraintElement(this.constraint, IGrammarConstraintProvider.ConstraintElementType.ALTERNATIVE, ImmutableSet.copyOf(c), m4, o);
        }

        @Override
        public IGrammarConstraintProvider.IConstraintElement createForSequentialChildren(boolean m4, boolean o, Iterable<IGrammarConstraintProvider.IConstraintElement> c) {
            return new ConstraintElement(this.constraint, IGrammarConstraintProvider.ConstraintElementType.GROUP, ImmutableList.copyOf(c), m4, o);
        }

        @Override
        public IGrammarConstraintProvider.IConstraintElement createForToken(boolean many, boolean optional, AbstractElement token) {
            IGrammarConstraintProvider.ConstraintElementType type = token == null ? null : IGrammarConstraintProvider.ConstraintElementType.getConstraintElementType(token);
            return new ConstraintElement(this.constraint, type, token, many, optional);
        }

        @Override
        public IGrammarConstraintProvider.IConstraintElement createForUnordertedChildren(boolean m4, boolean o, Iterable<IGrammarConstraintProvider.IConstraintElement> c) {
            return new ConstraintElement(this.constraint, IGrammarConstraintProvider.ConstraintElementType.UNORDERED_GROUP, ImmutableSet.copyOf(c), m4, o);
        }
    }

    protected static class FeatureInfo
    implements IGrammarConstraintProvider.IFeatureInfo {
        private List<IGrammarConstraintProvider.IConstraintElement> assignments = null;
        private final Constraint constraint;
        private final EStructuralFeature feature;
        private final int lowerBound;
        private final int upperBound;

        public FeatureInfo(Constraint constraint, EStructuralFeature feature, int upperBound, int lowerBound) {
            this.constraint = constraint;
            this.feature = feature;
            this.upperBound = upperBound;
            this.lowerBound = lowerBound;
        }

        @Override
        public List<IGrammarConstraintProvider.IConstraintElement> getAssignments() {
            if (this.assignments == null) {
                IGrammarConstraintProvider.IConstraintElement body = this.constraint.getBody();
                if (body == null) {
                    this.assignments = Collections.emptyList();
                } else {
                    this.assignments = Lists.newArrayList();
                    LinkedList<IGrammarConstraintProvider.IConstraintElement> stack = new LinkedList<IGrammarConstraintProvider.IConstraintElement>();
                    stack.push(body);
                    while (!stack.isEmpty()) {
                        IGrammarConstraintProvider.IConstraintElement element = (IGrammarConstraintProvider.IConstraintElement)stack.pop();
                        String name = ((ConstraintElement)element).getFeatureName();
                        if (this.feature.getName().equals(name)) {
                            this.assignments.add(element);
                        }
                        stack.addAll(element.getChildren());
                    }
                }
            }
            return this.assignments;
        }

        @Override
        public IGrammarConstraintProvider.IConstraint getContainingConstraint() {
            return this.constraint;
        }

        @Override
        public EStructuralFeature getFeature() {
            return this.feature;
        }

        @Override
        public int getLowerBound() {
            return this.lowerBound;
        }

        @Override
        public int getUpperBound() {
            return this.upperBound;
        }
    }
}

