/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.scoping.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.ISelectable;
import org.eclipse.xtext.resource.impl.AliasedEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.AbstractScope;
import org.eclipse.xtext.scoping.impl.ImportNormalizer;
import org.eclipse.xtext.scoping.impl.ScopeBasedSelectable;

public class ImportScope
extends AbstractScope {
    private final List<ImportNormalizer> normalizers;
    private final ISelectable importFrom;
    private final EClass type;

    public ImportScope(List<ImportNormalizer> namespaceResolvers, IScope parent, ISelectable importFrom, EClass type, boolean ignoreCase) {
        super(parent, ignoreCase);
        this.type = type;
        this.normalizers = this.removeDuplicates(namespaceResolvers);
        this.importFrom = importFrom;
    }

    protected List<ImportNormalizer> removeDuplicates(List<ImportNormalizer> namespaceResolvers) {
        ArrayList<ImportNormalizer> list = Lists.newArrayList();
        for (ImportNormalizer importNormalizer : namespaceResolvers) {
            if (list.contains(importNormalizer)) continue;
            list.add(importNormalizer);
        }
        return list;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + this.normalizers + " imports from " + this.importFrom + " for type " + this.type.getName();
    }

    @Override
    public Iterable<IEObjectDescription> getAllElements() {
        Iterable<IEObjectDescription> globalElements = this.getParent().getAllElements();
        Iterable<IEObjectDescription> aliased = this.getAllLocalElements();
        final HashSet<QualifiedName> elements = Sets.newHashSet();
        for (IEObjectDescription from : aliased) {
            QualifiedName qn = this.getIgnoreCaseAwareQualifiedName(from);
            elements.add(qn);
        }
        return Iterables.concat(aliased, Iterables.filter(globalElements, new Predicate<IEObjectDescription>(){

            @Override
            public boolean apply(IEObjectDescription input) {
                return !elements.contains(ImportScope.this.getIgnoreCaseAwareQualifiedName(input));
            }
        }));
    }

    protected QualifiedName getIgnoreCaseAwareQualifiedName(IEObjectDescription from) {
        return this.isIgnoreCase() ? from.getName().toLowerCase() : from.getName();
    }

    @Override
    protected Iterable<IEObjectDescription> getAllLocalElements() {
        Iterable<IEObjectDescription> exportedObjects = this.getImportFrom().getExportedObjectsByType(this.type);
        return this.getAliasedElements(exportedObjects);
    }

    @Override
    protected Iterable<IEObjectDescription> getLocalElementsByEObject(EObject object, URI uri) {
        Iterable<IEObjectDescription> candidates = this.getImportFrom().getExportedObjectsByObject(object);
        Iterable<IEObjectDescription> aliasedElements = this.getAliasedElements(candidates);
        return Iterables.filter(aliasedElements, new Predicate<IEObjectDescription>(){

            @Override
            public boolean apply(IEObjectDescription input) {
                IEObjectDescription description = ImportScope.this.getSingleLocalElementByName(input.getName());
                if (description == null) {
                    return false;
                }
                if (description.getEObjectOrProxy() == input.getEObjectOrProxy()) {
                    return true;
                }
                return input.getEObjectURI().equals(description.getEObjectURI());
            }
        });
    }

    protected Iterable<IEObjectDescription> getAliasedElements(Iterable<IEObjectDescription> candidates) {
        LinkedHashMultimap<QualifiedName, AliasedEObjectDescription> keyToDescription = LinkedHashMultimap.create();
        HashMultimap<QualifiedName, ImportNormalizer> keyToNormalizer = HashMultimap.create();
        for (IEObjectDescription imported : candidates) {
            QualifiedName fullyQualifiedName = imported.getName();
            for (ImportNormalizer normalizer : this.normalizers) {
                QualifiedName alias = normalizer.deresolve(fullyQualifiedName);
                if (alias == null) continue;
                QualifiedName key = alias;
                if (this.isIgnoreCase()) {
                    key = key.toLowerCase();
                }
                keyToDescription.put(key, new AliasedEObjectDescription(alias, imported));
                keyToNormalizer.put(key, normalizer);
            }
        }
        for (QualifiedName name : keyToNormalizer.keySet()) {
            if (keyToNormalizer.get(name).size() <= 1) continue;
            keyToDescription.removeAll(name);
        }
        return keyToDescription.values();
    }

    @Override
    protected IEObjectDescription getSingleLocalElementByName(QualifiedName name) {
        Iterator<IEObjectDescription> iterator = this.getLocalElementsByName(name).iterator();
        return iterator.hasNext() ? iterator.next() : null;
    }

    @Override
    protected Iterable<IEObjectDescription> getLocalElementsByName(QualifiedName name) {
        ArrayList<IEObjectDescription> result = Lists.newArrayList();
        QualifiedName resolvedQualifiedName = null;
        ISelectable importFrom = this.getImportFrom();
        for (ImportNormalizer normalizer : this.normalizers) {
            QualifiedName resolvedName = normalizer.resolve(name);
            if (resolvedName == null) continue;
            Iterable<IEObjectDescription> resolvedElements = importFrom.getExportedObjects(this.type, resolvedName, this.isIgnoreCase());
            for (IEObjectDescription resolvedElement : resolvedElements) {
                if (resolvedQualifiedName == null) {
                    resolvedQualifiedName = resolvedName;
                } else if (!resolvedQualifiedName.equals(resolvedName) && ((IEObjectDescription)result.get(0)).getEObjectOrProxy() != resolvedElement.getEObjectOrProxy()) {
                    return Collections.emptyList();
                }
                QualifiedName alias = normalizer.deresolve(resolvedElement.getName());
                if (alias == null) {
                    throw new IllegalStateException("Couldn't deresolve " + resolvedElement.getName() + " with import " + normalizer);
                }
                AliasedEObjectDescription aliasedEObjectDescription = new AliasedEObjectDescription(alias, resolvedElement);
                result.add(aliasedEObjectDescription);
            }
        }
        return result;
    }

    protected ISelectable getImportFrom() {
        ISelectable importFrom = this.importFrom;
        if (importFrom == null) {
            importFrom = new ScopeBasedSelectable(this.getParent());
        }
        return importFrom;
    }
}

