/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.scoping.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.google.inject.Provider;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;

public abstract class AbstractScope
implements IScope {
    private final boolean ignoreCase;
    private final IScope parent;

    protected AbstractScope(IScope parent, boolean ignoreCase) {
        if (parent == null) {
            throw new IllegalArgumentException("parent may not be null. Use IScope.NULLSCOPE instead.");
        }
        this.parent = parent;
        this.ignoreCase = ignoreCase;
    }

    public IScope getParent() {
        return this.parent;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    @Override
    public IEObjectDescription getSingleElement(QualifiedName name) {
        IEObjectDescription result = this.getSingleLocalElementByName(name);
        if (result != null) {
            return result;
        }
        return this.getParent().getSingleElement(name);
    }

    protected IEObjectDescription getSingleLocalElementByName(QualifiedName name) {
        Iterable<IEObjectDescription> result = this.getLocalElementsByName(name);
        Iterator<IEObjectDescription> iterator = result.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    @Override
    public Iterable<IEObjectDescription> getAllElements() {
        Iterable<IEObjectDescription> localElements = this.getAllLocalElements();
        Iterable<IEObjectDescription> parentElements = this.getParentElements(new Provider<Iterable<IEObjectDescription>>(){

            @Override
            public Iterable<IEObjectDescription> get() {
                return AbstractScope.this.getParent().getAllElements();
            }
        });
        Iterable<IEObjectDescription> result = Iterables.concat(localElements, parentElements);
        return result;
    }

    @Override
    public Iterable<IEObjectDescription> getElements(final QualifiedName name) {
        Iterable<IEObjectDescription> localElements = this.getLocalElementsByName(name);
        if (localElements instanceof Collection && ((Collection)localElements).isEmpty()) {
            return this.getParent().getElements(name);
        }
        Iterable<IEObjectDescription> parentElements = this.getParentElements(new Provider<Iterable<IEObjectDescription>>(){

            @Override
            public Iterable<IEObjectDescription> get() {
                return AbstractScope.this.getParent().getElements(name);
            }
        });
        Iterable<IEObjectDescription> result = Iterables.concat(localElements, parentElements);
        return result;
    }

    @Override
    public IEObjectDescription getSingleElement(EObject object) {
        Iterable<IEObjectDescription> elements = this.getElements(object);
        Iterator<IEObjectDescription> iterator = elements.iterator();
        if (iterator.hasNext()) {
            IEObjectDescription result = iterator.next();
            return result;
        }
        return null;
    }

    @Override
    public Iterable<IEObjectDescription> getElements(final EObject object) {
        URI uri = EcoreUtil2.getPlatformResourceOrNormalizedURI(object);
        Iterable<IEObjectDescription> localElements = this.getLocalElementsByEObject(object, uri);
        Iterable<IEObjectDescription> parentElements = this.getParentElements(new Provider<Iterable<IEObjectDescription>>(){

            @Override
            public Iterable<IEObjectDescription> get() {
                return AbstractScope.this.getParent().getElements(object);
            }
        });
        Iterable<IEObjectDescription> result = Iterables.concat(localElements, parentElements);
        return result;
    }

    protected abstract Iterable<IEObjectDescription> getAllLocalElements();

    protected Iterable<IEObjectDescription> getLocalElementsByName(final QualifiedName name) {
        Iterable<IEObjectDescription> localElements = this.getAllLocalElements();
        Iterable<IEObjectDescription> result = Iterables.filter(localElements, new Predicate<IEObjectDescription>(){

            @Override
            public boolean apply(IEObjectDescription input) {
                if (AbstractScope.this.isIgnoreCase()) {
                    return name.equalsIgnoreCase(input.getName());
                }
                return name.equals(input.getName());
            }
        });
        return result;
    }

    protected Iterable<IEObjectDescription> getLocalElementsByEObject(final EObject object, final URI uri) {
        Iterable<IEObjectDescription> localElements = this.getAllLocalElements();
        Iterable<IEObjectDescription> result = Iterables.filter(localElements, new Predicate<IEObjectDescription>(){

            @Override
            public boolean apply(IEObjectDescription input) {
                if (input.getEObjectOrProxy() == object) {
                    return this.canBeFoundByName(input);
                }
                if (uri.equals(input.getEObjectURI())) {
                    return this.canBeFoundByName(input);
                }
                return false;
            }

            public boolean canBeFoundByName(IEObjectDescription input) {
                IEObjectDescription lookUp = AbstractScope.this.getSingleLocalElementByName(input.getName());
                if (lookUp != null) {
                    if (lookUp == input) {
                        return true;
                    }
                    if (lookUp.getEObjectOrProxy() == object) {
                        return true;
                    }
                    if (uri.equals(lookUp.getEObjectURI())) {
                        return true;
                    }
                }
                return false;
            }
        });
        return result;
    }

    protected Iterable<IEObjectDescription> getParentElements(Provider<Iterable<IEObjectDescription>> provider) {
        if (this.getParent() == IScope.NULLSCOPE) {
            return Collections.emptyList();
        }
        return new ParentIterable(this, provider);
    }

    protected boolean isShadowed(IEObjectDescription input) {
        Iterable<IEObjectDescription> localElements = this.getLocalElementsByName(input.getName());
        boolean isEmpty = Iterables.isEmpty(localElements);
        return !isEmpty;
    }

    public String toString() {
        String parentString = null;
        try {
            IScope parent = this.getParent();
            parentString = parent.toString();
        }
        catch (Throwable t2) {
            parentString = String.valueOf(t2.getClass().getSimpleName()) + " : " + t2.getMessage();
        }
        return String.valueOf(this.getClass().getSimpleName()) + (this.ignoreCase ? "[ignore case]" : "") + this.getAllLocalElements() + " -> " + parentString;
    }

    protected static class ParentIterable
    implements Iterable<IEObjectDescription>,
    Predicate<IEObjectDescription> {
        private final AbstractScope scope;
        private final Provider<Iterable<IEObjectDescription>> provider;
        private Iterable<IEObjectDescription> parentElements;

        protected ParentIterable(AbstractScope scope, Provider<Iterable<IEObjectDescription>> provider) {
            this.scope = scope;
            this.provider = provider;
        }

        @Override
        public Iterator<IEObjectDescription> iterator() {
            if (this.parentElements == null) {
                this.parentElements = this.provider.get();
            }
            Iterator<IEObjectDescription> parentIterator = this.parentElements.iterator();
            UnmodifiableIterator<IEObjectDescription> filteredIterator = Iterators.filter(parentIterator, this);
            return filteredIterator;
        }

        @Override
        public boolean apply(IEObjectDescription input) {
            return !this.scope.isShadowed(input);
        }

        public String toString() {
            return Iterables.toString(this);
        }
    }
}

