/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.impl;

import com.google.common.collect.Iterables;
import java.util.Iterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.util.Arrays;

public class DefaultResourceDescriptionDelta
implements IResourceDescription.Delta {
    private IResourceDescription _new;
    private IResourceDescription old;
    private Boolean hasChanges;

    public DefaultResourceDescriptionDelta(IResourceDescription old, IResourceDescription _new) {
        if (old == _new) {
            throw new AssertionError((Object)"'old!=_new' constraint violated");
        }
        if (_new != null && old != null && !old.getURI().equals(_new.getURI())) {
            URI oldURI = old.getURI();
            URI newURI = _new.getURI();
            throw new AssertionError((Object)("'_new!=null && old!=null && !old.getURI().equals(_new.getURI())' constraint violated, old was " + oldURI + " new was: " + newURI));
        }
        this.old = old;
        this._new = _new;
    }

    @Override
    public IResourceDescription getNew() {
        return this._new;
    }

    @Override
    public IResourceDescription getOld() {
        return this.old;
    }

    @Override
    public boolean haveEObjectDescriptionsChanged() {
        if (this.hasChanges == null) {
            this.hasChanges = this.internalHasChanges();
        }
        return this.hasChanges;
    }

    protected boolean internalHasChanges() {
        if (this._new == null || this.old == null) {
            return true;
        }
        Iterable<IEObjectDescription> oldEObjects = this.old.getExportedObjects();
        Iterable<IEObjectDescription> newEObjects = this._new.getExportedObjects();
        if (Iterables.size(oldEObjects) != Iterables.size(newEObjects)) {
            return true;
        }
        Iterator<IEObjectDescription> iterator1 = oldEObjects.iterator();
        Iterator<IEObjectDescription> iterator2 = newEObjects.iterator();
        while (iterator1.hasNext()) {
            if (this.equals(iterator1.next(), iterator2.next())) continue;
            return true;
        }
        return false;
    }

    protected boolean equals(IEObjectDescription oldObj, IEObjectDescription newObj) {
        String[] newKeys;
        if (oldObj == newObj) {
            return true;
        }
        if (oldObj.getEClass() != newObj.getEClass()) {
            return false;
        }
        if (oldObj.getName() != null && !oldObj.getName().equals(newObj.getName())) {
            return false;
        }
        if (!oldObj.getEObjectURI().equals(newObj.getEObjectURI())) {
            return false;
        }
        String[] oldKeys = oldObj.getUserDataKeys();
        if (oldKeys.length != (newKeys = newObj.getUserDataKeys()).length) {
            return false;
        }
        String[] stringArray = oldKeys;
        int n = oldKeys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            if (!Arrays.contains(newKeys, key)) {
                return false;
            }
            String oldValue = oldObj.getUserData(key);
            String newValue = newObj.getUserData(key);
            if (oldValue == null ? newValue != null : !oldValue.equals(newValue)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public URI getUri() {
        return this.old == null ? this._new.getURI() : this.old.getURI();
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " for " + this.getUri() + " old :" + (this.getOld() != null) + ",new :" + (this.getNew() != null);
    }
}

