/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.nodemodel.serialization;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.nodemodel.impl.RootNode;
import org.eclipse.xtext.nodemodel.serialization.SerializationUtil;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;

public class SerializationConversionContext {
    private final Map<EObject, Integer> grammarElementToIdMap = new IdentityHashMap<EObject, Integer>();
    private final ArrayList<String> grammarIdToURIMap = new ArrayList();
    private final Map<EObject, Integer> eObjectToIdMap = new IdentityHashMap<EObject, Integer>();

    public SerializationConversionContext(XtextResource resource) {
        this.fillEObjectToIdMap(resource);
        this.fillGrammarElementToIdMap(resource);
    }

    public Integer getGrammarElementId(EObject grammarElement) {
        Integer id = this.grammarElementToIdMap.get(grammarElement);
        if (id == null) {
            throw new IllegalArgumentException("Trying to fetch a grammar element that does not (no longer) exists with id: " + id);
        }
        return id;
    }

    protected void fillEObjectToIdMap(Resource resource) {
        ArrayList<EObject> idToEObjectMap = new ArrayList<EObject>();
        SerializationUtil.fillIdToEObjectMap(resource, idToEObjectMap);
        int id = 0;
        while (id < idToEObjectMap.size()) {
            this.eObjectToIdMap.put(idToEObjectMap.get(id), id);
            ++id;
        }
    }

    protected void fillGrammarElementToIdMap(XtextResource r) {
        IParseResult parseResult = r.getParseResult();
        if (parseResult != null) {
            RootNode it = (RootNode)parseResult.getRootNode();
            it.fillGrammarElementToIdMap(this.grammarElementToIdMap, this.grammarIdToURIMap);
        }
    }

    public Integer getEObjectId(EObject eObject) {
        Integer id = this.eObjectToIdMap.get(eObject);
        if (id == null) {
            throw new IllegalArgumentException("Tryin to fetch an EMF object that does not exist (no longer) with id: " + id);
        }
        return id;
    }

    public String[] getGrammarIdToURIMap() {
        String[] map = this.grammarIdToURIMap.toArray(new String[this.grammarIdToURIMap.size()]);
        return map;
    }
}

