/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.nodemodel.impl;

import com.google.common.collect.Maps;
import com.google.common.collect.ObjectArrays;
import java.util.Map;
import java.util.Objects;
import org.eclipse.emf.ecore.EObject;

public class GrammarElementsInterner {
    private final Map<InternKey, EObject[]> interningMap = Maps.newHashMap();

    EObject[] prependAndIntern(EObject grammarElement, Object grammarElements) {
        InternKey internKey = new InternKey(grammarElement, grammarElements);
        return this.interningMap.computeIfAbsent(internKey, key -> key.prependedGrammarElements());
    }

    EObject[] appendAndIntern(Object grammarElements, EObject grammarElement) {
        InternKey internKey = new InternKey(grammarElement, grammarElements);
        return this.interningMap.computeIfAbsent(internKey, key -> key.appendedGrammarElements());
    }

    private static class InternKey {
        final EObject grammarElement;
        final Object grammarElements;
        int hashCode = -1;

        InternKey(EObject grammarElement, Object grammarElements) {
            this.grammarElement = grammarElement;
            this.grammarElements = grammarElements;
        }

        EObject[] prependedGrammarElements() {
            if (this.grammarElements instanceof EObject) {
                return new EObject[]{this.grammarElement, (EObject)this.grammarElements};
            }
            return ObjectArrays.concat(this.grammarElement, (EObject[])this.grammarElements);
        }

        EObject[] appendedGrammarElements() {
            if (this.grammarElements instanceof EObject) {
                return new EObject[]{(EObject)this.grammarElements, this.grammarElement};
            }
            return ObjectArrays.concat((EObject[])this.grammarElements, this.grammarElement);
        }

        public int hashCode() {
            if (this.hashCode == -1) {
                this.hashCode = Objects.hash(this.grammarElement, this.grammarElements);
            }
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (o instanceof InternKey) {
                InternKey interned = (InternKey)o;
                return Objects.equals(this.grammarElement, interned.grammarElement) && Objects.equals(this.grammarElements, interned.grammarElements);
            }
            return false;
        }
    }
}

