/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.grammaranalysis.impl;

import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.GrammarToDot;
import org.eclipse.xtext.grammaranalysis.IGrammarNFAProvider;
import org.eclipse.xtext.grammaranalysis.impl.DefaultForwardNFAProvider;
import org.eclipse.xtext.grammaranalysis.impl.DefaultNFAState;
import org.eclipse.xtext.grammaranalysis.impl.DefaultNFATransition;
import org.eclipse.xtext.util.GraphvizDotBuilder;

public class NFAToDot
extends GrammarToDot {
    protected IGrammarNFAProvider<DefaultNFAState, DefaultNFATransition> nfaProvider = new DefaultForwardNFAProvider();

    @Override
    protected GraphvizDotBuilder.Node drawAbstractElementTree(AbstractElement ele, GraphvizDotBuilder.Digraph d) {
        GraphvizDotBuilder.Node n = super.drawAbstractElementTree(ele, d);
        DefaultNFAState nfas = this.nfaProvider.getNFA(ele);
        for (DefaultNFATransition t2 : nfas.getOutgoing()) {
            d.add(this.drawFollowerEdge(ele, t2, false));
        }
        for (DefaultNFATransition t2 : nfas.getOutgoingAfterReturn()) {
            d.add(this.drawFollowerEdge(ele, t2, true));
        }
        if (nfas.getOutgoing().size() == 0 && nfas.getOutgoingAfterReturn().size() == 0 && !nfas.isEndState()) {
            n.setStyle("dotted");
        }
        if (nfas.isEndState()) {
            n.put("peripheries", "2");
        }
        return n;
    }

    protected GraphvizDotBuilder.Edge drawFollowerEdge(AbstractElement ele, DefaultNFATransition t2, boolean isParent) {
        GraphvizDotBuilder.Edge e = new GraphvizDotBuilder.Edge(this, ele, ((DefaultNFAState)t2.getTarget()).getGrammarElement());
        e.setLabel(String.valueOf(t2.getPrecedence()));
        e.setStyle("dotted");
        if (isParent) {
            e.put("arrowtail", "odot");
        }
        if (t2.isRuleCall()) {
            e.put("arrowhead", "onormalonormal");
        } else {
            e.put("arrowhead", "onormal");
        }
        return e;
    }
}

