/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.grammaranalysis.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.grammaranalysis.INFAState;
import org.eclipse.xtext.grammaranalysis.IPDAProvider;
import org.eclipse.xtext.grammaranalysis.IPDAState;
import org.eclipse.xtext.grammaranalysis.impl.GrammarElementTitleSwitch;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;

public abstract class AbstractPDAProvider<CTX>
implements IPDAProvider<CTX> {
    protected abstract boolean canEnterRuleCall(INFAState<?, ?> var1);

    protected abstract boolean canPass(CTX var1, INFAState<?, ?> var2, EClass var3);

    protected EClass getConstructedType(AbstractElement ele) {
        if (ele instanceof Action) {
            return (EClass)((Action)ele).getType().getClassifier();
        }
        if (GrammarUtil.containingAssignment(ele) != null) {
            return (EClass)GrammarUtil.containingRule(ele).getType().getClassifier();
        }
        return null;
    }

    protected boolean canReachContextEnd(PDAContext<CTX> context, RuleCallStackElement stack, INFAState<?, ?> fromNfa, EClass constructedType, boolean returning, boolean canReturn, Set<Pair<Boolean, INFAState<?, ?>>> visited) {
        if (stack == null || !visited.add(Tuples.create(returning, fromNfa))) {
            return false;
        }
        if (!this.canPass(context.context, fromNfa, constructedType)) {
            return false;
        }
        if (constructedType == null) {
            constructedType = this.getConstructedType(fromNfa.getGrammarElement());
        }
        if (this.isFinalState(context.context, fromNfa, returning, canReturn)) {
            return true;
        }
        if (!returning && this.canEnterRuleCall(fromNfa)) {
            if (stack.hasEnteredTwice(fromNfa)) {
                return false;
            }
            stack = this.stackPush(stack, fromNfa);
            visited = Sets.newHashSet();
        }
        for (INFAState<?, ?> follower : this.getFollowers(context.context, fromNfa, returning, canReturn)) {
            boolean targetReturning;
            boolean targetCanReturn = !this.canEnterRuleCall(follower);
            boolean bl = targetReturning = follower.hasOutgoingRuleCall() && targetCanReturn;
            if (!this.canReachContextEnd(context, stack, follower, constructedType, targetReturning, targetCanReturn, visited)) continue;
            return true;
        }
        if (canReturn && fromNfa.isEndState() && stack != null && stack.getRuleCall() != null) {
            visited = Sets.newHashSet();
            if (this.canReachContextEnd(context, stack.getParent(), stack.getRuleCall(), constructedType, true, true, visited)) {
                return true;
            }
        }
        return false;
    }

    protected PDAContext<CTX> createContext(CTX obj) {
        return new PDAContext<CTX>(obj);
    }

    protected PDAState createState(IPDAState.PDAStateType type, AbstractElement element) {
        return new PDAState(type, element);
    }

    protected PDAState createState(PDAContext<CTX> ctx, RuleCallStackElement stack, INFAState<?, ?> fromNfa, EClass constructedType, boolean returning, boolean canReturn, Set<Pair<Boolean, INFAState<?, ?>>> visited) {
        HashSet<Pair<Boolean, INFAState<?, ?>>> visited2 = Sets.newHashSet();
        if (stack == null || !this.canReachContextEnd(ctx, stack.cloneWithoutVisited(), fromNfa, constructedType, returning, canReturn, visited2)) {
            return null;
        }
        if (constructedType == null) {
            constructedType = this.getConstructedType(fromNfa.getGrammarElement());
        }
        AbstractElement ge = fromNfa.getGrammarElement();
        PDAState result = null;
        if (this.canEnterRuleCall(fromNfa)) {
            if (returning) {
                result = ctx.ruleCallExit.get(fromNfa);
                if (result == null) {
                    result = this.createState(IPDAState.PDAStateType.RULECALL_EXIT, ge);
                    ctx.ruleCallExit.put(fromNfa, result);
                }
            } else {
                result = ctx.ruleCallEnter.get(fromNfa);
                if (result == null) {
                    result = this.createState(IPDAState.PDAStateType.RULECALL_ENTER, ge);
                    ctx.ruleCallEnter.put(fromNfa, result);
                }
            }
        } else {
            result = ctx.elements.get(fromNfa);
            if (result == null) {
                result = this.createState(IPDAState.PDAStateType.ELEMENT, ge);
                ctx.elements.put(fromNfa, result);
            }
        }
        if (!visited.add(Tuples.create(returning, fromNfa))) {
            return result;
        }
        if (!returning && this.canEnterRuleCall(fromNfa)) {
            if (stack.hasEnteredTwice(fromNfa)) {
                return result;
            }
            stack = this.stackPush(stack, fromNfa);
            visited = Sets.newHashSet();
        }
        if (result.followers == null || result.followers == Collections.EMPTY_SET) {
            result.followers = Sets.newHashSet();
        }
        if (this.isFinalState(ctx.context, fromNfa, returning, canReturn)) {
            result.followers.add(ctx.stop);
        }
        for (INFAState<?, ?> follower : this.getFollowers(ctx.context, fromNfa, returning, canReturn)) {
            boolean folCanReturn = !this.canEnterRuleCall(follower);
            boolean folReturning = follower.hasOutgoingRuleCall() && folCanReturn;
            PDAState r = this.createState(ctx, stack, follower, constructedType, folReturning, folCanReturn, visited);
            if (r == null) continue;
            result.followers.add(r);
        }
        if (canReturn && fromNfa.isEndState() && stack != null && stack.getRuleCall() != null) {
            visited = Sets.newHashSet();
            PDAState r = this.createState(ctx, stack.getParent(), stack.getRuleCall(), constructedType, true, true, visited);
            if (r != null) {
                result.followers.add(r);
            }
        }
        return result;
    }

    @Override
    public IPDAState getPDA(CTX context) {
        PDAContext<CTX> ctx = this.createContext(context);
        ctx.start = this.createState(IPDAState.PDAStateType.START, null);
        ctx.stop = this.createState(IPDAState.PDAStateType.STOP, null);
        HashSet<Pair<Boolean, INFAState<?, ?>>> visited = Sets.newHashSet();
        ctx.start.followers = Sets.newHashSet();
        for (INFAState<?, ?> state : this.getStartFollowers(context)) {
            boolean targetCanReturn = !this.canEnterRuleCall(state);
            RuleCallStackElement stack = new RuleCallStackElement(null, null);
            boolean targetReturning = !state.getOutgoingAfterReturn().isEmpty() && targetCanReturn;
            PDAState s2 = this.createState(ctx, stack, state, null, targetReturning, targetCanReturn, visited);
            if (s2 == null) continue;
            ctx.start.followers.add(s2);
        }
        return ctx.start;
    }

    protected abstract List<INFAState<?, ?>> getStartFollowers(CTX var1);

    protected PDAState getState(PDAContext<CTX> ctx, INFAState<?, ?> state, boolean returning) {
        PDAState result = ctx.elements.get(state);
        if (result == null) {
            result = returning ? ctx.ruleCallExit.get(state) : ctx.ruleCallEnter.get(state);
        }
        return result;
    }

    protected abstract boolean isFinalState(CTX var1, INFAState<?, ?> var2, boolean var3, boolean var4);

    protected abstract List<INFAState<?, ?>> getFollowers(CTX var1, INFAState<?, ?> var2, boolean var3, boolean var4);

    protected RuleCallStackElement stackPush(RuleCallStackElement stack, INFAState<?, ?> value) {
        return new RuleCallStackElement(stack, value);
    }

    protected static class PDAContext<CTX> {
        protected CTX context;
        protected Map<INFAState<?, ?>, PDAState> elements = Maps.newHashMap();
        protected Map<INFAState<?, ?>, PDAState> ruleCallEnter = Maps.newHashMap();
        protected Map<INFAState<?, ?>, PDAState> ruleCallExit = Maps.newHashMap();
        protected PDAState start;
        protected PDAState stop;

        public PDAContext(CTX context) {
            this.context = context;
        }

        protected void setStart(PDAState start) {
            this.start = start;
        }

        protected void setStop(PDAState stop) {
            this.stop = stop;
        }
    }

    protected static class PDAState
    implements IPDAState {
        protected AbstractElement element;
        protected Set<IPDAState> followers = Collections.emptySet();
        protected IPDAState.PDAStateType type;

        public PDAState(IPDAState.PDAStateType type, AbstractElement element) {
            this.type = type;
            this.element = element;
        }

        @Override
        public Collection<IPDAState> getFollowers() {
            return this.followers;
        }

        @Override
        public AbstractElement getGrammarElement() {
            return this.element;
        }

        @Override
        public IPDAState.PDAStateType getType() {
            return this.type;
        }

        public String toString() {
            if (this.type == null) {
                return "(type is null)";
            }
            GrammarElementTitleSwitch title = new GrammarElementTitleSwitch().showAssignments();
            switch (this.type) {
                case ELEMENT: {
                    return title.doSwitch(this.element);
                }
                case RULECALL_ENTER: {
                    return ">>" + title.doSwitch(this.element);
                }
                case RULECALL_EXIT: {
                    return "<<" + title.doSwitch(this.element);
                }
                case START: {
                    return "start";
                }
                case STOP: {
                    return "stop";
                }
            }
            return super.toString();
        }
    }

    protected static class RuleCallStackElement {
        protected RuleCallStackElement parent;
        protected INFAState<?, ?> ruleCall;
        protected boolean stopCheck = false;

        public RuleCallStackElement(RuleCallStackElement parent, INFAState<?, ?> ruleCall) {
            this.parent = parent;
            this.ruleCall = ruleCall;
        }

        protected RuleCallStackElement getParent() {
            return this.parent;
        }

        public boolean hasEnteredTwice(INFAState<?, ?> element) {
            RuleCallStackElement e = this;
            int count = 0;
            while (e != null) {
                if (e.ruleCall == element && ++count >= 2) {
                    return true;
                }
                e = e.parent;
            }
            return false;
        }

        public RuleCallStackElement cloneWithoutVisited() {
            RuleCallStackElement result = new RuleCallStackElement(this.parent, this.ruleCall);
            result.stopCheck = true;
            return result;
        }

        protected INFAState<?, ?> getRuleCall() {
            return this.ruleCall;
        }

        public String toString() {
            ArrayList<String> result = Lists.newArrayList();
            RuleCallStackElement e = this;
            while (e != null) {
                result.add(String.valueOf(e.stopCheck ? "!" : "") + e.getRuleCall());
                e = e.parent;
            }
            return ((Object)result).toString();
        }
    }
}

