/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.trace.node;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.stream.IntStream;
import org.eclipse.xtend.lib.annotations.Delegate;
import org.eclipse.xtext.generator.trace.AbstractStatefulTraceRegion;
import org.eclipse.xtext.generator.trace.AbstractTraceRegion;
import org.eclipse.xtext.generator.trace.ILocationData;
import org.eclipse.xtext.generator.trace.ITraceRegionProvider;
import org.eclipse.xtext.generator.trace.TraceNotFoundException;
import org.eclipse.xtext.generator.trace.node.CompositeGeneratorNode;
import org.eclipse.xtext.generator.trace.node.IGeneratorNode;
import org.eclipse.xtext.generator.trace.node.IndentNode;
import org.eclipse.xtext.generator.trace.node.NewLineNode;
import org.eclipse.xtext.generator.trace.node.TextNode;
import org.eclipse.xtext.generator.trace.node.TraceNode;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;
import org.eclipse.xtext.util.TextRegionWithLineInformation;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class GeneratorNodeProcessor {
    public Result process(IGeneratorNode root) {
        Context ctx = new Context();
        this.doProcess(root, ctx);
        return new Result(ctx.getContent(), ctx.getCurrentRegion());
    }

    protected void _doProcess(IndentNode node, Context ctx) {
        if (this._hasContent(node, ctx)) {
            if (node.isIndentImmediately() && !ctx.isPendingIndent()) {
                ctx.appendToCurrentLine(node.getIndentationString());
            }
            try {
                ctx.increaseIndent(node);
                this.doProcessChildren(node, ctx);
            }
            finally {
                ctx.decreaseIndents();
            }
        }
    }

    protected void _doProcess(NewLineNode node, Context ctx) {
        if (node.isIfNotEmpty() && !GeneratorNodeProcessor.hasNonWhitespace(ctx.currentLineContent())) {
            ctx.resetCurrentLine();
        } else {
            if (ctx.isPendingIndent()) {
                this.handlePendingIndent(ctx, true);
            }
            ctx.appendToCurrentLine(node.getLineDelimiter());
            ctx.addNewLine();
        }
        ctx.setPendingIndent(true);
    }

    protected void _doProcess(TextNode node, Context ctx) {
        if (this._hasContent(node, ctx)) {
            if (ctx.isPendingIndent()) {
                this.handlePendingIndent(ctx, false);
            }
            ctx.appendToCurrentLine(node.getText());
        }
    }

    protected void handlePendingIndent(Context ctx, boolean endOfLine) {
        StringBuilder indentString = new StringBuilder();
        for (IndentNode indentNode : ctx.getCurrentIndents()) {
            if (!indentNode.isIndentEmptyLines() && endOfLine) continue;
            indentString.append(indentNode.getIndentationString());
        }
        if (indentString.length() > 0) {
            ctx.insertIntoCurrentLine(0, indentString);
        }
        ctx.setPendingIndent(false);
    }

    protected void _doProcess(TraceNode node, Context ctx) {
        if (this._hasContent(node, ctx)) {
            AbstractTraceRegion beforeRegion = ctx.getCurrentRegion();
            CompletableTraceRegion newRegion = new CompletableTraceRegion(node.isUseForDebugging(), node.getSourceLocation(), beforeRegion);
            int offset = ctx.contentLength();
            int startLineNumber = ctx.currentLineNumber();
            try {
                ctx.setCurrentRegion(newRegion);
                this.doProcessChildren(node, ctx);
            }
            finally {
                if (beforeRegion != null) {
                    ctx.setCurrentRegion(beforeRegion);
                }
                newRegion.complete(offset, ctx.contentLength() - offset, startLineNumber, ctx.currentLineNumber());
            }
        }
    }

    protected void _doProcess(CompositeGeneratorNode node, Context ctx) {
        this.doProcessChildren(node, ctx);
    }

    protected void doProcessChildren(CompositeGeneratorNode node, Context ctx) {
        for (IGeneratorNode child : node.getChildren()) {
            this.doProcess(child, ctx);
        }
    }

    protected boolean _hasContent(CompositeGeneratorNode node, Context ctx) {
        return node.getChildren().stream().anyMatch(it -> this.hasContent((IGeneratorNode)it, ctx));
    }

    protected boolean _hasContent(NewLineNode node, Context ctx) {
        return !node.isIfNotEmpty() || ctx.currentLineContent().length() != 0;
    }

    protected boolean _hasContent(TextNode node, Context ctx) {
        return !GeneratorNodeProcessor.isNullOrEmpty(node.getText());
    }

    protected static boolean hasNonWhitespace(CharSequence s2) {
        int i = 0;
        while (i < s2.length()) {
            if (!Character.isWhitespace(s2.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected static boolean isNullOrEmpty(CharSequence s2) {
        return s2 == null || s2.length() == 0;
    }

    protected void doProcess(IGeneratorNode node, Context ctx) {
        if (node instanceof IndentNode) {
            this._doProcess((IndentNode)node, ctx);
            return;
        }
        if (node instanceof TraceNode) {
            this._doProcess((TraceNode)node, ctx);
            return;
        }
        if (node instanceof CompositeGeneratorNode) {
            this._doProcess((CompositeGeneratorNode)node, ctx);
            return;
        }
        if (node instanceof NewLineNode) {
            this._doProcess((NewLineNode)node, ctx);
            return;
        }
        if (node instanceof TextNode) {
            this._doProcess((TextNode)node, ctx);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(node, ctx).toString());
    }

    protected boolean hasContent(IGeneratorNode node, Context ctx) {
        if (node instanceof CompositeGeneratorNode) {
            return this._hasContent((CompositeGeneratorNode)node, ctx);
        }
        if (node instanceof NewLineNode) {
            return this._hasContent((NewLineNode)node, ctx);
        }
        if (node instanceof TextNode) {
            return this._hasContent((TextNode)node, ctx);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(node, ctx).toString());
    }

    public static class CompletableTraceRegion
    extends AbstractStatefulTraceRegion {
        private CompletableTextRegion region;

        public CompletableTraceRegion(boolean useForDebugging, ILocationData associatedLocation, AbstractTraceRegion parent) {
            this(new CompletableTextRegion(), useForDebugging, associatedLocation, parent);
        }

        protected CompletableTraceRegion(CompletableTextRegion region, boolean useForDebugging, ILocationData associatedLocation, AbstractTraceRegion parent) {
            super((ITextRegionWithLineInformation)region, useForDebugging, associatedLocation, parent);
            this.region = region;
        }

        public void complete(int offset, int length, int startLine, int endLine) {
            this.region.delegate = new TextRegionWithLineInformation(offset, length, startLine, endLine);
        }

        @Override
        protected boolean isConsistentWithParent() {
            return true;
        }

        public static class CompletableTextRegion
        implements ITextRegionWithLineInformation {
            private ITextRegionWithLineInformation delegate;

            @Delegate
            public ITextRegionWithLineInformation getDelegate() {
                if (this.delegate == null) {
                    throw new IllegalStateException("region not completed");
                }
                return this.delegate;
            }

            @Override
            public boolean contains(ITextRegion other) {
                return this.getDelegate().contains(other);
            }

            @Override
            public boolean contains(int offset) {
                return this.getDelegate().contains(offset);
            }

            @Override
            public int getEndLineNumber() {
                return this.getDelegate().getEndLineNumber();
            }

            @Override
            public int getLength() {
                return this.getDelegate().getLength();
            }

            @Override
            public int getLineNumber() {
                return this.getDelegate().getLineNumber();
            }

            @Override
            public int getOffset() {
                return this.getDelegate().getOffset();
            }

            @Override
            public ITextRegion merge(ITextRegion region) {
                return this.getDelegate().merge(region);
            }

            @Override
            public ITextRegionWithLineInformation merge(ITextRegionWithLineInformation other) {
                return this.getDelegate().merge(other);
            }
        }
    }

    protected static class Context {
        private List<StringBuilder> lines = Lists.newArrayList(new StringBuilder());
        private Deque<IndentNode> currentIndents = new ArrayDeque<IndentNode>();
        private boolean pendingIndent = true;
        private AbstractTraceRegion currentRegion = null;
        private int contentLength = 0;
        private int indentLength = 0;

        protected Context() {
        }

        public String currentLineContent() {
            return this.lines.get(this.currentLineNumber()).toString();
        }

        public int contentLength() {
            if (this.isPendingIndent()) {
                return this.contentLength + this.indentLength;
            }
            return this.contentLength;
        }

        public int currentLineNumber() {
            return this.lines.size() - 1;
        }

        public String getContent() {
            return Joiner.on("").join(this.lines);
        }

        public AbstractTraceRegion getCurrentRegion() {
            return this.currentRegion;
        }

        public void increaseIndent(IndentNode node) {
            this.currentIndents.push(node);
            this.recalculateIndentLength();
        }

        public void decreaseIndents() {
            this.currentIndents.pop();
            this.recalculateIndentLength();
        }

        protected int recalculateIndentLength() {
            this.indentLength = IterableExtensions.fold(this.getCurrentIndents(), 0, ($0, $1) -> $0 + $1.getIndentationString().length());
            return this.indentLength;
        }

        public void appendToCurrentLine(CharSequence chars) {
            this.lines.get(this.currentLineNumber()).append(chars);
            this.contentLength += chars.length();
        }

        public boolean isPendingIndent() {
            return this.pendingIndent;
        }

        public void addNewLine() {
            this.lines.add(new StringBuilder());
        }

        public void setPendingIndent(boolean pending) {
            this.pendingIndent = pending;
        }

        public void resetCurrentLine() {
            StringBuilder lineContent = this.lines.get(this.currentLineNumber());
            if (!GeneratorNodeProcessor.isNullOrEmpty(lineContent)) {
                this.contentLength -= lineContent.length();
            }
            this.lines.set(this.currentLineNumber(), new StringBuilder());
        }

        public void insertIntoCurrentLine(int i, StringBuilder builder) {
            this.lines.get(this.currentLineNumber()).insert(i, builder);
            this.contentLength += builder.length();
        }

        public Deque<IndentNode> getCurrentIndents() {
            return new ArrayDeque<IndentNode>(this.currentIndents);
        }

        public AbstractTraceRegion setCurrentRegion(AbstractTraceRegion region) {
            this.currentRegion = region;
            return this.currentRegion;
        }
    }

    public static class Result
    implements CharSequence,
    ITraceRegionProvider {
        private final CharSequence contentsDelegate;
        private final AbstractTraceRegion traceRegion;

        @Override
        public AbstractTraceRegion getTraceRegion() throws TraceNotFoundException {
            if (this.traceRegion == null) {
                throw new TraceNotFoundException();
            }
            return this.traceRegion;
        }

        @Override
        public String toString() {
            return this.contentsDelegate.toString();
        }

        public Result(CharSequence contents, AbstractTraceRegion traceRegion) {
            this.contentsDelegate = contents;
            this.traceRegion = traceRegion;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.contentsDelegate == null ? 0 : this.contentsDelegate.hashCode());
            result = 31 * result + (this.traceRegion == null ? 0 : this.traceRegion.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Result other = (Result)obj;
            if (this.contentsDelegate == null ? other.contentsDelegate != null : !this.contentsDelegate.equals(other.contentsDelegate)) {
                return false;
            }
            return !(this.traceRegion == null ? other.traceRegion != null : !this.traceRegion.equals(other.traceRegion));
        }

        public CharSequence getContents() {
            return this.contentsDelegate;
        }

        @Override
        public char charAt(int index) {
            return this.contentsDelegate.charAt(index);
        }

        @Override
        public IntStream chars() {
            return this.contentsDelegate.chars();
        }

        @Override
        public IntStream codePoints() {
            return this.contentsDelegate.codePoints();
        }

        @Override
        public int length() {
            return this.contentsDelegate.length();
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.contentsDelegate.subSequence(start, end);
        }
    }
}

