/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.trace;

import com.google.common.base.CharMatcher;
import java.util.regex.Pattern;

public class TraceFileNameProvider {
    private static final CharMatcher SEPARATOR_MATCHER = CharMatcher.anyOf("/\\");
    public static final String TRACE_FILE_EXTENSION = "._trace";
    private static final Pattern TRACE_FILE_NAME_PATTERN = Pattern.compile(".*\\..+\\._trace$");

    public boolean isTraceFileName(String traceFileName) {
        return TRACE_FILE_NAME_PATTERN.matcher(traceFileName).matches();
    }

    public String getTraceFromJava(String javaFileName) {
        int i = SEPARATOR_MATCHER.lastIndexIn(javaFileName);
        if (i < 0) {
            return "." + javaFileName + TRACE_FILE_EXTENSION;
        }
        return String.valueOf(javaFileName.substring(0, i + 1)) + "." + javaFileName.substring(i + 1) + TRACE_FILE_EXTENSION;
    }

    public String getJavaFromTrace(String traceFileName) {
        int i = SEPARATOR_MATCHER.lastIndexIn(traceFileName);
        if (i < 0) {
            return traceFileName.substring(1, traceFileName.length() - TRACE_FILE_EXTENSION.length());
        }
        return String.valueOf(traceFileName.substring(0, i + 1)) + traceFileName.substring(i + 2, traceFileName.length() - TRACE_FILE_EXTENSION.length());
    }
}

