/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.trace;

import com.google.common.base.Objects;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.generator.trace.AbstractURIWrapper;

public class SourceRelativeURI
extends AbstractURIWrapper {
    public static SourceRelativeURI fromAbsolute(URI uri) {
        if (uri.isRelative()) {
            throw new IllegalArgumentException(uri.toString());
        }
        return new SourceRelativeURI(uri.path().substring(1));
    }

    public SourceRelativeURI(URI sourceRelativeURI) {
        super(sourceRelativeURI);
        if (!sourceRelativeURI.isRelative() || sourceRelativeURI.path().startsWith("/")) {
            throw new IllegalArgumentException(String.valueOf(sourceRelativeURI));
        }
    }

    public SourceRelativeURI(String relativeURI) {
        this(URI.createURI(relativeURI));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null && !Objects.equal(obj.getClass(), SourceRelativeURI.class)) {
            throw new IllegalArgumentException(String.valueOf(obj.toString()) + " instanceof " + obj.getClass().getName());
        }
        return super.equals(obj);
    }
}

