/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator;

import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.xtext.generator.AbstractFileSystemAccess2;
import org.eclipse.xtext.generator.IFilePostProcessor;
import org.eclipse.xtext.generator.trace.ITraceRegionProvider;
import org.eclipse.xtext.generator.trace.TraceFileNameProvider;
import org.eclipse.xtext.generator.trace.TraceNotFoundException;
import org.eclipse.xtext.generator.trace.TraceRegionSerializer;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.util.RuntimeIOException;

public class URIBasedFileSystemAccess
extends AbstractFileSystemAccess2 {
    private URIConverter converter;
    private URI baseDir;
    private boolean generateTraces = false;
    private IEncodingProvider encodingProvider = new IEncodingProvider.Runtime();
    private TraceRegionSerializer traceRegionSerializer;
    private TraceFileNameProvider traceFileNameProvider;
    private BeforeDelete beforeDelete = uri -> true;
    private BeforeWrite beforeWrite = (uri, string, stream) -> stream;
    private BeforeRead beforeRead = (uri, stream) -> stream;

    @Override
    public void setPostProcessor(IFilePostProcessor filePostProcessor) {
        super.setPostProcessor(filePostProcessor);
    }

    @Override
    public URI getURI(String path, String outputConfiguration) {
        String outlet = this.getPathes().get(outputConfiguration);
        if (outlet == null) {
            throw new IllegalArgumentException("A slot with name '" + outputConfiguration + "' has not been configured.");
        }
        URI uri = URI.createFileURI(String.valueOf(outlet) + File.separator + path);
        return this.baseDir != null ? uri.resolve(this.baseDir) : uri;
    }

    public String getEncoding(URI uri) {
        return this.encodingProvider.getEncoding(uri);
    }

    @Override
    public void generateFile(String fileName, String outputCfgName, CharSequence contents) {
        try {
            URI uri = this.getURI(fileName, outputCfgName);
            if (!this.getOutputConfig(outputCfgName).isOverrideExistingResources() && this.converter.exists(uri, Collections.emptyMap())) {
                return;
            }
            String encoding = this.getEncoding(uri);
            CharSequence postProcessed = this.postProcess(fileName, outputCfgName, contents, encoding);
            this.generateTrace(fileName, outputCfgName, postProcessed);
            this.generateFile(fileName, outputCfgName, new ByteArrayInputStream(postProcessed.toString().getBytes(encoding)));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    protected void generateTrace(String generatedFile, String outputConfigName, CharSequence contents) {
        if (this.isGenerateTraces() && contents instanceof ITraceRegionProvider) {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                this.traceRegionSerializer.writeTraceRegionTo(((ITraceRegionProvider)((Object)contents)).getTraceRegion(), out);
                this.generateFile(this.traceFileNameProvider.getTraceFromJava(generatedFile), outputConfigName, new ByteArrayInputStream(out.toByteArray()));
            }
            catch (TraceNotFoundException out) {
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }
    }

    @Override
    public void generateFile(String fileName, String outputCfgName, InputStream content) throws RuntimeIOException {
        try {
            URI uri = this.getURI(fileName, outputCfgName);
            Throwable throwable = null;
            Object var6_8 = null;
            try (OutputStream out = this.converter.createOutputStream(uri);){
                ByteStreams.copy(this.beforeWrite.beforeWrite(uri, outputCfgName, content), out);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException t2) {
            throw new RuntimeIOException(t2);
        }
    }

    @Override
    public InputStream readBinaryFile(String fileName, String outputCfgName) throws RuntimeIOException {
        try {
            URI uri = this.getURI(fileName, outputCfgName);
            return this.beforeRead.beforeRead(uri, this.converter.createInputStream(uri));
        }
        catch (IOException t2) {
            throw new RuntimeIOException(t2);
        }
    }

    @Override
    public CharSequence readTextFile(String fileName, String outputCfgName) throws RuntimeIOException {
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try (InputStreamReader reader = new InputStreamReader(this.readBinaryFile(fileName, outputCfgName), this.getEncoding(this.getURI(fileName, outputCfgName)));){
                return CharStreams.toString(reader);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (RuntimeIOException t2) {
            throw t2;
        }
        catch (IOException t3) {
            throw new RuntimeIOException(t3);
        }
    }

    public URIConverter getConverter() {
        return this.converter;
    }

    public void setConverter(URIConverter converter) {
        this.converter = converter;
    }

    public URI getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(URI baseDir) {
        this.baseDir = baseDir;
    }

    public boolean isGenerateTraces() {
        return this.generateTraces;
    }

    public void setGenerateTraces(boolean generateTraces) {
        this.generateTraces = generateTraces;
    }

    public IEncodingProvider getEncodingProvider() {
        return this.encodingProvider;
    }

    public void setEncodingProvider(IEncodingProvider encodingProvider) {
        this.encodingProvider = encodingProvider;
    }

    public TraceRegionSerializer getTraceRegionSerializer() {
        return this.traceRegionSerializer;
    }

    public void setTraceRegionSerializer(TraceRegionSerializer traceRegionSerializer) {
        this.traceRegionSerializer = traceRegionSerializer;
    }

    public TraceFileNameProvider getTraceFileNameProvider() {
        return this.traceFileNameProvider;
    }

    public void setTraceFileNameProvider(TraceFileNameProvider traceFileNameProvider) {
        this.traceFileNameProvider = traceFileNameProvider;
    }

    public BeforeDelete getBeforeDelete() {
        return this.beforeDelete;
    }

    public void setBeforeDelete(BeforeDelete beforeDelete) {
        this.beforeDelete = beforeDelete;
    }

    public BeforeWrite getBeforeWrite() {
        return this.beforeWrite;
    }

    public void setBeforeWrite(BeforeWrite beforeWrite) {
        this.beforeWrite = beforeWrite;
    }

    public BeforeRead getBeforeRead() {
        return this.beforeRead;
    }

    public void setBeforeRead(BeforeRead beforeRead) {
        this.beforeRead = beforeRead;
    }

    public static interface BeforeDelete {
        public boolean beforeDelete(URI var1);
    }

    public static interface BeforeRead {
        public InputStream beforeRead(URI var1, InputStream var2);
    }

    public static interface BeforeWrite {
        public InputStream beforeWrite(URI var1, String var2, InputStream var3);
    }
}

