/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.internal;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.formatting2.AbstractFormatter2;
import org.eclipse.xtext.formatting2.FormatterPreferenceKeys;
import org.eclipse.xtext.formatting2.FormattingNotApplicableException;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.IFormattableSubDocument;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatter;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatting;
import org.eclipse.xtext.formatting2.ISubFormatter;
import org.eclipse.xtext.formatting2.ITextReplacer;
import org.eclipse.xtext.formatting2.ITextReplacerContext;
import org.eclipse.xtext.formatting2.debug.HiddenRegionFormattingToString;
import org.eclipse.xtext.formatting2.debug.TextRegionsToString;
import org.eclipse.xtext.formatting2.internal.ArrayListTextSegmentSet;
import org.eclipse.xtext.formatting2.internal.ConditionalReplacer;
import org.eclipse.xtext.formatting2.internal.ConflictingRegionsException;
import org.eclipse.xtext.formatting2.internal.FilteredSubDocument;
import org.eclipse.xtext.formatting2.internal.HiddenRegionReplacer;
import org.eclipse.xtext.formatting2.internal.RegionTraceMissingException;
import org.eclipse.xtext.formatting2.internal.RegionsOutsideFrameException;
import org.eclipse.xtext.formatting2.internal.TextSegmentSet;
import org.eclipse.xtext.formatting2.regionaccess.IEObjectRegion;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.ITextReplacement;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;
import org.eclipse.xtext.preferences.ITypedPreferenceValues;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

public abstract class FormattableDocument
implements IFormattableDocument {
    private TextSegmentSet<ITextReplacer> replacers = null;

    protected FormattableDocument() {
    }

    protected TextSegmentSet<ITextReplacer> getReplacers() {
        if (this.replacers == null) {
            this.replacers = this.createTextReplacerSet();
        }
        return this.replacers;
    }

    @Override
    public void addReplacer(ITextReplacer replacer) {
        if (!this.getRegion().contains(replacer.getRegion())) {
            String frameTitle = this.getClass().getSimpleName();
            ITextSegment frameRegion = this.getRegion();
            String replacerTitle = replacer.getClass().getSimpleName();
            ITextSegment replacerRegion = replacer.getRegion();
            RegionsOutsideFrameException exception = new RegionsOutsideFrameException(frameTitle, frameRegion, Tuples.create(replacerTitle, replacerRegion));
            this.getRequest().getExceptionHandler().accept(exception);
            return;
        }
        try {
            this.getReplacers().add(replacer, this.getFormatter().createTextReplacerMerger());
        }
        catch (ConflictingRegionsException e) {
            this.getRequest().getExceptionHandler().accept(e);
        }
    }

    @Override
    public ISemanticRegion append(ISemanticRegion token, Procedures.Procedure1<? super IHiddenRegionFormatter> after) {
        if (token != null) {
            IHiddenRegion gap = token.getNextHiddenRegion();
            this.set(gap, after);
        }
        return token;
    }

    @Override
    public <T extends EObject> T append(T owner, Procedures.Procedure1<? super IHiddenRegionFormatter> after) {
        IEObjectRegion region;
        if (owner != null && (region = this.getTextRegionAccess().regionForEObject(owner)) != null) {
            IHiddenRegion gap = region.getNextHiddenRegion();
            this.set(gap, after);
        }
        return owner;
    }

    protected String applyTextReplacements(Iterable<ITextReplacement> replacements) {
        ITextSegment region = this.getRegion();
        String input = region.getText();
        ArrayList<ITextReplacement> list = Lists.newArrayList(replacements);
        Collections.sort(list);
        int startOffset = region.getOffset();
        int lastOffset = 0;
        StringBuilder result = new StringBuilder();
        for (ITextReplacement r : list) {
            int offset = r.getOffset() - startOffset;
            result.append(input.subSequence(lastOffset, offset));
            result.append(r.getReplacementText());
            lastOffset = offset + r.getLength();
        }
        result.append(input.subSequence(lastOffset, input.length()));
        return result.toString();
    }

    protected ITextReplacerContext createReplacements(ITextReplacerContext previous) {
        Integer maxLineWidth = this.getRequest().getPreferences().getPreference(FormatterPreferenceKeys.maxLineWidth);
        ITextReplacerContext context = previous.withDocument(this);
        ITextReplacerContext wrappable = null;
        HashSet<ITextReplacer> wrapped = Sets.newHashSet();
        Iterator<Object> replacers = this.getReplacers().iterator();
        while (replacers.hasNext()) {
            ITextReplacer replacer = (ITextReplacer)replacers.next();
            context = context.withReplacer(replacer);
            if (wrappable != null && context.isWrapSincePrevious()) {
                wrappable = null;
            }
            if (wrappable != null && this.needsAutowrap(wrappable, context, maxLineWidth)) {
                while (context != wrappable) {
                    context = context.getPreviousContext();
                }
                replacer = context.getReplacer();
                replacers = this.getReplacers().iteratorAfter(replacer);
                context.setAutowrap(true);
                wrappable = null;
            }
            ITextReplacerContext nextContext = replacer.createReplacements(context);
            if (wrappable != null && context.isWrapInRegion()) {
                wrappable = null;
            } else {
                Integer canAutowrap = context.canAutowrap();
                if (canAutowrap != null && canAutowrap >= 0 && !context.isAutowrap() && !wrapped.contains(replacer)) {
                    boolean can = true;
                    if (wrappable != null) {
                        int thisEndOffset;
                        int lastEndOffset = wrappable.canAutowrap() + wrappable.getReplacer().getRegion().getEndOffset();
                        boolean bl = can = lastEndOffset < (thisEndOffset = canAutowrap + context.getReplacer().getRegion().getEndOffset());
                    }
                    if (can) {
                        wrappable = context;
                        wrapped.add(replacer);
                    }
                }
            }
            context = nextContext;
        }
        return context.withDocument(previous.getDocument());
    }

    protected TextSegmentSet<ITextReplacer> createTextReplacerSet() {
        return new ArrayListTextSegmentSet<ITextReplacer>(ITextReplacer.GET_REGION, new Function<ITextReplacer, String>(){

            @Override
            public String apply(ITextReplacer input) {
                if (input instanceof HiddenRegionReplacer) {
                    return new HiddenRegionFormattingToString().apply(((HiddenRegionReplacer)input).getFormatting());
                }
                return input.getClass().getSimpleName();
            }
        }, this.getRequest().isEnableDebugTracing());
    }

    @Override
    public <T> T format(T obj) {
        AbstractFormatter2 formatter = this.getFormatter();
        if (formatter.shouldFormat(obj, this)) {
            try {
                formatter.format(obj, this);
            }
            catch (RegionTraceMissingException e) {
                throw e;
            }
            catch (Exception e) {
                IAcceptor<Exception> handler = this.getRequest().getExceptionHandler();
                handler.accept(e);
            }
        }
        return obj;
    }

    @Override
    public void formatConditionally(EObject owner, ISubFormatter ... formatters) {
        IEObjectRegion region = this.getTextRegionAccess().regionForEObject(owner);
        if (region != null) {
            this.formatConditionally(region.getOffset(), region.getLength(), formatters);
        }
    }

    @Override
    public void formatConditionally(int offset, int length, ISubFormatter ... formatters) throws FormattingNotApplicableException {
        ConditionalReplacer replacer = new ConditionalReplacer(this, offset, length, ImmutableList.copyOf(formatters));
        this.addReplacer(replacer);
    }

    public ITypedPreferenceValues getPreferences() {
        return this.getFormatter().getPreferences();
    }

    public ITextRegionAccess getTextRegionAccess() {
        return this.getRequest().getTextRegionAccess();
    }

    @Override
    public <T1 extends ISemanticRegion, T2 extends ISemanticRegion> Pair<T1, T2> interior(Pair<T1, T2> pair, Procedures.Procedure1<? super IHiddenRegionFormatter> init) {
        return this.interior((ISemanticRegion)pair.getKey(), (ISemanticRegion)pair.getValue(), init);
    }

    @Override
    public <T extends EObject> T interior(T object, Procedures.Procedure1<? super IHiddenRegionFormatter> init) {
        IEObjectRegion objRegion;
        if (object != null && (objRegion = this.getTextRegionAccess().regionForEObject(object)) != null) {
            IHiddenRegion previous = objRegion.getPreviousHiddenRegion();
            IHiddenRegion next = objRegion.getNextHiddenRegion();
            if (previous != null && next != null && previous != next) {
                this.interior(previous.getNextSemanticRegion(), next.getPreviousSemanticRegion(), init);
            }
        }
        return object;
    }

    @Override
    public <T1 extends ISemanticRegion, T2 extends ISemanticRegion> Pair<T1, T2> interior(T1 first, T2 second, Procedures.Procedure1<? super IHiddenRegionFormatter> init) {
        if (first != null && second != null) {
            this.set(first.getNextHiddenRegion(), second.getPreviousHiddenRegion(), init);
        }
        return Pair.of(first, second);
    }

    protected boolean needsAutowrap(ITextReplacerContext wrappable, ITextReplacerContext context, int maxLineWidth) {
        if (context.getLeadingCharsInLineCount() > maxLineWidth) {
            return true;
        }
        int offset = wrappable.getReplacer().getRegion().getOffset();
        int length = context.getReplacer().getRegion().getEndOffset() - offset;
        if (length > wrappable.canAutowrap()) {
            return false;
        }
        return false;
    }

    @Override
    public ISemanticRegion prepend(ISemanticRegion token, Procedures.Procedure1<? super IHiddenRegionFormatter> before) {
        if (token != null) {
            IHiddenRegion gap = token.getPreviousHiddenRegion();
            this.set(gap, before);
        }
        return token;
    }

    @Override
    public <T extends EObject> T prepend(T owner, Procedures.Procedure1<? super IHiddenRegionFormatter> before) {
        IEObjectRegion region;
        if (owner != null && (region = this.getTextRegionAccess().regionForEObject(owner)) != null) {
            IHiddenRegion gap = region.getPreviousHiddenRegion();
            this.set(gap, before);
        }
        return owner;
    }

    @Override
    public List<ITextReplacement> renderToTextReplacements() {
        ITextReplacerContext first = this.getFormatter().createTextReplacerContext(this);
        ITextReplacerContext last = this.createReplacements(first);
        List<ITextReplacement> replacements = last.getReplacementsUntil(first);
        return replacements;
    }

    @Override
    public Pair<IHiddenRegion, IHiddenRegion> set(IHiddenRegion first, IHiddenRegion second, Procedures.Procedure1<? super IHiddenRegionFormatter> init) {
        if (first != null && second != null) {
            AbstractFormatter2 formatter = this.getFormatter();
            IHiddenRegionFormatting f1 = formatter.createHiddenRegionFormatting();
            IHiddenRegionFormatting f2 = formatter.createHiddenRegionFormatting();
            init.apply(formatter.createHiddenRegionFormatter(f1, f2));
            ITextReplacer replacer1 = formatter.createHiddenRegionReplacer(first, f1);
            ITextReplacer replacer2 = formatter.createHiddenRegionReplacer(second, f2);
            this.addReplacer(replacer1);
            this.addReplacer(replacer2);
        }
        return Pair.of(first, second);
    }

    @Override
    public IHiddenRegion set(IHiddenRegion hiddenRegion, Procedures.Procedure1<? super IHiddenRegionFormatter> init) {
        if (hiddenRegion != null) {
            AbstractFormatter2 formatter = this.getFormatter();
            IHiddenRegionFormatting formatting = formatter.createHiddenRegionFormatting();
            init.apply(formatter.createHiddenRegionFormatter(formatting));
            ITextReplacer replacer = formatter.createHiddenRegionReplacer(hiddenRegion, formatting);
            this.addReplacer(replacer);
        }
        return hiddenRegion;
    }

    @Override
    public ISemanticRegion surround(ISemanticRegion token, Procedures.Procedure1<? super IHiddenRegionFormatter> beforeAndAfter) {
        if (token != null) {
            IHiddenRegion previous = token.getPreviousHiddenRegion();
            IHiddenRegion next = token.getNextHiddenRegion();
            this.set(previous, next, beforeAndAfter);
        }
        return token;
    }

    @Override
    public <T extends EObject> T surround(T owner, Procedures.Procedure1<? super IHiddenRegionFormatter> beforeAndAfter) {
        if (owner != null && !owner.eIsProxy()) {
            IEObjectRegion region = this.getTextRegionAccess().regionForEObject(owner);
            if (region == null) {
                return owner;
            }
            IHiddenRegion previous = region.getPreviousHiddenRegion();
            IHiddenRegion next = region.getNextHiddenRegion();
            this.set(previous, next, beforeAndAfter);
        }
        return owner;
    }

    public String toString() {
        TextRegionsToString toString = new TextRegionsToString();
        toString.setFrame(this.getRegion());
        toString.setTitle(String.valueOf(this.getClass().getSimpleName()) + " with ITextReplacers");
        for (ITextReplacer repl : this.getReplacers()) {
            toString.add(repl.getRegion(), String.valueOf(repl.getClass().getSimpleName()) + ": " + repl.toString());
        }
        return toString.toString();
    }

    @Override
    public IFormattableSubDocument withReplacerFilter(Predicate<? super ITextReplacer> filter) {
        return new FilteredSubDocument(this.getRegion(), this, filter);
    }
}

