/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.formatting.IElementMatcherProvider;
import org.eclipse.xtext.formatting.impl.MatcherState;
import org.eclipse.xtext.grammaranalysis.impl.AbstractNFATransition;

public class MatcherTransition
extends AbstractNFATransition<MatcherState, MatcherTransition> {
    protected Set<IElementMatcherProvider.IElementPattern> commonPatterns;
    protected Map<MatcherState, Set<IElementMatcherProvider.IElementPattern>> guardedPatterns;

    public MatcherTransition(MatcherState source, MatcherState target, boolean ruleCall, AbstractElement loopCenter) {
        super(source, target, ruleCall, loopCenter);
    }

    public void addPattern(IElementMatcherProvider.IElementPattern pattern) {
        if (this.commonPatterns == null) {
            this.commonPatterns = Sets.newHashSet();
        }
        this.commonPatterns.add(pattern);
    }

    public void addPattern(MatcherState guard, IElementMatcherProvider.IElementPattern pattern) {
        Set<IElementMatcherProvider.IElementPattern> patterns;
        if (this.guardedPatterns == null) {
            this.guardedPatterns = Maps.newHashMap();
        }
        if ((patterns = this.guardedPatterns.get(guard)) == null) {
            patterns = Sets.newHashSet();
            this.guardedPatterns.put(guard, patterns);
        }
        patterns.add(pattern);
    }

    public Set<IElementMatcherProvider.IElementPattern> getCommonPatterns() {
        return this.commonPatterns == null ? Collections.emptySet() : this.commonPatterns;
    }

    public Map<MatcherState, Set<IElementMatcherProvider.IElementPattern>> getGuardPatterns() {
        return this.guardedPatterns == null ? Collections.emptyMap() : this.guardedPatterns;
    }

    public List<IElementMatcherProvider.IElementPattern> getPatterns(Collection<MatcherState> from) {
        if (this.guardedPatterns == null && this.commonPatterns == null) {
            return Collections.emptyList();
        }
        ArrayList<IElementMatcherProvider.IElementPattern> result = Lists.newArrayList();
        if (this.commonPatterns != null) {
            result.addAll(this.commonPatterns);
        }
        if (this.guardedPatterns != null) {
            for (MatcherState state : from) {
                Set<IElementMatcherProvider.IElementPattern> guard = this.guardedPatterns.get(state);
                if (guard == null) continue;
                result.addAll(guard);
            }
        }
        return result;
    }
}

