/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting.impl;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.GrammarToDot;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.formatting.IElementMatcherProvider;
import org.eclipse.xtext.formatting.impl.ElementMatcherProvider;
import org.eclipse.xtext.formatting.impl.MatcherState;
import org.eclipse.xtext.formatting.impl.MatcherTransition;
import org.eclipse.xtext.grammaranalysis.IGrammarNFAProvider;
import org.eclipse.xtext.util.GraphvizDotBuilder;

public class ElementMatcherToDot
extends GrammarToDot {
    protected IGrammarNFAProvider<MatcherState, MatcherTransition> nfaProvider;

    @Override
    protected GraphvizDotBuilder.Node drawAbstractElementTree(AbstractElement grammarElement, GraphvizDotBuilder.Digraph digraph) {
        GraphvizDotBuilder.Node node = super.drawAbstractElementTree(grammarElement, digraph);
        MatcherState nfas = this.nfaProvider.getNFA(grammarElement);
        for (MatcherTransition outgoing : nfas.getOutgoing()) {
            digraph.add(this.drawFollowerEdge(grammarElement, outgoing, false));
        }
        for (MatcherTransition outgoingAfterReturn : nfas.getOutgoingAfterReturn()) {
            digraph.add(this.drawFollowerEdge(grammarElement, outgoingAfterReturn, true));
        }
        if (nfas.isEndState()) {
            node.put("peripheries", "2");
        }
        if (!nfas.hasTransitions()) {
            node.setStyle("dotted");
        }
        return node;
    }

    protected String toStr(Iterable<IElementMatcherProvider.IElementPattern> list) {
        String s1 = Joiner.on(", ").join(list);
        String s2 = s1.replaceAll("\\\\n|\\n", "\\\\\\\\n");
        return s2;
    }

    protected GraphvizDotBuilder.Edge drawFollowerEdge(AbstractElement grammarElement, MatcherTransition transition, boolean isParent) {
        GraphvizDotBuilder.Edge edge = new GraphvizDotBuilder.Edge(this, grammarElement, ((MatcherState)transition.getTarget()).getGrammarElement());
        ArrayList<String> label = Lists.newArrayList();
        if (!transition.getCommonPatterns().isEmpty()) {
            label.add("{" + this.toStr(transition.getCommonPatterns()) + "}");
        }
        for (Map.Entry<MatcherState, Set<IElementMatcherProvider.IElementPattern>> e : transition.getGuardPatterns().entrySet()) {
            label.add(String.valueOf(GrammarUtil.containingRule(e.getKey().getGrammarElement()).getName()) + "-" + e.getKey() + ":{" + this.toStr((Iterable<IElementMatcherProvider.IElementPattern>)e.getValue()) + "}");
        }
        if (label.size() > 0) {
            edge.setLabel(Joiner.on("\\n").join(label));
        }
        if (isParent) {
            edge.put("arrowtail", "odot");
        }
        if (transition.isRuleCall()) {
            edge.put("arrowhead", "onormalonormal");
        } else {
            edge.put("arrowhead", "onormal");
        }
        return edge;
    }

    @Override
    protected GraphvizDotBuilder.Props drawGrammarContainementEdge(AbstractElement container2, AbstractElement child) {
        GraphvizDotBuilder.Edge edge = new GraphvizDotBuilder.Edge(this, container2, child);
        edge.setStyle("dotted");
        return edge;
    }

    @Override
    protected GraphvizDotBuilder.Props drawObject(Object obj) {
        if (obj == null) {
            throw new NullPointerException("Obj null");
        }
        if (obj instanceof ElementMatcherProvider.TransitionMatcher) {
            ElementMatcherProvider.TransitionMatcher m4 = (ElementMatcherProvider.TransitionMatcher)obj;
            this.nfaProvider = m4.nfaProvider;
            return super.drawObject(m4.getGrammar().getGrammar());
        }
        return super.drawObject(obj);
    }

    @Override
    protected GraphvizDotBuilder.Node newNode(EObject semanticObject, String label) {
        if (semanticObject.eContainer() instanceof AbstractRule) {
            AbstractRule rule = (AbstractRule)semanticObject.eContainer();
            return new GraphvizDotBuilder.Node(this, semanticObject, String.valueOf(rule.getName()) + ":\\n" + label, "record");
        }
        return new GraphvizDotBuilder.Node(this, semanticObject, label);
    }
}

