/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.conversion.impl;

import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.ValueConverterWithValueException;
import org.eclipse.xtext.conversion.impl.AbstractLexerBasedConverter;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.util.JavaStringConverter;
import org.eclipse.xtext.util.Strings;

public class STRINGValueConverter
extends AbstractLexerBasedConverter<String> {
    @Override
    protected String toEscapedString(String value) {
        return String.valueOf('\"') + Strings.convertToJavaString(value, false) + '\"';
    }

    @Override
    public String toValue(String string, INode node) {
        if (string == null) {
            return null;
        }
        try {
            if (string.length() == 1) {
                throw new ValueConverterWithValueException(this.getStringNotClosedMessage(), node, "", null);
            }
            return this.convertFromString(string, node);
        }
        catch (IllegalArgumentException e) {
            throw new ValueConverterException(e.getMessage(), node, e);
        }
    }

    protected String convertFromString(String literal, INode node) throws ValueConverterWithValueException {
        Implementation converter = this.createConverter();
        String result = converter.convertFromJavaString(literal);
        if (converter.errorMessage != null) {
            throw new ValueConverterWithValueException(converter.errorMessage, node, result.toString(), converter.errorIndex, converter.errorLength, null);
        }
        return result;
    }

    protected Implementation createConverter() {
        return new Implementation();
    }

    protected String getInvalidEscapeSequenceMessage() {
        return "Invalid escape sequence (valid ones are  \\b  \\t  \\n  \\f  \\r  \\\"  \\'  \\\\ )";
    }

    protected String getStringNotClosedMessage() {
        return "String literal is not properly closed";
    }

    protected boolean isHexSequence(char[] in, int off, int chars) {
        return Implementation.doIsHexSequence(in, off, chars);
    }

    protected class Implementation
    extends JavaStringConverter {
        String errorMessage = null;
        int errorIndex = -1;
        int errorLength = -1;
        int nextIndex = 1;

        protected Implementation() {
        }

        public String convertFromJavaString(String literal) {
            int idx = literal.indexOf(92);
            if (idx < 0 && literal.length() > 1 && literal.charAt(0) == literal.charAt(literal.length() - 1)) {
                return literal.substring(1, literal.length() - 1);
            }
            return this.convertFromJavaString(literal, true, 1, new StringBuilder(literal.length()));
        }

        @Override
        protected String convertFromJavaString(String string, boolean useUnicode, int index, StringBuilder result) {
            int length = string.length();
            while (index < length - 1) {
                this.nextIndex = index = this.unescapeCharAndAppendTo(string, useUnicode, index, result);
            }
            if (this.nextIndex < length) {
                if (this.nextIndex != length - 1) {
                    throw new IllegalStateException();
                }
                char next = string.charAt(this.nextIndex);
                if (string.charAt(0) != next) {
                    result.append(next);
                    if (this.errorMessage == null) {
                        if (next == '\\') {
                            this.errorMessage = STRINGValueConverter.this.getInvalidEscapeSequenceMessage();
                            this.errorIndex = this.nextIndex;
                            this.errorLength = 1;
                        } else {
                            this.errorMessage = STRINGValueConverter.this.getStringNotClosedMessage();
                        }
                    } else {
                        this.errorMessage = STRINGValueConverter.this.getStringNotClosedMessage();
                        this.errorIndex = -1;
                        this.errorLength = -1;
                    }
                }
            } else if (this.nextIndex == length) {
                this.errorMessage = STRINGValueConverter.this.getStringNotClosedMessage();
            }
            return result.toString();
        }

        @Override
        protected boolean isHexSequence(char[] in, int off, int chars) {
            return STRINGValueConverter.this.isHexSequence(in, off, chars);
        }

        @Override
        protected int handleInvalidUnicodeEscapeSequence(String string, int index, StringBuilder result) {
            result.append('u');
            this.errorMessage = "Invalid unicode";
            this.errorIndex = index - 2;
            this.errorLength = 2;
            return index;
        }

        @Override
        protected int doUnescapeCharAndAppendTo(String string, boolean useUnicode, int index, StringBuilder result) {
            if (string.length() == index) {
                if (this.errorMessage == null) {
                    this.errorMessage = STRINGValueConverter.this.getInvalidEscapeSequenceMessage();
                    this.errorIndex = index - 1;
                    this.errorLength = 1;
                }
                return index;
            }
            return super.doUnescapeCharAndAppendTo(string, useUnicode, index, result);
        }

        @Override
        protected int handleUnknownEscapeSequence(String string, char c, boolean useUnicode, int index, StringBuilder result) {
            if (this.errorMessage == null) {
                this.errorMessage = STRINGValueConverter.this.getInvalidEscapeSequenceMessage();
                this.errorIndex = index - 2;
                this.errorLength = 2;
            }
            result.append(c);
            return index;
        }
    }
}

