/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.util;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmType;

public class DeprecationUtil {
    public static boolean isDeprecated(JvmAnnotationTarget jvmAnnotationTarget) {
        if (jvmAnnotationTarget instanceof JvmMember) {
            return DeprecationUtil.isDeprecatedMember((JvmMember)jvmAnnotationTarget);
        }
        return false;
    }

    public static boolean isTransitivelyDeprecated(JvmAnnotationTarget jvmAnnotationTarget) {
        if (jvmAnnotationTarget instanceof JvmMember) {
            return DeprecationUtil.isTransitivelyDeprecatedMember((JvmMember)jvmAnnotationTarget);
        }
        return false;
    }

    public static boolean isDeprecatedAnnotation(JvmAnnotationType jvmAnnotationType) {
        return !jvmAnnotationType.eIsProxy() && Deprecated.class.getName().equals(jvmAnnotationType.getIdentifier());
    }

    public static boolean isDeprecated(JvmType type) {
        if (type instanceof JvmMember) {
            return DeprecationUtil.isDeprecatedMember((JvmMember)((Object)type));
        }
        return false;
    }

    public static boolean isDeprecatedMember(JvmMember member) {
        if (member.isSetDeprecated()) {
            return member.isDeprecated();
        }
        EList<JvmAnnotationReference> annotations = member.getAnnotations();
        for (JvmAnnotationReference annotation2 : annotations) {
            JvmAnnotationType annotationType = annotation2.getAnnotation();
            if (annotationType == null || !Deprecated.class.getName().equals(annotationType.getIdentifier())) continue;
            return true;
        }
        return false;
    }

    public static boolean isTransitivelyDeprecatedMember(JvmMember member) {
        EObject container2 = member;
        while (container2 instanceof JvmMember) {
            if (DeprecationUtil.isDeprecatedMember(container2)) {
                return true;
            }
            container2 = container2.eContainer();
        }
        return false;
    }
}

