/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.descriptions;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.eclipse.xtext.common.types.descriptions.ClasspathTypeDescriptor;
import org.eclipse.xtext.common.types.descriptions.ITypeDescriptor;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Singleton
public class ClasspathScanner {
    @Inject
    private final Provider<ClassGraph> classGraphProvider = ClassGraph::new;
    private final Cache<ClassLoaderPackageConfig, Iterable<ITypeDescriptor>> classLoaderDescriptors = this.createClassLoaderCache();
    private String[] systemClasspath = null;

    protected Cache<ClassLoaderPackageConfig, Iterable<ITypeDescriptor>> createClassLoaderCache() {
        return CacheBuilder.newBuilder().initialCapacity(8).concurrencyLevel(2).maximumSize(32L).expireAfterAccess(5L, TimeUnit.MINUTES).build();
    }

    public Iterable<ITypeDescriptor> getDescriptors(ClassLoader classLoader, Collection<String> packagePrefixes) {
        return this.getDescriptors(classLoader, false, packagePrefixes);
    }

    protected Iterable<ITypeDescriptor> getDescriptors(ClassLoader classLoader, boolean bootstrap, Collection<String> packagePrefixes) {
        ClassLoaderPackageConfig clPckCfg = new ClassLoaderPackageConfig(classLoader, bootstrap, packagePrefixes);
        try {
            return this.classLoaderDescriptors.get(clPckCfg, () -> this.loadDescriptors(classLoader, bootstrap, packagePrefixes));
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    public Iterable<ITypeDescriptor> getBootClasspathDescriptors(Collection<String> packagePrefixes) {
        return this.getDescriptors(ClassLoader.getSystemClassLoader(), true, packagePrefixes);
    }

    public String[] getSystemClasspath() {
        if (this.systemClasspath != null) {
            return this.systemClasspath;
        }
        ClassGraph classGraph = this.classGraphProvider.get().enableSystemJarsAndModules().addClassLoader(ClassLoader.getSystemClassLoader());
        Throwable throwable = null;
        Object var3_4 = null;
        try (ScanResult scanResult = classGraph.scan();){
            List<URI> classpathURIs = scanResult.getClasspathURIs();
            this.systemClasspath = (String[])classpathURIs.stream().map(uri -> {
                if ("jrt".equals(uri.getScheme())) {
                    return null;
                }
                return uri.getPath();
            }).filter(Objects::nonNull).toArray(String[]::new);
            return this.systemClasspath;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected Iterable<ITypeDescriptor> loadDescriptors(ClassLoader classLoader, boolean bootstrap, Collection<String> packagePrefixes) {
        ClassGraph classGraph = this.classGraphProvider.get().ignoreClassVisibility().enableClassInfo().acceptPackages(packagePrefixes.toArray(new String[packagePrefixes.size()])).addClassLoader(classLoader);
        if (bootstrap) {
            classGraph.enableSystemJarsAndModules();
        }
        Throwable throwable = null;
        Object var6_7 = null;
        try (ScanResult scanResult = classGraph.scan();){
            return this.loadDescriptors(scanResult);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected Iterable<ITypeDescriptor> loadDescriptors(ScanResult scanResult) {
        return scanResult.getAllClasses().stream().filter(clazz -> clazz.getResource() != null).map(clazz -> this.newDescriptor(clazz.getName(), clazz.getModifiers())).collect(Collectors.toList());
    }

    protected ITypeDescriptor newDescriptor(String name, int modifiers) {
        return new ClasspathTypeDescriptor(name, modifiers);
    }

    protected static class ClassLoaderPackageConfig {
        private final ClassLoader loader;
        private final boolean bootstrap;
        private final Collection<String> packagePrefixes;

        public ClassLoaderPackageConfig(ClassLoader loader, boolean bootstrap, Collection<String> packagePrefixes) {
            this.loader = loader;
            this.bootstrap = bootstrap;
            this.packagePrefixes = packagePrefixes;
        }

        public ClassLoader getLoader() {
            return this.loader;
        }

        public boolean isBootstrap() {
            return this.bootstrap;
        }

        public Collection<String> getPackagePrefixes() {
            return this.packagePrefixes;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loader == null ? 0 : this.loader.hashCode());
            result = 31 * result + (this.bootstrap ? 1231 : 1237);
            return 31 * result + (this.packagePrefixes == null ? 0 : this.packagePrefixes.hashCode());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ClassLoaderPackageConfig other = (ClassLoaderPackageConfig)obj;
            if (this.loader == null ? other.loader != null : !this.loader.equals(other.loader)) {
                return false;
            }
            if (other.bootstrap != this.bootstrap) {
                return false;
            }
            return !(this.packagePrefixes == null ? other.packagePrefixes != null : !this.packagePrefixes.equals(other.packagePrefixes));
        }

        public String toString() {
            ToStringBuilder b = new ToStringBuilder(this);
            b.add("loader", this.loader);
            b.add("bootstrap", this.bootstrap);
            b.add("packagePrefixes", this.packagePrefixes);
            return b.toString();
        }
    }
}

