/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.impl;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class InnerClassNameVariants {
    public Iterator<String> variantsFor(final String base) {
        final int[] positionsOfDollar = this.getPositionsOfDollar(base);
        if (positionsOfDollar.length == 0) {
            return Iterators.singletonIterator(base);
        }
        final int numberPositionsOfDollar = positionsOfDollar.length;
        int numberOfCombinations = (int)Math.pow(2.0, numberPositionsOfDollar);
        IntFunction<int[]> shouldElementAtPositionBeReplaced = new IntFunction<int[]>(){

            @Override
            public int[] apply(int value) {
                int[] shouldElementBeReplaced = new int[numberPositionsOfDollar];
                int valueCopy = value;
                int c = 0;
                while (c < shouldElementBeReplaced.length) {
                    if (valueCopy % 2 == 1) {
                        shouldElementBeReplaced[c] = 1;
                    }
                    valueCopy /= 2;
                    ++c;
                }
                return shouldElementBeReplaced;
            }
        };
        Function<int[], String> replaceAtPositions = new Function<int[], String>(){

            @Override
            public String apply(int[] shouldElementBeReplaced) {
                StringBuilder baseAsBuilder = new StringBuilder(base);
                int position = 0;
                while (position < shouldElementBeReplaced.length) {
                    int p = shouldElementBeReplaced[position];
                    if (p > 0) {
                        baseAsBuilder.setCharAt(positionsOfDollar[position], '.');
                    }
                    ++position;
                }
                return baseAsBuilder.toString();
            }
        };
        Stream<String> resultStream = IntStream.range(0, numberOfCombinations).mapToObj(shouldElementAtPositionBeReplaced).map(replaceAtPositions);
        return resultStream.iterator();
    }

    private int[] getPositionsOfDollar(String base) {
        int start = base.lastIndexOf(46);
        if (start < 0) {
            start = 0;
        }
        StringBuilder baseAsBuilder = new StringBuilder(base);
        return IntStream.range(start, baseAsBuilder.length()).filter(i -> baseAsBuilder.charAt(i) == '$').toArray();
    }
}

