/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ContentHandler;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.access.IMirror;
import org.eclipse.xtext.common.types.access.TypeResource;
import org.eclipse.xtext.common.types.access.binary.BinaryClass;
import org.eclipse.xtext.common.types.access.binary.BinaryClassFinder;
import org.eclipse.xtext.common.types.access.binary.BinaryClassMirror;
import org.eclipse.xtext.common.types.access.binary.asm.ClassFileBytesAccess;
import org.eclipse.xtext.common.types.access.impl.AbstractRuntimeJvmTypeProvider;
import org.eclipse.xtext.common.types.access.impl.DeclaredTypeFactory;
import org.eclipse.xtext.common.types.access.impl.ITypeFactory;
import org.eclipse.xtext.common.types.access.impl.IndexedJvmTypeAccess;
import org.eclipse.xtext.common.types.access.impl.TypeResourceServices;
import org.eclipse.xtext.common.types.access.impl.URIHelperConstants;
import org.eclipse.xtext.util.Strings;

public class ClasspathTypeProvider
extends AbstractRuntimeJvmTypeProvider {
    private final BinaryClassFinder classFinder;
    private final ITypeFactory<BinaryClass, JvmDeclaredType> typeFactory;
    private final ClassLoader classLoader;
    private final ClassFileBytesAccess readerAccess;

    @Deprecated
    public ClasspathTypeProvider(ClassLoader classLoader, ResourceSet resourceSet, IndexedJvmTypeAccess indexedJvmTypeAccess) {
        this(classLoader, resourceSet, indexedJvmTypeAccess, null);
    }

    public ClasspathTypeProvider(ClassLoader classLoader, ResourceSet resourceSet, IndexedJvmTypeAccess indexedJvmTypeAccess, TypeResourceServices services) {
        super(resourceSet, indexedJvmTypeAccess, services);
        this.classLoader = classLoader;
        this.readerAccess = this.createClassFileReaderAccess();
        this.classFinder = this.createBinaryClassFinder(classLoader);
        this.typeFactory = this.createDeclaredTypeFactory(this.readerAccess, classLoader);
        ((JavaURIConverter)resourceSet.getURIConverter()).classLoader = classLoader;
    }

    protected ClassFileBytesAccess createClassFileReaderAccess() {
        return new ClassFileBytesAccess();
    }

    @Override
    protected void registerProtocol(ResourceSet resourceSet) {
        super.registerProtocol(resourceSet);
        URIConverter existing = resourceSet.getURIConverter();
        resourceSet.setURIConverter(new JavaURIConverter(existing));
    }

    protected BinaryClassFinder createBinaryClassFinder(ClassLoader classLoader) {
        return new BinaryClassFinder(classLoader);
    }

    protected ITypeFactory<BinaryClass, JvmDeclaredType> createDeclaredTypeFactory(ClassFileBytesAccess readerAccess, ClassLoader classLoader) {
        return new DeclaredTypeFactory(readerAccess, classLoader);
    }

    public ITypeFactory<BinaryClass, JvmDeclaredType> getDeclaredTypeFactory() {
        return this.typeFactory;
    }

    public BinaryClassFinder getClassFinder() {
        return this.classFinder;
    }

    @Override
    public JvmType findTypeByName(String name) {
        try {
            BinaryClass clazz = (BinaryClass)this.classFinder.forName(name);
            return this.findTypeByClass(clazz);
        }
        catch (ClassNotFoundException e) {
            return this.tryFindTypeInIndex(name, true);
        }
    }

    @Override
    public TypeResource createResource(URI uri) {
        String qualifiedName = uri.lastSegment();
        if (qualifiedName.lastIndexOf(36) != -1) {
            String outermostClassName = new BinaryClass(qualifiedName, this.classLoader).getOutermostClassName();
            return super.createResource(URIHelperConstants.OBJECTS_URI.appendSegment(outermostClassName));
        }
        return super.createResource(uri);
    }

    @Override
    public JvmType findTypeByName(String name, boolean binaryNestedTypeDelimiter) {
        if (this.isBinaryNestedTypeDelimiter(name, binaryNestedTypeDelimiter)) {
            return this.findTypeByName(name);
        }
        return this.doFindTypeByName(name);
    }

    private JvmType doFindTypeByName(String name) {
        try {
            BinaryClass clazz = this.findClassByName(name);
            return this.findTypeByClass(clazz);
        }
        catch (AbstractRuntimeJvmTypeProvider.ClassNotFoundExceptionWithBaseName e) {
            String outerName = e.getBaseName();
            JvmType outer = this.doFindTypeByName(outerName);
            if (outer instanceof JvmDeclaredType) {
                String nestedNames = name.substring(outerName.length() + 1);
                List<String> segments = Strings.split(nestedNames, ".");
                return this.findNestedType((JvmDeclaredType)outer, segments, 0);
            }
            return null;
        }
        catch (ClassNotFoundException e) {
            return this.tryFindTypeInIndex(name, false);
        }
    }

    private JvmType findTypeByClass(BinaryClass clazz) {
        try {
            URI proxyURI;
            EObject candidate;
            IndexedJvmTypeAccess indexedJvmTypeAccess = this.getIndexedJvmTypeAccess();
            URI resourceURI = clazz.getResourceURI();
            if (indexedJvmTypeAccess != null && (candidate = indexedJvmTypeAccess.getIndexedJvmType(proxyURI = resourceURI.appendFragment(clazz.getURIFragment()), this.getResourceSet())) instanceof JvmType) {
                return (JvmType)candidate;
            }
            TypeResource result = (TypeResource)this.getResourceSet().getResource(resourceURI, true);
            return this.findTypeByClass(clazz, result);
        }
        catch (IndexedJvmTypeAccess.UnknownNestedTypeException e) {
            return null;
        }
    }

    private BinaryClass findClassByName(String name) throws ClassNotFoundException {
        try {
            BinaryClass clazz = (BinaryClass)this.classFinder.forName(name);
            return clazz;
        }
        catch (ClassNotFoundException exception) {
            int index = name.lastIndexOf(46);
            if (index <= 0) {
                throw exception;
            }
            String baseName = name.substring(0, index);
            try {
                BinaryClass resolvedOuterClass = this.findClassByName(baseName);
                baseName = resolvedOuterClass.getName();
            }
            catch (ClassNotFoundException baseNameException) {
                throw exception;
            }
            String validBaseName = baseName;
            try {
                String binaryName = String.valueOf(baseName) + '$' + name.substring(index + 1);
                BinaryClass clazz = (BinaryClass)this.classFinder.forName(binaryName);
                return clazz;
            }
            catch (ClassNotFoundException e) {
                throw new AbstractRuntimeJvmTypeProvider.ClassNotFoundExceptionWithBaseName(validBaseName);
            }
        }
    }

    @Override
    protected IMirror createMirrorForFQN(String name) {
        try {
            BinaryClass clazz = (BinaryClass)this.classFinder.forName(name);
            return this.createMirror(clazz);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public BinaryClassMirror createMirror(BinaryClass clazz) {
        return BinaryClassMirror.createClassMirror(clazz, this.typeFactory);
    }

    public JvmType findTypeByClass(BinaryClass clazz, Resource resource) {
        String fragment = clazz.getURIFragment();
        JvmType result = (JvmType)resource.getEObject(fragment);
        if (result == null) {
            throw new IllegalStateException("Resource has not been loaded");
        }
        return result;
    }

    private static class JavaURIConverter
    implements URIConverter {
        private final URIConverter existing;
        private ClassLoader classLoader;

        private JavaURIConverter(URIConverter existing) {
            this.existing = existing;
        }

        @Override
        public URI normalize(URI uri) {
            if ("java".equals(uri.scheme())) {
                String qualifiedName = uri.lastSegment();
                if (qualifiedName.lastIndexOf(36) != -1) {
                    String outermostClassName = new BinaryClass(qualifiedName, this.classLoader).getOutermostClassName();
                    return URIHelperConstants.OBJECTS_URI.appendSegment(outermostClassName);
                }
                return uri;
            }
            return this.existing.normalize(uri);
        }

        @Override
        public Map<URI, URI> getURIMap() {
            return this.existing.getURIMap();
        }

        @Override
        public EList<URIHandler> getURIHandlers() {
            return this.existing.getURIHandlers();
        }

        @Override
        public URIHandler getURIHandler(URI uri) {
            return this.existing.getURIHandler(uri);
        }

        @Override
        public EList<ContentHandler> getContentHandlers() {
            return this.existing.getContentHandlers();
        }

        @Override
        public InputStream createInputStream(URI uri) throws IOException {
            return this.existing.createInputStream(uri);
        }

        @Override
        public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
            return this.existing.createInputStream(uri, options);
        }

        @Override
        public OutputStream createOutputStream(URI uri) throws IOException {
            return this.existing.createOutputStream(uri);
        }

        @Override
        public OutputStream createOutputStream(URI uri, Map<?, ?> options) throws IOException {
            return this.existing.createOutputStream(uri, options);
        }

        @Override
        public void delete(URI uri, Map<?, ?> options) throws IOException {
            this.existing.delete(uri, options);
        }

        @Override
        public Map<String, ?> contentDescription(URI uri, Map<?, ?> options) throws IOException {
            return this.existing.contentDescription(uri, options);
        }

        @Override
        public boolean exists(URI uri, Map<?, ?> options) {
            return this.existing.exists(uri, options);
        }

        @Override
        public Map<String, ?> getAttributes(URI uri, Map<?, ?> options) {
            return this.existing.getAttributes(uri, options);
        }

        @Override
        public void setAttributes(URI uri, Map<String, ?> attributes, Map<?, ?> options) throws IOException {
            this.existing.setAttributes(uri, attributes, options);
        }
    }
}

