/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.binary.asm;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.xtext.common.types.access.binary.asm.AbstractBinarySignature;
import org.eclipse.xtext.common.types.access.binary.asm.BinaryGenericTypeSignature;
import org.eclipse.xtext.common.types.access.binary.asm.SignatureUtil;

public class BinaryTypeParameter
extends AbstractBinarySignature {
    BinaryTypeParameter(String chars, int offset, int length) {
        super(chars, offset, length);
    }

    public String getName() {
        int p = this.chars.indexOf(58, this.offset);
        return this.chars.substring(this.offset, p);
    }

    public List<BinaryGenericTypeSignature> getBounds() {
        int end = this.offset + this.length;
        int afterTypeParameterName = this.chars.indexOf(58, this.offset);
        if (afterTypeParameterName >= end) {
            throw new IllegalArgumentException();
        }
        if (afterTypeParameterName == this.chars.length() - 1) {
            return Collections.emptyList();
        }
        if (this.chars.charAt(afterTypeParameterName + 1) == ':') {
            ArrayList<BinaryGenericTypeSignature> result = Lists.newArrayListWithCapacity(3);
            int nextInterface = afterTypeParameterName + 2;
            while (nextInterface <= end) {
                int afterInterfaceBound = SignatureUtil.scanTypeSignature(this.chars, nextInterface) + 1;
                BinaryGenericTypeSignature intf = new BinaryGenericTypeSignature(this.chars, nextInterface, afterInterfaceBound - nextInterface);
                result.add(intf);
                nextInterface = afterInterfaceBound + 1;
            }
            return result;
        }
        int afterClassBound = SignatureUtil.scanTypeSignature(this.chars, afterTypeParameterName + 1);
        BinaryGenericTypeSignature classBound = new BinaryGenericTypeSignature(this.chars, afterTypeParameterName + 1, afterClassBound - afterTypeParameterName);
        if (afterClassBound == end - 1) {
            return Collections.singletonList(classBound);
        }
        if (afterClassBound != end - 2) {
            int nextInterface = afterClassBound + 1;
            ArrayList<BinaryGenericTypeSignature> result = Lists.newArrayListWithCapacity(3);
            result.add(classBound);
            while (nextInterface != end) {
                int afterInterfaceBound = this.scanTypeSignature(this.chars, nextInterface + 1);
                BinaryGenericTypeSignature intf = new BinaryGenericTypeSignature(this.chars, nextInterface + 1, afterInterfaceBound - nextInterface);
                result.add(intf);
                nextInterface = afterInterfaceBound + 1;
            }
            return result;
        }
        return Collections.singletonList(classBound);
    }

    private int scanTypeSignature(String chars, int i) {
        return SignatureUtil.scanTypeSignature(chars, i);
    }
}

