/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.common.types.access.IJavaSchemeUriResolver;
import org.eclipse.xtext.common.types.access.IMirror;
import org.eclipse.xtext.common.types.access.IMirrorOptionsAware;
import org.eclipse.xtext.common.types.access.impl.IndexedJvmTypeAccess;
import org.eclipse.xtext.common.types.access.impl.TypeResourceServices;
import org.eclipse.xtext.resource.IFragmentProvider;
import org.eclipse.xtext.resource.ISynchronizable;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class TypeResource
extends ResourceImpl
implements ISynchronizable<TypeResource>,
IJavaSchemeUriResolver {
    public static final String OPTION_CLASSPATH_CONTEXT = "OPTION_CLASSPATH_CONTEXT";
    private IMirror mirror;
    private IndexedJvmTypeAccess indexedJvmTypeAccess;
    private TypeResourceServices typeResourceServices;
    private IFragmentProvider.Fallback fragmentProviderFallback = new IFragmentProvider.Fallback(){

        @Override
        public String getFragment(EObject obj) {
            return TypeResource.super.getURIFragment(obj);
        }

        @Override
        public EObject getEObject(String fragment) {
            return TypeResource.super.getEObject(fragment);
        }
    };

    public void setTypeResourceServices(TypeResourceServices typeResourceServices) {
        this.typeResourceServices = typeResourceServices;
    }

    public TypeResource() {
    }

    public TypeResource(URI uri) {
        super(uri);
    }

    @Override
    public NotificationChain basicSetResourceSet(ResourceSet resourceSet, NotificationChain notifications) {
        ResourceSet oldResourceSet;
        if (resourceSet == null && (oldResourceSet = this.resourceSet) != null && !oldResourceSet.eDeliver()) {
            if (this.mirror instanceof Adapter) {
                Adapter adapter = (Adapter)((Object)this.mirror);
                oldResourceSet.eAdapters().remove(adapter);
            }
            this.mirror = null;
            this.eSetDeliver(false);
            if (this.contents != null) {
                this.contents.clear();
            }
            this.unload();
        }
        return super.basicSetResourceSet(resourceSet, notifications);
    }

    @Override
    public EObject getEObject(String uriFragment) {
        if (this.mirror != null) {
            EObject result = this.mirror.getEObject(this, uriFragment, this.fragmentProviderFallback);
            return result;
        }
        return super.getEObject(uriFragment);
    }

    @Override
    public String getURIFragment(EObject eObject) {
        if (this.mirror != null) {
            String result = this.mirror.getFragment(eObject, this.fragmentProviderFallback);
            return result;
        }
        return super.getURIFragment(eObject);
    }

    public void setMirror(IMirror mirror) {
        this.mirror = mirror;
    }

    public IMirror getMirror() {
        return this.mirror;
    }

    @Override
    public void load(Map<?, ?> options) throws IOException {
        if (!this.isLoaded) {
            this.load(null, options);
        }
    }

    @Override
    public void save(Map<?, ?> options) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        try {
            if (this.getURI() != null && this.mirror != null) {
                if (this.mirror instanceof IMirrorOptionsAware) {
                    ((IMirrorOptionsAware)this.mirror).initialize(this, options);
                } else {
                    this.mirror.initialize(this);
                }
            }
        }
        catch (Exception e) {
            if (this.typeResourceServices != null) {
                OperationCanceledManager operationCanceledManager = this.typeResourceServices.getOperationCanceledManager();
                if (operationCanceledManager.isOperationCanceledException(e)) {
                    this.unload();
                }
                operationCanceledManager.propagateAsErrorIfCancelException(e);
            }
            throw new CannotLoadTypeResourceException(e);
        }
    }

    @Override
    public EObject resolveJavaObjectURIProxy(InternalEObject proxy, EObject sender) {
        URI proxyURI = proxy.eProxyURI();
        if (proxyURI != null && "java".equals(proxyURI.scheme()) && "Objects".equals(proxyURI.segment(0))) {
            if (this.indexedJvmTypeAccess != null) {
                try {
                    EObject result = this.indexedJvmTypeAccess.getIndexedJvmType(proxy.eProxyURI(), this.getResourceSet());
                    if (result != null) {
                        return result;
                    }
                }
                catch (IndexedJvmTypeAccess.UnknownNestedTypeException e) {
                    return proxy;
                }
            }
            return EcoreUtil.resolve((EObject)proxy, sender);
        }
        return null;
    }

    public IndexedJvmTypeAccess getIndexedJvmTypeAccess() {
        return this.indexedJvmTypeAccess;
    }

    public void setIndexedJvmTypeAccess(IndexedJvmTypeAccess indexedJvmTypeAccess) {
        this.indexedJvmTypeAccess = indexedJvmTypeAccess;
    }

    @Override
    public Object getLock() {
        ResourceSet resourceSet = this.getResourceSet();
        if (resourceSet instanceof ISynchronizable) {
            return ((ISynchronizable)((Object)resourceSet)).getLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <Result> Result execute(IUnitOfWork<Result, ? super TypeResource> unit) throws Exception {
        Object object = this.getLock();
        synchronized (object) {
            return unit.exec(this);
        }
    }

    protected static class CannotLoadTypeResourceException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public CannotLoadTypeResourceException(Exception e) {
            super(e.getMessage());
            this.initCause(e);
        }
    }
}

