/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum JvmVisibility implements Enumerator
{
    DEFAULT(0, "DEFAULT", "DEFAULT"),
    PRIVATE(1, "PRIVATE", "PRIVATE"),
    PROTECTED(2, "PROTECTED", "PROTECTED"),
    PUBLIC(3, "PUBLIC", "PUBLIC");

    public static final int DEFAULT_VALUE = 0;
    public static final int PRIVATE_VALUE = 1;
    public static final int PROTECTED_VALUE = 2;
    public static final int PUBLIC_VALUE = 3;
    private static final JvmVisibility[] VALUES_ARRAY;
    public static final List<JvmVisibility> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new JvmVisibility[]{DEFAULT, PRIVATE, PROTECTED, PUBLIC};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static JvmVisibility get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            JvmVisibility result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static JvmVisibility getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            JvmVisibility result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static JvmVisibility get(int value) {
        switch (value) {
            case 0: {
                return DEFAULT;
            }
            case 1: {
                return PRIVATE;
            }
            case 2: {
                return PROTECTED;
            }
            case 3: {
                return PUBLIC;
            }
        }
        return null;
    }

    private JvmVisibility(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

