/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.build;

import com.google.common.collect.Iterables;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.build.ClusteringStorageAwareResourceLoader;
import org.eclipse.xtext.build.IndexState;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.resource.clustering.IResourceClusteringPolicy;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.lib.Functions;

public class BuildContext {
    private final Functions.Function1<? super URI, ? extends IResourceServiceProvider> resourceServiceProviderProvider;
    private final XtextResourceSet resourceSet;
    private final IndexState oldState;
    private final IResourceClusteringPolicy clusteringPolicy;
    private final CancelIndicator cancelIndicator;
    private ClusteringStorageAwareResourceLoader loader;

    public BuildContext(Functions.Function1<? super URI, ? extends IResourceServiceProvider> resourceServiceProviderProvider, XtextResourceSet resourceSet, IndexState oldState, IResourceClusteringPolicy clusteringPolicy, CancelIndicator cancelIndicator) {
        this.resourceServiceProviderProvider = resourceServiceProviderProvider;
        this.resourceSet = resourceSet;
        this.oldState = oldState;
        this.clusteringPolicy = clusteringPolicy;
        this.cancelIndicator = cancelIndicator;
    }

    public <T> Iterable<T> executeClustered(Iterable<URI> uris, Functions.Function1<? super Resource, ? extends T> operation) {
        if (this.loader == null) {
            this.loader = new ClusteringStorageAwareResourceLoader(this);
        }
        return this.loader.executeClustered(Iterables.filter(uris, this::canHandle), operation);
    }

    protected boolean canHandle(URI uri) {
        IResourceServiceProvider resourceServiceProvider = this.getResourceServiceProvider(uri);
        if (resourceServiceProvider == null) {
            return false;
        }
        return resourceServiceProvider.canHandle(uri);
    }

    public IResourceServiceProvider getResourceServiceProvider(URI uri) {
        return this.resourceServiceProviderProvider.apply(uri);
    }

    public XtextResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public IndexState getOldState() {
        return this.oldState;
    }

    public IResourceClusteringPolicy getClusteringPolicy() {
        return this.clusteringPolicy;
    }

    public CancelIndicator getCancelIndicator() {
        return this.cancelIndicator;
    }
}

