/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.storage;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.osgi.framework.internal.reliablefile.ReliableFile;
import org.eclipse.osgi.internal.debug.Debug;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class StorageUtil {
    private static final boolean IS_WINDOWS = File.separatorChar == '\\';
    private static final Set<String> RESERVED_NAMES = new HashSet<String>(Arrays.asList("aux", "com1", "com2", "com3", "com4", "com5", "com6", "com7", "com8", "com9", "con", "lpt1", "lpt2", "lpt3", "lpt4", "lpt5", "lpt6", "lpt7", "lpt8", "lpt9", "nul", "prn"));

    public static void copy(File inFile, File outFile) throws IOException {
        Path source = inFile.toPath();
        Path target = outFile.toPath();
        if (Files.exists(source, new LinkOption[0])) {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            Throwable throwable = null;
            Object var5_6 = null;
            try (Stream<Path> walk = Files.walk(source, new FileVisitOption[0]);){
                for (Path s2 : walk::iterator) {
                    Path t2 = target.resolve(source.relativize(s2));
                    Files.copy(s2, t2, StandardCopyOption.REPLACE_EXISTING);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public static void readFile(InputStream in, File file) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream stream = in;){
            Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static boolean rm(File file, final boolean DEBUG) {
        Path path = file.toPath();
        if (!Files.exists(path, new LinkOption[0])) {
            return true;
        }
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path f, BasicFileAttributes attrs) {
                    return this.delete(f, DEBUG);
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    return this.delete(dir, DEBUG);
                }

                private FileVisitResult delete(Path pathToDelete, boolean debug) {
                    block3: {
                        try {
                            if (debug) {
                                Debug.println("rm " + pathToDelete);
                            }
                            Files.delete(pathToDelete);
                        }
                        catch (IOException e) {
                            if (!debug) break block3;
                            Debug.println("  rm failed:" + e.getMessage());
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            return !Files.exists(path, new LinkOption[0]);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static ServiceRegistration<?> register(String name, Object service, BundleContext context) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("service.ranking", Integer.MAX_VALUE);
        ((Dictionary)properties).put("service.pid", String.valueOf(context.getBundle().getBundleId()) + "." + service.getClass().getName());
        return context.registerService(name, service, properties);
    }

    public static boolean canWrite(File installDir) {
        if (!installDir.isDirectory()) {
            return false;
        }
        if (Files.isWritable(installDir.toPath())) {
            return true;
        }
        File fileTest = null;
        try {
            try {
                fileTest = ReliableFile.createTempFile("writableArea", ".dll", installDir);
            }
            catch (IOException iOException) {
                if (fileTest != null) {
                    fileTest.delete();
                }
                return false;
            }
        }
        finally {
            if (fileTest != null) {
                fileTest.delete();
            }
        }
        return true;
    }

    public static URL encodeFileURL(File file) throws MalformedURLException {
        return file.toURI().toURL();
    }

    public static byte[] getBytes(InputStream in, int length, int BUF_SIZE) throws IOException {
        byte[] classbytes;
        int bytesread = 0;
        try {
            byte[] oldbytes;
            if (length > 0) {
                classbytes = new byte[length];
                while (bytesread < length) {
                    int readcount = in.read(classbytes, bytesread, length - bytesread);
                    if (readcount > 0) {
                        bytesread += readcount;
                        continue;
                    }
                    break;
                }
            } else {
                length = BUF_SIZE;
                classbytes = new byte[length];
                while (true) {
                    if (bytesread < length) {
                        int readcount = in.read(classbytes, bytesread, length - bytesread);
                        if (readcount > 0) {
                            bytesread += readcount;
                            continue;
                        }
                        break;
                    }
                    oldbytes = classbytes;
                    classbytes = new byte[length += BUF_SIZE];
                    System.arraycopy(oldbytes, 0, classbytes, 0, bytesread);
                }
            }
            if (classbytes.length > bytesread) {
                oldbytes = classbytes;
                classbytes = new byte[bytesread];
                System.arraycopy(oldbytes, 0, classbytes, 0, bytesread);
            }
        }
        catch (Throwable throwable) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException iOException) {}
        return classbytes;
    }

    public static void move(File from, File to, boolean DEBUG) throws IOException {
        try {
            Files.move(from.toPath(), to.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException iOException) {
            if (DEBUG) {
                Debug.println("Failed to move atomically: " + from + " to " + to);
            }
            StorageUtil.rm(to, DEBUG);
            Files.move(from.toPath(), to.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        if (DEBUG) {
            Debug.println("Successfully moved file: " + from + " to " + to);
        }
    }

    public static boolean isReservedFileName(File file) {
        if (!IS_WINDOWS) {
            return false;
        }
        String fileName = file.getName();
        int dot = fileName.indexOf(46);
        String basename = dot == -1 ? fileName : fileName.substring(0, dot);
        return RESERVED_NAMES.contains(basename.toLowerCase());
    }
}

