/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.url;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osgi.internal.framework.EquinoxBundle;
import org.eclipse.osgi.internal.framework.EquinoxContainer;
import org.eclipse.osgi.storage.StorageUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public abstract class MultiplexingFactory {
    public static final Collection<AccessibleObject> setAccessible;
    static final Collection<ClassLoader> systemLoaders;
    protected EquinoxContainer container;
    protected BundleContext context;
    private List<Object> factories;
    private static InternalSecurityManager internalSecurityManager;

    static {
        Collection result = null;
        try {
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            Field theUnsafe = unsafeClass.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            Object unsafe = theUnsafe.get(null);
            byte[] bytes = StorageUtil.getBytes(MultiplexingFactory.class.getResource("SetAccessible.bytes").openStream(), -1, 4000);
            Class<?> collectionClass = null;
            try {
                Class<?> unchecked;
                Method defineAnonymousClass = unsafeClass.getMethod("defineAnonymousClass", Class.class, byte[].class, Object[].class);
                collectionClass = unchecked = (Class<?>)defineAnonymousClass.invoke(unsafe, URL.class, bytes, null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Class<?> unchecked;
                long offset = (Long)unsafeClass.getMethod("staticFieldOffset", Field.class).invoke(unsafe, MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP"));
                MethodHandles.Lookup lookup = (MethodHandles.Lookup)unsafeClass.getMethod("getObject", Object.class, Long.TYPE).invoke(unsafe, MethodHandles.Lookup.class, offset);
                lookup = lookup.in(URL.class);
                Class<?> classOption = Class.forName("java.lang.invoke.MethodHandles$Lookup$ClassOption");
                Object classOptions = Array.newInstance(classOption, 0);
                Method defineHiddenClass = MethodHandles.Lookup.class.getMethod("defineHiddenClass", byte[].class, Boolean.TYPE, classOptions.getClass());
                lookup = (MethodHandles.Lookup)defineHiddenClass.invoke((Object)lookup, bytes, Boolean.FALSE, classOptions);
                collectionClass = unchecked = lookup.lookupClass();
            }
            result = (Collection)collectionClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable t2) {
            t2.printStackTrace();
        }
        setAccessible = result;
        ArrayList<ClassLoader> loaders = new ArrayList<ClassLoader>();
        try {
            ClassLoader cl = ClassLoader.getSystemClassLoader();
            while (cl != null) {
                loaders.add(cl);
                cl = cl.getParent();
            }
        }
        catch (Throwable throwable) {}
        systemLoaders = Collections.unmodifiableCollection(loaders);
        internalSecurityManager = new InternalSecurityManager();
    }

    MultiplexingFactory(BundleContext context, EquinoxContainer container2) {
        this.context = context;
        this.container = container2;
    }

    public abstract void setParentFactory(Object var1);

    public abstract Object getParentFactory();

    public boolean isMultiplexing() {
        return this.getFactories() != null;
    }

    public void register(Object factory) {
        try {
            Class<?> clazz = factory.getClass();
            Method setParentFactory = clazz.getMethod("setParentFactory", Object.class);
            setParentFactory.invoke(factory, this.getParentFactory());
        }
        catch (Exception e) {
            this.container.getLogServices().log(MultiplexingFactory.class.getName(), 4, "register", e);
            return;
        }
        this.addFactory(factory);
    }

    public void unregister(Object factory) {
        this.removeFactory(factory);
        try {
            Method closeTracker = factory.getClass().getSuperclass().getDeclaredMethod("closePackageAdminTracker", null);
            closeTracker.setAccessible(true);
            closeTracker.invoke(factory, null);
        }
        catch (Exception e) {
            this.container.getLogServices().log(MultiplexingFactory.class.getName(), 4, "unregister", e);
        }
    }

    public Object designateSuccessor() {
        List<Object> released = this.releaseFactories();
        if (released == null || released.isEmpty()) {
            return this.getParentFactory();
        }
        Object successor = released.remove(0);
        try {
            Class<?> clazz = successor.getClass();
            Method register = clazz.getMethod("register", Object.class);
            for (Object r : released) {
                register.invoke(successor, r);
            }
        }
        catch (Exception e) {
            this.container.getLogServices().log(MultiplexingFactory.class.getName(), 4, "designateSuccessor", e);
            throw new RuntimeException(e.getMessage(), e);
        }
        this.closePackageAdminTracker();
        return successor;
    }

    private void closePackageAdminTracker() {
    }

    public Object findAuthorizedFactory(List<Class<?>> ignoredClasses) {
        Class<?>[] classStack;
        List<Object> current = this.getFactories();
        Class<?>[] classArray = classStack = internalSecurityManager.getClassContext();
        int n = classStack.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz = classArray[n2];
            if (clazz != InternalSecurityManager.class && clazz != MultiplexingFactory.class && !ignoredClasses.contains(clazz) && !this.isSystemClass(clazz)) {
                if (this.hasAuthority(clazz)) {
                    return this;
                }
                if (current != null) {
                    for (Object factory : current) {
                        try {
                            Method hasAuthorityMethod = factory.getClass().getMethod("hasAuthority", Class.class);
                            if (!((Boolean)hasAuthorityMethod.invoke(factory, clazz)).booleanValue()) continue;
                            return factory;
                        }
                        catch (Exception e) {
                            this.container.getLogServices().log(MultiplexingFactory.class.getName(), 4, "findAuthorizedURLStreamHandler-loop", e);
                        }
                    }
                }
            }
            ++n2;
        }
        return this;
    }

    private boolean isSystemClass(final Class<?> clazz) {
        ClassLoader cl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return clazz.getClassLoader();
            }
        });
        return cl == null || systemLoaders.contains(cl);
    }

    public boolean hasAuthority(Class<?> clazz) {
        Bundle b = FrameworkUtil.getBundle(clazz);
        if (!(b instanceof EquinoxBundle)) {
            return false;
        }
        return this.container.getStorage().getModuleContainer() == ((EquinoxBundle)b).getModule().getContainer();
    }

    private synchronized List<Object> getFactories() {
        return this.factories;
    }

    private synchronized List<Object> releaseFactories() {
        if (this.factories == null) {
            return null;
        }
        LinkedList<Object> released = new LinkedList<Object>(this.factories);
        this.factories = null;
        return released;
    }

    private synchronized void addFactory(Object factory) {
        LinkedList<Object> updated = this.factories == null ? new LinkedList<Object>() : new LinkedList<Object>(this.factories);
        updated.add(factory);
        this.factories = updated;
    }

    private synchronized void removeFactory(Object factory) {
        LinkedList<Object> updated = new LinkedList<Object>(this.factories);
        updated.remove(factory);
        this.factories = updated.isEmpty() ? null : updated;
    }

    static void setAccessible(AccessibleObject o) {
        if (setAccessible != null) {
            setAccessible.add(o);
        } else {
            o.setAccessible(true);
        }
    }

    static class InternalSecurityManager
    extends SecurityManager {
        InternalSecurityManager() {
        }

        @Override
        public Class<?>[] getClassContext() {
            return super.getClassContext();
        }
    }
}

