/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.signedcontent;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.osgi.framework.util.SecureAction;
import org.eclipse.osgi.internal.framework.EquinoxBundle;
import org.eclipse.osgi.internal.framework.EquinoxContainer;
import org.eclipse.osgi.internal.hookregistry.ActivatorHookFactory;
import org.eclipse.osgi.internal.hookregistry.HookConfigurator;
import org.eclipse.osgi.internal.hookregistry.HookRegistry;
import org.eclipse.osgi.internal.service.security.KeyStoreTrustEngine;
import org.eclipse.osgi.internal.signedcontent.SignedContentConstants;
import org.eclipse.osgi.internal.signedcontent.SignedContentFromBundleFile;
import org.eclipse.osgi.internal.signedcontent.TrustEngineListener;
import org.eclipse.osgi.service.security.TrustEngine;
import org.eclipse.osgi.signedcontent.SignedContent;
import org.eclipse.osgi.signedcontent.SignedContentFactory;
import org.eclipse.osgi.signedcontent.SignerInfo;
import org.eclipse.osgi.storage.BundleInfo;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class SignedBundleHook
implements ActivatorHookFactory,
HookConfigurator,
SignedContentFactory {
    static final SecureAction secureAction = AccessController.doPrivileged(SecureAction.createSecureAction());
    private static final String CACERTS_PATH = String.valueOf(System.getProperty("java.home")) + File.separatorChar + "lib" + File.separatorChar + "security" + File.separatorChar + "cacerts";
    private static final String CACERTS_TYPE = "JKS";
    private static final String OSGI_KEYSTORE = "osgi.framework.keystore";
    private int supportSignedBundles;
    TrustEngineListener trustEngineListener;
    private String trustEngineNameProp;
    private ServiceRegistration<?> signedContentFactoryReg;
    private ServiceRegistration<?> systemTrustEngineReg;
    private List<ServiceRegistration<?>> osgiTrustEngineReg;
    private ServiceTracker<TrustEngine, TrustEngine> trustEngineTracker;
    private BundleContext context;
    private EquinoxContainer container;

    @Override
    public BundleActivator createActivator() {
        return new BundleActivator(){

            @Override
            public void start(BundleContext bc) throws Exception {
                SignedBundleHook.this.frameworkStart(bc);
            }

            @Override
            public void stop(BundleContext bc) throws Exception {
                SignedBundleHook.this.frameworkStop(bc);
            }
        };
    }

    BundleContext getContext() {
        return this.context;
    }

    void frameworkStart(BundleContext bc) {
        this.context = bc;
        if ((this.supportSignedBundles & 2) != 0) {
            this.trustEngineListener = new TrustEngineListener(this.context, this);
        }
        Hashtable<String, Object> trustEngineProps = new Hashtable<String, Object>(7);
        ((Dictionary)trustEngineProps).put("service.ranking", Integer.MIN_VALUE);
        ((Dictionary)trustEngineProps).put("osgi.signedcontent.trust.engine", SignedContentConstants.DEFAULT_TRUST_ENGINE);
        KeyStoreTrustEngine systemTrustEngine = new KeyStoreTrustEngine(CACERTS_PATH, CACERTS_TYPE, null, "System", this);
        this.systemTrustEngineReg = this.context.registerService(TrustEngine.class.getName(), (Object)systemTrustEngine, trustEngineProps);
        String osgiTrustPath = this.context.getProperty(OSGI_KEYSTORE);
        if (osgiTrustPath != null) {
            try {
                URL url = new URL(osgiTrustPath);
                if ("file".equals(url.getProtocol())) {
                    ((Dictionary)trustEngineProps).put("osgi.signedcontent.trust.engine", OSGI_KEYSTORE);
                    String path = url.getPath();
                    this.osgiTrustEngineReg = new ArrayList(1);
                    this.osgiTrustEngineReg.add(this.context.registerService(TrustEngine.class.getName(), (Object)new KeyStoreTrustEngine(path, CACERTS_TYPE, null, OSGI_KEYSTORE, this), trustEngineProps));
                }
            }
            catch (MalformedURLException e) {
                this.log("Invalid setting for osgi.framework.keystore", 2, e);
            }
        } else {
            String osgiTrustRepoPaths = this.context.getProperty("org.osgi.framework.trust.repositories");
            if (osgiTrustRepoPaths != null) {
                ((Dictionary)trustEngineProps).put("osgi.signedcontent.trust.engine", "org.osgi.framework.trust.repositories");
                StringTokenizer st = new StringTokenizer(osgiTrustRepoPaths, File.pathSeparator);
                this.osgiTrustEngineReg = new ArrayList(1);
                while (st.hasMoreTokens()) {
                    String trustRepoPath = st.nextToken();
                    this.osgiTrustEngineReg.add(this.context.registerService(TrustEngine.class.getName(), (Object)new KeyStoreTrustEngine(trustRepoPath, CACERTS_TYPE, null, OSGI_KEYSTORE, this), trustEngineProps));
                }
            }
        }
        this.signedContentFactoryReg = this.context.registerService(SignedContentFactory.class.getName(), (Object)this, null);
    }

    void frameworkStop(BundleContext bc) {
        if (this.signedContentFactoryReg != null) {
            this.signedContentFactoryReg.unregister();
            this.signedContentFactoryReg = null;
        }
        if (this.systemTrustEngineReg != null) {
            this.systemTrustEngineReg.unregister();
            this.systemTrustEngineReg = null;
        }
        if (this.osgiTrustEngineReg != null) {
            for (ServiceRegistration<?> serviceRegistration : this.osgiTrustEngineReg) {
                serviceRegistration.unregister();
            }
            this.osgiTrustEngineReg = null;
        }
        if (this.trustEngineTracker != null) {
            this.trustEngineTracker.close();
            this.trustEngineTracker = null;
        }
    }

    @Override
    public void addHooks(HookRegistry hookRegistry) {
        this.container = hookRegistry.getContainer();
        hookRegistry.addActivatorHookFactory(this);
        this.supportSignedBundles = hookRegistry.getConfiguration().supportSignedBundles;
        this.trustEngineNameProp = hookRegistry.getConfiguration().getConfiguration("osgi.signedcontent.trust.engine");
    }

    @Override
    public SignedContent getSignedContent(File content) throws IOException, InvalidKeyException, SignatureException, CertificateException, NoSuchAlgorithmException, NoSuchProviderException {
        SignedContentFromBundleFile signedContent = new SignedContentFromBundleFile(content, this.container.getConfiguration().getDebug());
        this.determineTrust(signedContent, 2);
        return signedContent;
    }

    @Override
    public SignedContent getSignedContent(Bundle bundle) throws IOException, InvalidKeyException, SignatureException, CertificateException, NoSuchAlgorithmException, NoSuchProviderException {
        BundleInfo.Generation generation = (BundleInfo.Generation)((EquinoxBundle)bundle).getModule().getCurrentRevision().getRevisionInfo();
        SignedContentFromBundleFile signedContent = new SignedContentFromBundleFile(generation.getBundleFile());
        this.determineTrust(signedContent, 2);
        return signedContent;
    }

    public void log(String msg, int severity, Throwable t2) {
        this.container.getLogServices().log("org.eclipse.osgi", severity, msg, t2);
    }

    private TrustEngine[] getTrustEngines() {
        Object[] services;
        if (this.context == null) {
            return new TrustEngine[0];
        }
        if (this.trustEngineTracker == null) {
            Filter filter = null;
            if (this.trustEngineNameProp != null) {
                try {
                    filter = this.context.createFilter("(&(objectClass=" + TrustEngine.class.getName() + ")(" + "osgi.signedcontent.trust.engine" + "=" + this.trustEngineNameProp + "))");
                }
                catch (InvalidSyntaxException e) {
                    this.log("Invalid trust engine filter", 2, e);
                }
            }
            this.trustEngineTracker = filter != null ? new ServiceTracker<TrustEngine, TrustEngine>(this.context, filter, new TrustEngineCustomizer()) : new ServiceTracker<TrustEngine, TrustEngine>(this.context, TrustEngine.class.getName(), new TrustEngineCustomizer());
            this.trustEngineTracker.open();
        }
        if ((services = this.trustEngineTracker.getServices()) != null) {
            TrustEngine[] engines = new TrustEngine[services.length];
            System.arraycopy(services, 0, engines, 0, services.length);
            return engines;
        }
        return new TrustEngine[0];
    }

    void determineTrust(SignedContentFromBundleFile trustedContent, int supportFlags) {
        SignerInfo[] signers;
        TrustEngine[] engines = null;
        SignerInfo[] signerInfoArray = signers = trustedContent.getSignerInfos();
        int n = signers.length;
        int n2 = 0;
        while (n2 < n) {
            SignerInfo signer = signerInfoArray[n2];
            if (signer.getTrustAnchor() == null) {
                if (engines == null) {
                    engines = this.getTrustEngines();
                }
                Certificate[] signerCerts = signer.getCertificateChain();
                ((SignedContentFromBundleFile.BaseSignerInfo)signer).setTrustAnchor(this.findTrustAnchor(signerCerts, engines, supportFlags));
                SignerInfo tsaSignerInfo = trustedContent.getTSASignerInfo(signer);
                if (tsaSignerInfo != null) {
                    Certificate[] tsaCerts = tsaSignerInfo.getCertificateChain();
                    ((SignedContentFromBundleFile.BaseSignerInfo)tsaSignerInfo).setTrustAnchor(this.findTrustAnchor(tsaCerts, engines, supportFlags));
                }
            }
            ++n2;
        }
    }

    private Certificate findTrustAnchor(Certificate[] certs, TrustEngine[] engines, int supportFlags) {
        if ((supportFlags & 2) == 0) {
            return certs != null && certs.length > 0 ? certs[certs.length - 1] : null;
        }
        TrustEngine[] trustEngineArray = engines;
        int n = engines.length;
        int n2 = 0;
        while (n2 < n) {
            TrustEngine engine = trustEngineArray[n2];
            try {
                Certificate anchor = engine.findTrustAnchor(certs);
                if (anchor != null) {
                    return anchor;
                }
            }
            catch (IOException e) {
                this.log("TrustEngine failure: " + engine.getName(), 2, e);
            }
            ++n2;
        }
        return null;
    }

    class TrustEngineCustomizer
    implements ServiceTrackerCustomizer<TrustEngine, TrustEngine> {
        TrustEngineCustomizer() {
        }

        @Override
        public TrustEngine addingService(ServiceReference<TrustEngine> reference) {
            TrustEngine engine = SignedBundleHook.this.getContext().getService(reference);
            if (engine != null) {
                try {
                    Field trustEngineListenerField = TrustEngine.class.getDeclaredField("trustEngineListener");
                    trustEngineListenerField.setAccessible(true);
                    trustEngineListenerField.set(engine, SignedBundleHook.this.trustEngineListener);
                }
                catch (Exception e) {
                    SignedBundleHook.this.log("Unable to set the trust engine listener.", 4, e);
                }
            }
            return engine;
        }

        @Override
        public void modifiedService(ServiceReference<TrustEngine> reference, TrustEngine service) {
        }

        @Override
        public void removedService(ServiceReference<TrustEngine> reference, TrustEngine service) {
        }
    }
}

