/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.container;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

public class LockSet<T> {
    private final Map<T, LockHolder> locks = new HashMap<T, LockHolder>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryLock(T t2, long time, TimeUnit unit) throws InterruptedException {
        boolean previousInterruption = Thread.interrupted();
        try {
            boolean bl;
            block20: {
                Map<T, LockHolder> map;
                LockHolder lock;
                Map<T, LockHolder> map2 = this.locks;
                synchronized (map2) {
                    lock = this.locks.get(t2);
                    if (lock == null) {
                        lock = new LockHolder();
                        this.locks.put(t2, lock);
                    }
                    lock.incrementUseCount();
                }
                boolean acquired = false;
                try {
                    bl = acquired = lock.tryLock(time, unit);
                    if (acquired) break block20;
                    map = this.locks;
                }
                catch (Throwable throwable) {
                    if (!acquired) {
                        Map<T, LockHolder> map3 = this.locks;
                        synchronized (map3) {
                            if (lock.decremementUseCount() == 0) {
                                this.locks.remove(t2);
                            }
                        }
                    }
                    throw throwable;
                }
                synchronized (map) {
                    if (lock.decremementUseCount() == 0) {
                        this.locks.remove(t2);
                    }
                }
            }
            return bl;
        }
        finally {
            if (previousInterruption) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(T t2) {
        Map<T, LockHolder> map = this.locks;
        synchronized (map) {
            LockHolder lock = this.locks.get(t2);
            if (lock == null) {
                throw new IllegalStateException("No lock found: " + t2);
            }
            lock.unlock();
            if (lock.decremementUseCount() == 0) {
                this.locks.remove(t2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLockInfo(T t2) {
        Map<T, LockHolder> map = this.locks;
        synchronized (map) {
            return String.valueOf(this.locks.get(t2));
        }
    }

    static final class LockHolder {
        private final AtomicInteger useCount = new AtomicInteger(0);
        private final ReentrantLock lock = new ReentrantLock();

        LockHolder() {
        }

        int incrementUseCount() {
            return this.useCount.incrementAndGet();
        }

        int decremementUseCount() {
            return this.useCount.decrementAndGet();
        }

        boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            return !this.lock.isHeldByCurrentThread() && this.lock.tryLock(time, unit);
        }

        void unlock() {
            this.lock.unlock();
        }

        public String toString() {
            return this.lock.toString();
        }
    }
}

