/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.util;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.osgi.internal.messages.Msg;
import org.eclipse.osgi.util.NLS;

public class CaseInsensitiveDictionaryMap<K, V>
extends Dictionary<K, V>
implements Map<K, V> {
    private static final CaseInsensitiveKey KEY_SERVICE_OBJECTCLASS = new CaseInsensitiveKey("objectClass");
    private static final CaseInsensitiveKey KEY_SERVICE_BUNDLE_ID = new CaseInsensitiveKey("service.bundleid");
    private static final CaseInsensitiveKey KEY_SERVICE_CHANGECOUNT = new CaseInsensitiveKey("service.changecount");
    private static final CaseInsensitiveKey KEY_SERVICE_DESCRIPTION = new CaseInsensitiveKey("service.description");
    private static final CaseInsensitiveKey KEY_SERVICE_ID = new CaseInsensitiveKey("service.id");
    private static final CaseInsensitiveKey KEY_SERVICE_PID = new CaseInsensitiveKey("service.pid");
    private static final CaseInsensitiveKey KEY_SERVICE_RANKING = new CaseInsensitiveKey("service.ranking");
    private static final CaseInsensitiveKey KEY_SERVICE_SCOPE = new CaseInsensitiveKey("service.scope");
    private static final CaseInsensitiveKey KEY_SERVICE_VENDER = new CaseInsensitiveKey("service.vendor");
    private static final CaseInsensitiveKey KEY_COMPONENT_NAME = new CaseInsensitiveKey("component.name");
    private static final CaseInsensitiveKey KEY_COMPONENT_ID = new CaseInsensitiveKey("component.id");
    private static final CaseInsensitiveKey KEY_METATYPE_PID = new CaseInsensitiveKey("metatype.pid");
    private static final CaseInsensitiveKey KEY_METATYPE_FACTORY_PID = new CaseInsensitiveKey("metatype.factory.pid");
    private static final CaseInsensitiveKey KEY_EVENT_TOPICS = new CaseInsensitiveKey("event.topics");
    private static final CaseInsensitiveKey KEY_EVENT_FILTER = new CaseInsensitiveKey("event.filter");
    private static final CaseInsensitiveKey KEY_JMX_OBJECTNAME = new CaseInsensitiveKey("jmx.objectname");
    private static final CaseInsensitiveKey KEY_JAR_MANIFESTVERSION = new CaseInsensitiveKey("Manifest-Version");
    private static final CaseInsensitiveKey KEY_BUNDLE_ACTIVATIONPOLICY = new CaseInsensitiveKey("Bundle-ActivationPolicy");
    private static final CaseInsensitiveKey KEY_BUNDLE_ACTIVATOR = new CaseInsensitiveKey("Bundle-Activator");
    private static final CaseInsensitiveKey KEY_BUNDLE_CLASSPATH = new CaseInsensitiveKey("Bundle-ClassPath");
    private static final CaseInsensitiveKey KEY_BUNDLE_DESCRIPTION = new CaseInsensitiveKey("Bundle-Description");
    private static final CaseInsensitiveKey KEY_BUNDLE_LICENSE = new CaseInsensitiveKey("Bundle-License");
    private static final CaseInsensitiveKey KEY_BUNDLE_LOCALIZATION = new CaseInsensitiveKey("Bundle-Localization");
    private static final CaseInsensitiveKey KEY_BUNDLE_MANIFESTVERSION = new CaseInsensitiveKey("Bundle-ManifestVersion");
    private static final CaseInsensitiveKey KEY_BUNDLE_NAME = new CaseInsensitiveKey("Bundle-Name");
    private static final CaseInsensitiveKey KEY_BUNDLE_NATIVECODE = new CaseInsensitiveKey("Bundle-NativeCode");
    private static final CaseInsensitiveKey KEY_BUNDLE_REQUIREDEXECUTIONENVIRONMENT = new CaseInsensitiveKey("Bundle-RequiredExecutionEnvironment");
    private static final CaseInsensitiveKey KEY_BUNDLE_SCM = new CaseInsensitiveKey("Bundle-SCM");
    private static final CaseInsensitiveKey KEY_BUNDLE_SYMBOLICNAME = new CaseInsensitiveKey("Bundle-SymbolicName");
    private static final CaseInsensitiveKey KEY_BUNDLE_VENDOR = new CaseInsensitiveKey("Bundle-Vendor");
    private static final CaseInsensitiveKey KEY_BUNDLE_VERSION = new CaseInsensitiveKey("Bundle-Version");
    private static final CaseInsensitiveKey KEY_BUNDLE_DYNAMICIMPORT_PACKAGE = new CaseInsensitiveKey("DynamicImport-Package");
    private static final CaseInsensitiveKey KEY_BUNDLE_EXPORT_PACKAGE = new CaseInsensitiveKey("Export-Package");
    private static final CaseInsensitiveKey KEY_BUNDLE_FRAGMENT_HOST = new CaseInsensitiveKey("Fragment-Host");
    private static final CaseInsensitiveKey KEY_BUNDLE_IMPORT_PACKAGE = new CaseInsensitiveKey("Import-Package");
    private static final CaseInsensitiveKey KEY_BUNDLE_REQUIRE_BUNDLE = new CaseInsensitiveKey("Require-Bundle");
    private static final CaseInsensitiveKey KEY_BUNDLE_REQUIRE_CAPABILITY = new CaseInsensitiveKey("Require-Capability");
    private static final CaseInsensitiveKey KEY_BUNDLE_PROVIDE_CAPABILITY = new CaseInsensitiveKey("Provide-Capability");
    final Map<Object, V> map;
    private transient Set<Map.Entry<K, V>> entrySet = null;
    private transient Set<K> keySet = null;

    public static CaseInsensitiveKey findCommonKeyIndex(String key) {
        switch (key) {
            case "objectClass": {
                return KEY_SERVICE_OBJECTCLASS;
            }
            case "service.bundleid": {
                return KEY_SERVICE_BUNDLE_ID;
            }
            case "service.changecount": {
                return KEY_SERVICE_CHANGECOUNT;
            }
            case "service.description": {
                return KEY_SERVICE_DESCRIPTION;
            }
            case "service.id": {
                return KEY_SERVICE_ID;
            }
            case "service.pid": {
                return KEY_SERVICE_PID;
            }
            case "service.ranking": {
                return KEY_SERVICE_RANKING;
            }
            case "service.scope": {
                return KEY_SERVICE_SCOPE;
            }
            case "service.vendor": {
                return KEY_SERVICE_VENDER;
            }
            case "component.name": {
                return KEY_COMPONENT_NAME;
            }
            case "component.id": {
                return KEY_COMPONENT_ID;
            }
            case "metatype.pid": {
                return KEY_METATYPE_PID;
            }
            case "metatype.factory.pid": {
                return KEY_METATYPE_FACTORY_PID;
            }
            case "event.topics": {
                return KEY_EVENT_TOPICS;
            }
            case "event.filter": {
                return KEY_EVENT_FILTER;
            }
            case "jmx.objectname": {
                return KEY_JMX_OBJECTNAME;
            }
            case "Manifest-Version": {
                return KEY_JAR_MANIFESTVERSION;
            }
            case "Bundle-ActivationPolicy": {
                return KEY_BUNDLE_ACTIVATIONPOLICY;
            }
            case "Bundle-Activator": {
                return KEY_BUNDLE_ACTIVATOR;
            }
            case "Bundle-ClassPath": {
                return KEY_BUNDLE_CLASSPATH;
            }
            case "Bundle-Description": {
                return KEY_BUNDLE_DESCRIPTION;
            }
            case "Bundle-License": {
                return KEY_BUNDLE_LICENSE;
            }
            case "Bundle-Localization": {
                return KEY_BUNDLE_LOCALIZATION;
            }
            case "Bundle-ManifestVersion": {
                return KEY_BUNDLE_MANIFESTVERSION;
            }
            case "Bundle-Name": {
                return KEY_BUNDLE_NAME;
            }
            case "Bundle-NativeCode": {
                return KEY_BUNDLE_NATIVECODE;
            }
            case "Bundle-RequiredExecutionEnvironment": {
                return KEY_BUNDLE_REQUIREDEXECUTIONENVIRONMENT;
            }
            case "Bundle-SCM": {
                return KEY_BUNDLE_SCM;
            }
            case "Bundle-SymbolicName": {
                return KEY_BUNDLE_SYMBOLICNAME;
            }
            case "Bundle-Vendor": {
                return KEY_BUNDLE_VENDOR;
            }
            case "Bundle-Version": {
                return KEY_BUNDLE_VERSION;
            }
            case "DynamicImport-Package": {
                return KEY_BUNDLE_DYNAMICIMPORT_PACKAGE;
            }
            case "Export-Package": {
                return KEY_BUNDLE_EXPORT_PACKAGE;
            }
            case "Fragment-Host": {
                return KEY_BUNDLE_FRAGMENT_HOST;
            }
            case "Import-Package": {
                return KEY_BUNDLE_IMPORT_PACKAGE;
            }
            case "Require-Bundle": {
                return KEY_BUNDLE_REQUIRE_BUNDLE;
            }
            case "Require-Capability": {
                return KEY_BUNDLE_REQUIRE_CAPABILITY;
            }
            case "Provide-Capability": {
                return KEY_BUNDLE_PROVIDE_CAPABILITY;
            }
        }
        return null;
    }

    public CaseInsensitiveDictionaryMap() {
        this.map = new HashMap<Object, V>();
    }

    public CaseInsensitiveDictionaryMap(int initialCapacity) {
        this.map = new HashMap<Object, V>(initialCapacity);
    }

    public CaseInsensitiveDictionaryMap(Dictionary<? extends K, ? extends V> dictionary) {
        this(CaseInsensitiveDictionaryMap.initialCapacity(dictionary.size()));
        Enumeration<K> keys = dictionary.keys();
        while (keys.hasMoreElements()) {
            V value;
            K key = keys.nextElement();
            if (key == null || (value = dictionary.get(key)) == null || this.put(key, value) == null) continue;
            throw new IllegalArgumentException(NLS.bind(Msg.HEADER_DUPLICATE_KEY_EXCEPTION, key));
        }
    }

    public CaseInsensitiveDictionaryMap(Map<? extends K, ? extends V> map) {
        this(CaseInsensitiveDictionaryMap.initialCapacity(map.size()));
        for (Map.Entry<K, V> e : map.entrySet()) {
            V value;
            K key = e.getKey();
            if (key == null || (value = e.getValue()) == null || this.put(key, value) == null) continue;
            throw new IllegalArgumentException(NLS.bind(Msg.HEADER_DUPLICATE_KEY_EXCEPTION, key));
        }
    }

    protected static int initialCapacity(int size) {
        return Math.max((int)((float)size / 0.75f) + 1, 16);
    }

    @Override
    public Enumeration<K> keys() {
        return Collections.enumeration(this.keySet());
    }

    @Override
    public Enumeration<V> elements() {
        return Collections.enumeration(this.values());
    }

    @Override
    public V get(Object key) {
        return this.map.get(this.keyWrap(key));
    }

    private Object keyWrap(Object key) {
        if (key instanceof String) {
            CaseInsensitiveKey commonKey = CaseInsensitiveDictionaryMap.findCommonKeyIndex((String)key);
            if (commonKey != null) {
                return commonKey;
            }
            return new CaseInsensitiveKey((String)key);
        }
        return key;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public V put(K key, V value) {
        Objects.requireNonNull(value);
        if (key instanceof String) {
            Object wrappedKey = this.keyWrap(key);
            V existing = this.map.put(wrappedKey, value);
            if (existing != null) {
                this.map.remove(wrappedKey);
                this.map.put(wrappedKey, value);
            }
            return existing;
        }
        return this.map.put(Objects.requireNonNull(key), value);
    }

    @Override
    public V remove(Object key) {
        return this.map.remove(this.keyWrap(key));
    }

    public String toString() {
        return this.map.toString();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(this.keyWrap(key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> es = this.entrySet;
        if (es == null) {
            this.entrySet = new EntrySet();
            return this.entrySet;
        }
        return es;
    }

    @Override
    public Set<K> keySet() {
        Set<K> ks = this.keySet;
        if (ks == null) {
            this.keySet = new KeySet();
            return this.keySet;
        }
        return ks;
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m4) {
        for (Map.Entry<K, V> e : m4.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return this.map.equals(obj);
    }

    public Map<K, V> asUnmodifiableMap() {
        return Collections.unmodifiableMap(this);
    }

    public Dictionary<K, V> asUnmodifiableDictionary() {
        return CaseInsensitiveDictionaryMap.unmodifiableDictionary(this);
    }

    public static <K, V> Dictionary<K, V> unmodifiableDictionary(Dictionary<? extends K, ? extends V> d) {
        return new UnmodifiableDictionary<K, V>(d);
    }

    static int computeHashCode(String key) {
        int h2 = 1;
        char[] cArray = key.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c < '\u0080') {
                if (c >= 'A' && c <= 'Z') {
                    c = (char)(c + 32);
                }
            } else {
                c = Character.toLowerCase(Character.toUpperCase(c));
            }
            h2 = 31 * h2 + c;
            ++n2;
        }
        return h2;
    }

    private static final class CaseInsensitiveKey {
        final String key;
        private final int hashCode;

        CaseInsensitiveKey(String key) {
            this.key = key;
            this.hashCode = CaseInsensitiveDictionaryMap.computeHashCode(key);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof CaseInsensitiveKey) {
                return this.key.equalsIgnoreCase(((CaseInsensitiveKey)obj).key);
            }
            return false;
        }

        public String toString() {
            return this.key;
        }
    }

    private static final class CaseInsentiveEntry<K, V>
    implements Map.Entry<K, V> {
        private final Map.Entry<Object, V> entry;

        CaseInsentiveEntry(Map.Entry<Object, V> entry) {
            this.entry = entry;
        }

        @Override
        public K getKey() {
            Object k = this.entry.getKey();
            if (k instanceof CaseInsensitiveKey) {
                k = ((CaseInsensitiveKey)k).key;
            }
            return (K)k;
        }

        @Override
        public V getValue() {
            return this.entry.getValue();
        }

        @Override
        public V setValue(V value) {
            return this.entry.setValue(Objects.requireNonNull(value));
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.entry.getKey()) ^ Objects.hashCode(this.entry.getValue());
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof Map.Entry) {
                Object k2;
                Map.Entry other = (Map.Entry)obj;
                Object k1 = this.entry.getKey();
                Object object = k2 = other instanceof CaseInsentiveEntry ? ((CaseInsentiveEntry)other).entry.getKey() : other.getKey();
                return Objects.equals(k1, k2) && Objects.equals(this.entry.getValue(), other.getValue());
            }
            return false;
        }

        public String toString() {
            return this.entry.toString();
        }
    }

    private static final class EntryIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<Map.Entry<Object, V>> i;

        EntryIterator(Collection<Map.Entry<Object, V>> c) {
            this.i = c.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            return new CaseInsentiveEntry(this.i.next());
        }

        @Override
        public void remove() {
            this.i.remove();
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public int size() {
            return CaseInsensitiveDictionaryMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return CaseInsensitiveDictionaryMap.this.isEmpty();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator(CaseInsensitiveDictionaryMap.this.map.entrySet());
        }

        @Override
        public void clear() {
            CaseInsensitiveDictionaryMap.this.clear();
        }
    }

    private static final class KeyIterator<K>
    implements Iterator<K> {
        private final Iterator<Object> i;

        KeyIterator(Collection<Object> c) {
            this.i = c.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public K next() {
            Object k = this.i.next();
            if (k instanceof CaseInsensitiveKey) {
                k = ((CaseInsensitiveKey)k).key;
            }
            return (K)k;
        }

        @Override
        public void remove() {
            this.i.remove();
        }
    }

    private final class KeySet
    extends AbstractSet<K> {
        KeySet() {
        }

        @Override
        public int size() {
            return CaseInsensitiveDictionaryMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return CaseInsensitiveDictionaryMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return CaseInsensitiveDictionaryMap.this.containsKey(o);
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator(CaseInsensitiveDictionaryMap.this.map.keySet());
        }

        @Override
        public boolean remove(Object o) {
            return CaseInsensitiveDictionaryMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            CaseInsensitiveDictionaryMap.this.clear();
        }
    }

    private static final class UnmodifiableDictionary<K, V>
    extends Dictionary<K, V> {
        private final Dictionary<? extends K, ? extends V> d;

        UnmodifiableDictionary(Dictionary<? extends K, ? extends V> d) {
            this.d = Objects.requireNonNull(d);
        }

        @Override
        public int size() {
            return this.d.size();
        }

        @Override
        public boolean isEmpty() {
            return this.d.isEmpty();
        }

        @Override
        public Enumeration<K> keys() {
            return this.d.keys();
        }

        @Override
        public Enumeration<V> elements() {
            return this.d.elements();
        }

        @Override
        public V get(Object key) {
            return this.d.get(key);
        }

        @Override
        public V put(K key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V remove(Object key) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.d.toString();
        }

        public int hashCode() {
            return this.d.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            return this.d.equals(obj);
        }
    }
}

