/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.container;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.osgi.container.Module;
import org.eclipse.osgi.container.ModuleContainer;
import org.eclipse.osgi.container.ModuleRevision;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleRevisions;

public final class ModuleRevisions
implements BundleRevisions {
    private final Object monitor = new Object();
    private final Module module;
    private final ModuleContainer container;
    private final List<ModuleRevision> revisions = new ArrayList<ModuleRevision>(1);
    private boolean uninstalled = false;
    private ModuleRevision uninstalledCurrent;

    ModuleRevisions(Module module, ModuleContainer container2) {
        this.module = module;
        this.container = container2;
    }

    public Module getModule() {
        return this.module;
    }

    ModuleContainer getContainer() {
        return this.container;
    }

    @Override
    public Bundle getBundle() {
        return this.module.getBundle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BundleRevision> getRevisions() {
        Object object = this.monitor;
        synchronized (object) {
            return new ArrayList<BundleRevision>(this.revisions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ModuleRevision> getModuleRevisions() {
        Object object = this.monitor;
        synchronized (object) {
            return new ArrayList<ModuleRevision>(this.revisions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ModuleRevision getCurrentRevision() {
        Object object = this.monitor;
        synchronized (object) {
            block5: {
                if (this.uninstalled) {
                    return this.uninstalledCurrent;
                }
                if (!this.revisions.isEmpty()) break block5;
                return null;
            }
            return this.revisions.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ModuleRevision addRevision(ModuleRevision revision) {
        Object object = this.monitor;
        synchronized (object) {
            this.revisions.add(0, revision);
        }
        return revision;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeRevision(ModuleRevision revision) {
        try {
            Object object = this.monitor;
            synchronized (object) {
                boolean bl = this.revisions.remove(revision);
                return bl;
            }
        }
        finally {
            this.module.cleanup(revision);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isUninstalled() {
        Object object = this.monitor;
        synchronized (object) {
            return this.uninstalled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void uninstall() {
        Object object = this.monitor;
        synchronized (object) {
            this.uninstalled = true;
            if (this.revisions.isEmpty()) {
                throw new IllegalStateException("Revisions is empty on uninstall! " + this.module);
            }
            this.uninstalledCurrent = this.revisions.get(0);
        }
    }

    public String toString() {
        return "moduleID=" + this.module.getId();
    }
}

