/*
 * Decompiled with CFR 0.152.
 */
package inference.example;

import boomerang.WeightedForwardQuery;
import boomerang.debugger.Debugger;
import boomerang.jimple.Statement;
import boomerang.jimple.Val;
import boomerang.preanalysis.BoomerangPretransformer;
import com.google.common.base.Joiner;
import com.google.common.collect.Table;
import ideal.IDEALAnalysis;
import ideal.IDEALAnalysisDefinition;
import ideal.IDEALResultHandler;
import ideal.IDEALSeedSolver;
import ideal.StoreIDEALResultHandler;
import inference.InferenceWeight;
import inference.InferenceWeightFunctions;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.G;
import soot.PackManager;
import soot.Scene;
import soot.SceneTransformer;
import soot.SootClass;
import soot.SootMethod;
import soot.Transform;
import soot.Transformer;
import soot.Unit;
import soot.jimple.AssignStmt;
import soot.jimple.NewExpr;
import soot.options.Options;
import sync.pds.solver.WeightFunctions;

public class Main {
    private static final Logger logger = LoggerFactory.getLogger(Main.class);

    public static void main(String ... args) {
        String sootClassPath = System.getProperty("user.dir") + File.separator + "target" + File.separator + "classes";
        String mainClass = "inference.example.InferenceExample";
        Main.setupSoot(sootClassPath, mainClass);
        Main.analyze();
    }

    private static void setupSoot(String sootClassPath, String mainClass) {
        G.v();
        G.reset();
        Options.v().set_whole_program(true);
        Options.v().setPhaseOption("cg.spark", "on");
        Options.v().set_output_format(12);
        Options.v().set_no_bodies_for_excluded(true);
        Options.v().set_allow_phantom_refs(true);
        LinkedList<String> includeList = new LinkedList<String>();
        includeList.add("java.lang.*");
        includeList.add("java.util.*");
        includeList.add("java.io.*");
        includeList.add("sun.misc.*");
        includeList.add("java.net.*");
        includeList.add("javax.servlet.*");
        includeList.add("javax.crypto.*");
        Options.v().set_include(includeList);
        Options.v().setPhaseOption("jb", "use-original-names:true");
        Options.v().set_soot_classpath(sootClassPath);
        Options.v().set_prepend_classpath(true);
        Scene.v().loadNecessaryClasses();
        SootClass c = Scene.v().forceResolve(mainClass, 3);
        if (c != null) {
            c.setApplicationClass();
            for (SootMethod m4 : c.getMethods()) {
                logger.debug(m4.toString());
            }
        }
    }

    private static void analyze() {
        Transform transform = new Transform("wjtp.ifds", Main.createAnalysisTransformer());
        PackManager.v().getPack("wjtp").add(transform);
        PackManager.v().getPack("cg").apply();
        BoomerangPretransformer.v().apply();
        PackManager.v().getPack("wjtp").apply();
    }

    private static Transformer createAnalysisTransformer() {
        return new SceneTransformer(){

            protected void internalTransform(String phaseName, Map options) {
                final StoreIDEALResultHandler resultHandler = new StoreIDEALResultHandler();
                IDEALAnalysis<InferenceWeight> solver = new IDEALAnalysis<InferenceWeight>(new IDEALAnalysisDefinition<InferenceWeight>(){

                    @Override
                    public Collection<WeightedForwardQuery<InferenceWeight>> generate(SootMethod method, Unit stmt) {
                        AssignStmt as;
                        if (stmt instanceof AssignStmt && (as = (AssignStmt)stmt).getRightOp() instanceof NewExpr && as.getRightOp().getType().toString().contains("inference.example.InferenceExample$File")) {
                            return Collections.singleton(new WeightedForwardQuery<InferenceWeight>(new Statement(as, method), new Val(as.getLeftOp(), method), InferenceWeight.one()));
                        }
                        return Collections.emptySet();
                    }

                    @Override
                    public WeightFunctions<Statement, Val, Statement, InferenceWeight> weightFunctions() {
                        return new InferenceWeightFunctions();
                    }

                    @Override
                    public Debugger<InferenceWeight> debugger(IDEALSeedSolver<InferenceWeight> solver) {
                        return new Debugger<InferenceWeight>();
                    }

                    @Override
                    public IDEALResultHandler<InferenceWeight> getResultHandler() {
                        return resultHandler;
                    }
                });
                solver.run();
                Map res = resultHandler.getResults();
                for (Map.Entry e : res.entrySet()) {
                    Table results = e.getValue().asStatementValWeightTable();
                    logger.info(Joiner.on("\n").join(results.cellSet()));
                }
            }
        };
    }
}

