/*
 * Decompiled with CFR 0.152.
 */
package ideal;

import boomerang.jimple.Statement;
import boomerang.jimple.Val;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import ideal.IDEALSeedSolver;
import ideal.NonOneFlowListener;
import java.util.Collection;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sync.pds.solver.WeightFunctions;
import sync.pds.solver.nodes.Node;
import sync.pds.solver.nodes.PushNode;
import wpds.impl.Weight;

public class IDEALWeightFunctions<W extends Weight>
implements WeightFunctions<Statement, Val, Statement, W> {
    private static final Logger logger = LoggerFactory.getLogger(IDEALWeightFunctions.class);
    private WeightFunctions<Statement, Val, Statement, W> delegate;
    private Set<NonOneFlowListener> listeners = Sets.newHashSet();
    private Set<Statement> potentialStrongUpdates = Sets.newHashSet();
    private Set<Statement> weakUpdates = Sets.newHashSet();
    private Set<Node<Statement, Val>> nonOneFlowNodes = Sets.newHashSet();
    private IDEALSeedSolver.Phases phase;
    private boolean strongUpdates;
    private Multimap<Node<Statement, Val>, Node<Statement, Val>> indirectAlias = HashMultimap.create();
    private Set<Node<Statement, Val>> nodesWithStrongUpdate = Sets.newHashSet();

    public IDEALWeightFunctions(WeightFunctions<Statement, Val, Statement, W> delegate, boolean strongUpdates) {
        this.delegate = delegate;
        this.strongUpdates = strongUpdates;
    }

    @Override
    public W push(Node<Statement, Val> curr, Node<Statement, Val> succ, Statement calleeSp) {
        W weight = this.delegate.push(curr, succ, calleeSp);
        if (this.isObjectFlowPhase() && !weight.equals(this.getOne()) && succ instanceof PushNode) {
            PushNode pushNode = (PushNode)succ;
            this.addOtherThanOneWeight(new Node<Statement, Val>((Statement)pushNode.location(), curr.fact()));
        }
        return weight;
    }

    void addOtherThanOneWeight(Node<Statement, Val> curr) {
        if (this.nonOneFlowNodes.add(curr)) {
            for (NonOneFlowListener l : Lists.newArrayList(this.listeners)) {
                l.nonOneFlow(curr);
            }
        }
    }

    @Override
    public W normal(Node<Statement, Val> curr, Node<Statement, Val> succ) {
        W weight = this.delegate.normal(curr, succ);
        if (this.isObjectFlowPhase() && succ.stmt().isCallsite() && !weight.equals(this.getOne())) {
            this.addOtherThanOneWeight(succ);
        }
        return weight;
    }

    private boolean isObjectFlowPhase() {
        return this.phase.equals((Object)IDEALSeedSolver.Phases.ObjectFlow);
    }

    private boolean isValueFlowPhase() {
        return this.phase.equals((Object)IDEALSeedSolver.Phases.ValueFlow);
    }

    @Override
    public W pop(Node<Statement, Val> curr, Statement location) {
        return this.delegate.pop(curr, location);
    }

    public void registerListener(NonOneFlowListener listener) {
        if (this.listeners.add(listener)) {
            for (Node<Statement, Val> existing : Lists.newArrayList(this.nonOneFlowNodes)) {
                listener.nonOneFlow(existing);
            }
        }
    }

    @Override
    public W getOne() {
        return this.delegate.getOne();
    }

    @Override
    public W getZero() {
        return this.delegate.getZero();
    }

    public String toString() {
        return "[IDEAL-Wrapped Weights] " + this.delegate.toString();
    }

    public void potentialStrongUpdate(Statement stmt) {
        this.potentialStrongUpdates.add(stmt);
    }

    public void weakUpdate(Statement stmt) {
        this.weakUpdates.add(stmt);
    }

    public void setPhase(IDEALSeedSolver.Phases phase) {
        this.phase = phase;
    }

    public void addIndirectFlow(Node<Statement, Val> source, Node<Statement, Val> target) {
        if (source.equals(target)) {
            return;
        }
        logger.trace("Alias flow detected " + source + " " + target);
        this.indirectAlias.put(source, target);
    }

    public Collection<Node<Statement, Val>> getAliasesFor(Node<Statement, Val> node) {
        return this.indirectAlias.get(node);
    }

    public boolean isStrongUpdateStatement(Statement stmt) {
        return this.potentialStrongUpdates.contains(stmt) && !this.weakUpdates.contains(stmt) && this.strongUpdates;
    }

    public boolean isKillFlow(Node<Statement, Val> node) {
        return !this.nodesWithStrongUpdate.contains(node);
    }

    public void addNonKillFlow(Node<Statement, Val> curr) {
        this.nodesWithStrongUpdate.add(curr);
    }
}

