/*
 * Decompiled with CFR 0.152.
 */
package heros.flowfunc;

import com.google.common.collect.Sets;
import heros.FlowFunction;
import heros.flowfunc.Identity;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class Union<D>
implements FlowFunction<D> {
    private final FlowFunction<D>[] funcs;

    private Union(FlowFunction<D> ... funcs) {
        this.funcs = funcs;
    }

    @Override
    public Set<D> computeTargets(D source) {
        HashSet<D> res = Sets.newHashSet();
        for (FlowFunction<D> func : this.funcs) {
            res.addAll(func.computeTargets(source));
        }
        return res;
    }

    public static <D> FlowFunction<D> union(FlowFunction<D> ... funcs) {
        ArrayList<FlowFunction<D>> list = new ArrayList<FlowFunction<D>>();
        for (FlowFunction<D> f : funcs) {
            if (f == Identity.v()) continue;
            list.add(f);
        }
        if (list.size() == 1) {
            return (FlowFunction)list.get(0);
        }
        if (list.isEmpty()) {
            return Identity.v();
        }
        return new Union<D>(list.toArray(new FlowFunction[list.size()]));
    }
}

