/*
 * Decompiled with CFR 0.152.
 */
package heros.fieldsens;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class AccessPath<T> {
    private final T[] accesses;
    private final Set<T> exclusions;

    public static <T> AccessPath<T> empty() {
        return new AccessPath<T>();
    }

    public AccessPath() {
        this.accesses = new Object[0];
        this.exclusions = Sets.newHashSet();
    }

    AccessPath(T[] accesses, Set<T> exclusions) {
        this.accesses = accesses;
        this.exclusions = exclusions;
    }

    public boolean isAccessInExclusions(T fieldReference) {
        return this.exclusions.contains(fieldReference);
    }

    public boolean hasAllExclusionsOf(AccessPath<T> accPath) {
        return this.exclusions.containsAll(accPath.exclusions);
    }

    public AccessPath<T> append(T ... fieldReferences) {
        if (fieldReferences.length == 0) {
            return this;
        }
        if (this.isAccessInExclusions(fieldReferences[0])) {
            throw new IllegalArgumentException("FieldRef " + Arrays.toString(fieldReferences) + " cannot be added to " + this.toString());
        }
        T[] newAccesses = Arrays.copyOf(this.accesses, this.accesses.length + fieldReferences.length);
        System.arraycopy(fieldReferences, 0, newAccesses, this.accesses.length, fieldReferences.length);
        return new AccessPath<T>(newAccesses, Sets.newHashSet());
    }

    public AccessPath<T> prepend(T fieldRef) {
        Object[] newAccesses = new Object[this.accesses.length + 1];
        newAccesses[0] = fieldRef;
        System.arraycopy(this.accesses, 0, newAccesses, 1, this.accesses.length);
        return new AccessPath<Object>(newAccesses, this.exclusions);
    }

    public AccessPath<T> removeFirst() {
        Object[] newAccesses = new Object[this.accesses.length - 1];
        System.arraycopy(this.accesses, 1, newAccesses, 0, this.accesses.length - 1);
        return new AccessPath<Object>(newAccesses, this.exclusions);
    }

    public AccessPath<T> appendExcludedFieldReference(Collection<T> fieldReferences) {
        HashSet<T> newExclusions = Sets.newHashSet(fieldReferences);
        newExclusions.addAll(this.exclusions);
        return new AccessPath<T>(this.accesses, newExclusions);
    }

    public AccessPath<T> appendExcludedFieldReference(T ... fieldReferences) {
        HashSet<T> newExclusions = Sets.newHashSet(fieldReferences);
        newExclusions.addAll(this.exclusions);
        return new AccessPath<T>(this.accesses, newExclusions);
    }

    public PrefixTestResult isPrefixOf(AccessPath<T> accessPath) {
        boolean potentialMatch;
        if (this.accesses.length > accessPath.accesses.length) {
            return PrefixTestResult.NO_PREFIX;
        }
        for (int i = 0; i < this.accesses.length; ++i) {
            if (this.accesses[i].equals(accessPath.accesses[i])) continue;
            return PrefixTestResult.NO_PREFIX;
        }
        if (this.accesses.length < accessPath.accesses.length) {
            if (this.exclusions.contains(accessPath.accesses[this.accesses.length])) {
                return PrefixTestResult.NO_PREFIX;
            }
            return PrefixTestResult.GUARANTEED_PREFIX;
        }
        if (this.exclusions.isEmpty()) {
            return PrefixTestResult.GUARANTEED_PREFIX;
        }
        if (accessPath.exclusions.isEmpty()) {
            return PrefixTestResult.NO_PREFIX;
        }
        boolean intersection = !Sets.intersection(this.exclusions, accessPath.exclusions).isEmpty();
        boolean containsAll = this.exclusions.containsAll(accessPath.exclusions);
        boolean oppositeContainsAll = accessPath.exclusions.containsAll(this.exclusions);
        boolean bl = potentialMatch = oppositeContainsAll || !intersection || !containsAll && !oppositeContainsAll;
        if (potentialMatch) {
            if (oppositeContainsAll) {
                return PrefixTestResult.GUARANTEED_PREFIX;
            }
            return PrefixTestResult.POTENTIAL_PREFIX;
        }
        return PrefixTestResult.NO_PREFIX;
    }

    public Delta<T> getDeltaTo(AccessPath<T> accPath) {
        assert (this.isPrefixOf(accPath).atLeast(PrefixTestResult.POTENTIAL_PREFIX));
        HashSet<T> mergedExclusions = Sets.newHashSet(accPath.exclusions);
        if (this.accesses.length == accPath.accesses.length) {
            mergedExclusions.addAll(this.exclusions);
        }
        Delta<T> delta = new Delta<T>(Arrays.copyOfRange(accPath.accesses, this.accesses.length, accPath.accesses.length), mergedExclusions);
        assert (this.isPrefixOf(accPath).atLeast(PrefixTestResult.POTENTIAL_PREFIX) && accPath.isPrefixOf(delta.applyTo(this)) == PrefixTestResult.GUARANTEED_PREFIX || this.isPrefixOf(accPath) == PrefixTestResult.GUARANTEED_PREFIX && accPath.equals(delta.applyTo(this)));
        return delta;
    }

    public AccessPath<T> mergeExcludedFieldReferences(AccessPath<T> accPath) {
        HashSet<T> newExclusions = Sets.newHashSet(this.exclusions);
        newExclusions.addAll(accPath.exclusions);
        return new AccessPath<T>(this.accesses, newExclusions);
    }

    public boolean canRead(T field) {
        return this.accesses.length > 0 && this.accesses[0].equals(field);
    }

    public boolean isEmpty() {
        return this.exclusions.isEmpty() && this.accesses.length == 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.accesses);
        result = 31 * result + (this.exclusions == null ? 0 : this.exclusions.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccessPath other = (AccessPath)obj;
        if (!Arrays.equals(this.accesses, other.accesses)) {
            return false;
        }
        return !(this.exclusions == null ? other.exclusions != null : !this.exclusions.equals(other.exclusions));
    }

    public String toString() {
        String result;
        String string = result = this.accesses.length > 0 ? "." + Joiner.on(".").join(this.accesses) : "";
        if (!this.exclusions.isEmpty()) {
            result = result + "^" + Joiner.on(",").join(this.exclusions);
        }
        return result;
    }

    public AccessPath<T> removeAnyAccess() {
        if (this.accesses.length > 0) {
            return new AccessPath<Object>(new Object[0], this.exclusions);
        }
        return this;
    }

    public boolean hasEmptyAccessPath() {
        return this.accesses.length == 0;
    }

    public T getFirstAccess() {
        return this.accesses[0];
    }

    Set<T> getExclusions() {
        return this.exclusions;
    }

    public static class Delta<T> {
        final T[] accesses;
        final Set<T> exclusions;

        protected Delta(T[] accesses, Set<T> exclusions) {
            this.accesses = accesses;
            this.exclusions = exclusions;
        }

        public boolean canBeAppliedTo(AccessPath<T> accPath) {
            if (this.accesses.length > 0) {
                return !accPath.isAccessInExclusions(this.accesses[0]);
            }
            return true;
        }

        public AccessPath<T> applyTo(AccessPath<T> accPath) {
            return accPath.append(this.accesses).appendExcludedFieldReference((Collection<T>)this.exclusions);
        }

        public String toString() {
            String result;
            String string = result = this.accesses.length > 0 ? "." + Joiner.on(".").join(this.accesses) : "";
            if (!this.exclusions.isEmpty()) {
                result = result + "^" + Joiner.on(",").join(this.exclusions);
            }
            return result;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.accesses);
            result = 31 * result + (this.exclusions == null ? 0 : this.exclusions.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Delta other = (Delta)obj;
            if (!Arrays.equals(this.accesses, other.accesses)) {
                return false;
            }
            return !(this.exclusions == null ? other.exclusions != null : !this.exclusions.equals(other.exclusions));
        }

        public static <T> Delta<T> empty() {
            return new Delta<Object>(new Object[0], Sets.newHashSet());
        }
    }

    public static enum PrefixTestResult {
        GUARANTEED_PREFIX(2),
        POTENTIAL_PREFIX(1),
        NO_PREFIX(0);

        private int value;

        private PrefixTestResult(int value) {
            this.value = value;
        }

        public boolean atLeast(PrefixTestResult minimum) {
            return this.value >= minimum.value;
        }
    }
}

