/*
 * Decompiled with CFR 0.152.
 */
package de.darmstadt.tu.crossing.generator;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import de.darmstadt.tu.crossing.CrySLStandaloneSetup;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.generator.GeneratorContext;
import org.eclipse.xtext.generator.GeneratorDelegate;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;

public class Main {
    @Inject
    private Provider<ResourceSet> resourceSetProvider;
    @Inject
    private IResourceValidator validator;
    @Inject
    private GeneratorDelegate generator;
    @Inject
    private JavaIoFileSystemAccess fileAccess;

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("Aborting: no path to EMF resource provided!");
            return;
        }
        Injector injector = new CrySLStandaloneSetup().createInjectorAndDoEMFRegistration();
        Main main = injector.getInstance(Main.class);
        main.runGenerator(args[0]);
    }

    protected void runGenerator(String string) {
        ResourceSet set = this.resourceSetProvider.get();
        Resource resource = set.getResource(URI.createFileURI(string), true);
        List<Issue> list = this.validator.validate(resource, CheckMode.ALL, CancelIndicator.NullImpl);
        if (!list.isEmpty()) {
            for (Issue issue : list) {
                System.err.println(issue);
            }
            return;
        }
        this.fileAccess.setOutputPath("src-gen/");
        GeneratorContext context = new GeneratorContext();
        context.setCancelIndicator(CancelIndicator.NullImpl);
        this.generator.generate(resource, this.fileAccess, context);
        System.out.println("Code generation finished.");
    }
}

