/*
 * Decompiled with CFR 0.152.
 */
package de.darmstadt.tu.crossing.crySL;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum OrderOperator implements Enumerator
{
    SEQUENCE(0, "SEQUENCE", ","),
    ALTERNATIVE(1, "ALTERNATIVE", "|"),
    ZERO_OR_MORE(2, "ZERO_OR_MORE", "*"),
    ONE_OR_MORE(3, "ONE_OR_MORE", "+"),
    ZERO_OR_ONE(4, "ZERO_OR_ONE", "?");

    public static final int SEQUENCE_VALUE = 0;
    public static final int ALTERNATIVE_VALUE = 1;
    public static final int ZERO_OR_MORE_VALUE = 2;
    public static final int ONE_OR_MORE_VALUE = 3;
    public static final int ZERO_OR_ONE_VALUE = 4;
    private static final OrderOperator[] VALUES_ARRAY;
    public static final List<OrderOperator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new OrderOperator[]{SEQUENCE, ALTERNATIVE, ZERO_OR_MORE, ONE_OR_MORE, ZERO_OR_ONE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static OrderOperator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            OrderOperator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static OrderOperator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            OrderOperator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static OrderOperator get(int value) {
        switch (value) {
            case 0: {
                return SEQUENCE;
            }
            case 1: {
                return ALTERNATIVE;
            }
            case 2: {
                return ZERO_OR_MORE;
            }
            case 3: {
                return ONE_OR_MORE;
            }
            case 4: {
                return ZERO_OR_ONE;
            }
        }
        return null;
    }

    private OrderOperator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

