/*
 * Decompiled with CFR 0.152.
 */
package crypto.typestate;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import crypto.rules.CrySLMethod;
import heros.utilities.DefaultValueMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;

public class CrySLMethodToSootMethod {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrySLMethodToSootMethod.class);
    private static CrySLMethodToSootMethod instance;
    private DefaultValueMap<CrySLMethod, Collection<SootMethod>> descriptorToSootMethod = new DefaultValueMap<CrySLMethod, Collection<SootMethod>>(){

        @Override
        protected Collection<SootMethod> createItem(CrySLMethod key) {
            Collection<SootMethod> res = Sets.newHashSet();
            try {
                res = CrySLMethodToSootMethod.this._convert(key);
            }
            catch (Exception e) {
                LOGGER.error("Failed to convert method " + key);
            }
            for (SootMethod m4 : res) {
                CrySLMethodToSootMethod.this.sootMethodToDescriptor.put(m4, key);
            }
            return res;
        }
    };
    private Multimap<SootMethod, CrySLMethod> sootMethodToDescriptor = HashMultimap.create();

    public Collection<CrySLMethod> convert(SootMethod m4) {
        return this.sootMethodToDescriptor.get(m4);
    }

    public Collection<SootMethod> convert(CrySLMethod label) {
        return this.descriptorToSootMethod.getOrCreate(label);
    }

    private Collection<SootMethod> _convert(CrySLMethod label) {
        HashSet<SootMethod> res = Sets.newHashSet();
        String methodName = label.getMethodName();
        String declaringClass = this.getDeclaringClass(methodName);
        if (!Scene.v().containsClass(declaringClass)) {
            return res;
        }
        Scene.v().forceResolve(declaringClass, 3);
        SootClass sootClass = Scene.v().getSootClass(declaringClass);
        ArrayList<SootClass> classes = Lists.newArrayList(sootClass);
        String methodNameWithoutDeclaringClass = this.getMethodNameWithoutDeclaringClass(methodName);
        if (methodNameWithoutDeclaringClass.equals(sootClass.getShortName())) {
            methodNameWithoutDeclaringClass = "<init>";
        } else {
            classes.addAll(this.getFullHierarchyOf(sootClass));
        }
        int noOfParams = label.getParameters().size();
        for (SootClass c : classes) {
            for (SootMethod m4 : c.getMethods()) {
                if (!m4.getName().equals(methodNameWithoutDeclaringClass) || m4.getParameterCount() != noOfParams || !this.parametersMatch(label.getParameters(), m4.getParameterTypes())) continue;
                res.add(m4);
            }
        }
        return res;
    }

    private Collection<? extends SootClass> getFullHierarchyOf(SootClass sootClass) {
        LinkedList<SootClass> worklist = Lists.newLinkedList();
        HashSet<SootClass> visited = Sets.newHashSet();
        worklist.add(sootClass);
        visited.add(sootClass);
        while (!worklist.isEmpty()) {
            SootClass first = (SootClass)worklist.pop();
            HashSet<SootClass> hierarchy = Sets.newHashSet();
            hierarchy.addAll(first.getInterfaces());
            if (first.isInterface()) {
                hierarchy.addAll(Scene.v().getActiveHierarchy().getSuperinterfacesOf(first));
            } else {
                hierarchy.addAll(Scene.v().getActiveHierarchy().getSuperclassesOf(first));
            }
            for (SootClass h2 : hierarchy) {
                if (!visited.add(h2)) continue;
                worklist.add(h2);
            }
        }
        return visited;
    }

    private boolean parametersMatch(List<Map.Entry<String, String>> parameters, List<Type> parameterTypes) {
        int i = 0;
        for (Type t2 : parameterTypes) {
            if (parameters.get(i).getValue().equals("AnyType")) continue;
            if (!t2.toString().equals(parameters.get(i).getValue())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private String getMethodNameWithoutDeclaringClass(String desc) {
        return desc.substring(desc.lastIndexOf(".") + 1);
    }

    public Collection<SootMethod> convert(List<CrySLMethod> list) {
        HashSet<SootMethod> res = Sets.newHashSet();
        for (CrySLMethod l : list) {
            res.addAll(this.convert(l));
        }
        return res;
    }

    private String getDeclaringClass(String label) {
        try {
            if (Scene.v().containsClass(label)) {
                return label;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return label.substring(0, label.lastIndexOf("."));
    }

    public static CrySLMethodToSootMethod v() {
        if (instance == null) {
            instance = new CrySLMethodToSootMethod();
        }
        return instance;
    }

    public static void reset() {
        instance = null;
    }
}

