/*
 * Decompiled with CFR 0.152.
 */
package crypto.reporting;

import crypto.reporting.Reporter;
import crypto.reporting.ReporterHelper;
import crypto.rules.CrySLRule;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Printer;
import soot.SootClass;
import soot.util.EscapedWriter;

public class TXTReporter
extends Reporter {
    private static final Logger LOG = LoggerFactory.getLogger(TXTReporter.class);
    private String analysisReport;
    private static final String REPORT_NAME = "CryptoAnalysis-Report.txt";

    public TXTReporter(String reportDir, String softwareID, List<CrySLRule> rules, long callgraphConstructionTime, boolean includeStatistics) {
        super(reportDir != null ? new File(reportDir) : new File(System.getProperty("user.dir")), softwareID, rules, callgraphConstructionTime, includeStatistics);
    }

    @Override
    public void handleAnalysisResults() {
        this.analysisReport = this.includeStatistics() ? ReporterHelper.generateReport(this.getRules(), this.getObjects(), this.secureObjects, this.errorMarkers, this.errorMarkerCount, this.getStatistics()) : ReporterHelper.generateReport(this.getRules(), this.getObjects(), this.secureObjects, this.errorMarkers, this.errorMarkerCount, null);
        try {
            FileWriter writer = new FileWriter(this.getOutputFolder() + File.separator + REPORT_NAME);
            writer.write(this.analysisReport);
            writer.close();
            for (SootClass c : this.errorMarkers.rowKeySet()) {
                FileOutputStream streamOut = new FileOutputStream(new File(this.getOutputFolder() + File.separator + c.toString() + ".jimple"));
                PrintWriter writerOut = new PrintWriter(new EscapedWriter(new OutputStreamWriter(streamOut)));
                Printer.v().printTo(c, writerOut);
                writerOut.flush();
                streamOut.close();
                writerOut.close();
            }
            LOG.info("Text Report generated to file : " + this.getOutputFolder().getAbsolutePath() + File.separator + REPORT_NAME);
        }
        catch (IOException e) {
            LOG.error("Could not write to file " + this.getOutputFolder().getAbsolutePath() + File.separator + REPORT_NAME, e);
        }
    }
}

