/*
 * Decompiled with CFR 0.152.
 */
package crypto.predicates;

import boomerang.jimple.Statement;
import boomerang.jimple.Val;
import boomerang.results.ForwardBoomerangResults;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import crypto.analysis.AlternativeReqPredicate;
import crypto.analysis.AnalysisSeedWithSpecification;
import crypto.analysis.ClassSpecification;
import crypto.analysis.CryptoScanner;
import crypto.analysis.EnsuredCrySLPredicate;
import crypto.analysis.IAnalysisSeed;
import crypto.analysis.RequiredCrySLPredicate;
import crypto.analysis.ResultsHandler;
import crypto.analysis.errors.PredicateContradictionError;
import crypto.analysis.errors.RequiredPredicateError;
import crypto.extractparameter.CallSiteWithExtractedValue;
import crypto.extractparameter.CallSiteWithParamIndex;
import crypto.interfaces.ISLConstraint;
import crypto.rules.CrySLPredicate;
import crypto.rules.CrySLRule;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import typestate.TransitionFunction;

public class PredicateHandler {
    private final Table<Statement, Val, Set<EnsuredCrySLPredicate>> existingPredicates = HashBasedTable.create();
    private final Table<Statement, IAnalysisSeed, Set<EnsuredCrySLPredicate>> existingPredicatesObjectBased = HashBasedTable.create();
    private final Table<Statement, IAnalysisSeed, Set<CrySLPredicate>> expectedPredicateObjectBased = HashBasedTable.create();
    private final CryptoScanner cryptoScanner;

    public PredicateHandler(CryptoScanner cryptoScanner) {
        this.cryptoScanner = cryptoScanner;
    }

    public boolean addNewPred(IAnalysisSeed seedObj, Statement statement, Val variable, EnsuredCrySLPredicate ensPred) {
        Set<EnsuredCrySLPredicate> set = this.getExistingPredicates(statement, variable);
        boolean added = set.add(ensPred);
        assert (this.existingPredicates.get(statement, variable).contains(ensPred));
        if (added) {
            this.onPredicateAdded(seedObj, statement, variable, ensPred);
        }
        this.cryptoScanner.getAnalysisListener().onSecureObjectFound(seedObj);
        Set<EnsuredCrySLPredicate> predsObjBased = this.existingPredicatesObjectBased.get(statement, seedObj);
        if (predsObjBased == null) {
            predsObjBased = Sets.newHashSet();
        }
        predsObjBased.add(ensPred);
        this.existingPredicatesObjectBased.put(statement, seedObj, predsObjBased);
        return added;
    }

    public Set<EnsuredCrySLPredicate> getExistingPredicates(Statement stmt, Val seed) {
        Set<EnsuredCrySLPredicate> set = this.existingPredicates.get(stmt, seed);
        if (set == null) {
            set = Sets.newHashSet();
            this.existingPredicates.put(stmt, seed, set);
        }
        return set;
    }

    private void onPredicateAdded(IAnalysisSeed seedObj, Statement statement, Val seed, EnsuredCrySLPredicate ensPred) {
        if (statement.isCallsite()) {
            InvokeExpr iie;
            InvokeExpr ivexpr = statement.getUnit().get().getInvokeExpr();
            if (ivexpr instanceof InstanceInvokeExpr) {
                iie = (InstanceInvokeExpr)ivexpr;
                SootMethod callerMethod = statement.getMethod();
                Value base = iie.getBase();
                boolean paramMatch = false;
                for (Value arg : iie.getArgs()) {
                    if (seed.value() == null || !seed.value().equals(arg)) continue;
                    paramMatch = true;
                }
                if (paramMatch) {
                    for (AnalysisSeedWithSpecification secondSeed : Lists.newArrayList(this.cryptoScanner.getAnalysisSeeds())) {
                        secondSeed.registerResultsHandler(new AddPredicateToOtherSeed(statement, base, callerMethod, ensPred, secondSeed));
                    }
                }
            }
            if (ivexpr instanceof StaticInvokeExpr && statement.getUnit().get() instanceof AssignStmt) {
                iie = (StaticInvokeExpr)ivexpr;
                boolean paramMatch = false;
                for (Value arg : iie.getArgs()) {
                    if (seed.value() == null || !seed.value().equals(arg)) continue;
                    paramMatch = true;
                }
                if (paramMatch) {
                    for (AnalysisSeedWithSpecification spec : Lists.newArrayList(this.cryptoScanner.getAnalysisSeeds())) {
                        if (!spec.stmt().equals(statement)) continue;
                        spec.addEnsuredPredicate(ensPred);
                    }
                }
            }
        }
    }

    public void expectPredicate(IAnalysisSeed object, Statement stmt, CrySLPredicate predToBeEnsured) {
        for (Unit succ : this.cryptoScanner.icfg().getSuccsOf(stmt.getUnit().get())) {
            Set<CrySLPredicate> set = this.expectedPredicateObjectBased.get(succ, object);
            if (set == null) {
                set = Sets.newHashSet();
            }
            set.add(predToBeEnsured);
            this.expectedPredicateObjectBased.put(new Statement((Stmt)succ, stmt.getMethod()), object, set);
        }
    }

    public void checkPredicates() {
        this.checkMissingRequiredPredicates();
        this.checkForContradictions();
        this.cryptoScanner.getAnalysisListener().ensuredPredicates(this.existingPredicates, this.expectedPredicateObjectBased, this.computeMissingPredicates());
    }

    private void checkMissingRequiredPredicates() {
        for (AnalysisSeedWithSpecification seed : this.cryptoScanner.getAnalysisSeeds()) {
            Set<ISLConstraint> missingPredicates = seed.getMissingPredicates();
            for (ISLConstraint pred : missingPredicates) {
                if (pred instanceof RequiredCrySLPredicate) {
                    this.reportMissingPred(seed, (RequiredCrySLPredicate)pred);
                    continue;
                }
                if (!(pred instanceof AlternativeReqPredicate)) continue;
                this.reportMissingPred(seed, (AlternativeReqPredicate)pred);
            }
        }
    }

    private void reportMissingPred(AnalysisSeedWithSpecification seed, RequiredCrySLPredicate missingPred) {
        CrySLRule rule = seed.getSpec().getRule();
        if (!rule.getPredicates().parallelStream().anyMatch(e -> missingPred.getPred().getPredName().equals(e.getPredName()) && missingPred.getPred().getParameters().get(0).equals(e.getParameters().get(0)))) {
            for (CallSiteWithParamIndex v : seed.getParameterAnalysis().getAllQuerySites()) {
                if (!missingPred.getPred().getInvolvedVarNames().contains(v.getVarName()) || !v.stmt().equals(missingPred.getLocation())) continue;
                this.cryptoScanner.getAnalysisListener().reportError(seed, new RequiredPredicateError(Arrays.asList(missingPred.getPred()), missingPred.getLocation(), seed.getSpec().getRule(), new CallSiteWithExtractedValue(v, null)));
            }
        }
    }

    private void reportMissingPred(AnalysisSeedWithSpecification seed, AlternativeReqPredicate missingPred) {
        CrySLRule rule = seed.getSpec().getRule();
        if (!rule.getPredicates().parallelStream().anyMatch(e -> missingPred.getAlternatives().stream().anyMatch(e1 -> e1.getPredName().equals(e.getPredName())) && missingPred.getAlternatives().stream().anyMatch(e2 -> e2.getParameters().get(0).equals(e.getParameters().get(0))))) {
            for (CallSiteWithParamIndex v : seed.getParameterAnalysis().getAllQuerySites()) {
                if (!missingPred.getAlternatives().parallelStream().anyMatch(e4 -> e4.getInvolvedVarNames().contains(v.getVarName())) || !v.stmt().equals(missingPred.getLocation())) continue;
                this.cryptoScanner.getAnalysisListener().reportError(seed, new RequiredPredicateError(missingPred.getAlternatives(), missingPred.getLocation(), seed.getSpec().getRule(), new CallSiteWithExtractedValue(v, null)));
            }
        }
    }

    private void checkForContradictions() {
        HashSet<AbstractMap.SimpleEntry<CrySLPredicate, CrySLPredicate>> contradictionPairs = new HashSet<AbstractMap.SimpleEntry<CrySLPredicate, CrySLPredicate>>();
        for (ClassSpecification c : this.cryptoScanner.getClassSpecifictions()) {
            CrySLRule rule = c.getRule();
            for (ISLConstraint cons : rule.getConstraints()) {
                if (!(cons instanceof CrySLPredicate) || !((CrySLPredicate)cons).isNegated().booleanValue()) continue;
                contradictionPairs.add(new AbstractMap.SimpleEntry<CrySLPredicate, CrySLPredicate>(rule.getPredicates().get(0), ((CrySLPredicate)cons).setNegated(false)));
            }
        }
        for (Statement generatingPredicateStmt : this.expectedPredicateObjectBased.rowKeySet()) {
            for (Map.Entry<Val, Set<EnsuredCrySLPredicate>> exPredCell : this.existingPredicates.row(generatingPredicateStmt).entrySet()) {
                HashSet<String> preds = new HashSet<String>();
                for (EnsuredCrySLPredicate ensuredCrySLPredicate : exPredCell.getValue()) {
                    preds.add(ensuredCrySLPredicate.getPredicate().getPredName());
                }
                for (Map.Entry entry : contradictionPairs) {
                    if (!preds.contains(((CrySLPredicate)entry.getKey()).getPredName()) || !preds.contains(((CrySLPredicate)entry.getValue()).getPredName())) continue;
                    this.cryptoScanner.getAnalysisListener().reportError(null, new PredicateContradictionError(generatingPredicateStmt, null, entry));
                }
            }
        }
    }

    private Table<Statement, IAnalysisSeed, Set<CrySLPredicate>> computeMissingPredicates() {
        HashBasedTable<Statement, IAnalysisSeed, Set<CrySLPredicate>> res = HashBasedTable.create();
        for (Table.Cell<Statement, IAnalysisSeed, Set<CrySLPredicate>> c : this.expectedPredicateObjectBased.cellSet()) {
            Set<EnsuredCrySLPredicate> exPreds = this.existingPredicatesObjectBased.get(c.getRowKey(), c.getColumnKey());
            if (c.getValue() == null) continue;
            HashSet expectedPreds = new HashSet(c.getValue());
            if (exPreds == null) {
                exPreds = Sets.newHashSet();
            }
            for (EnsuredCrySLPredicate p : exPreds) {
                expectedPreds.remove(p.getPredicate());
            }
            if (expectedPreds.isEmpty()) continue;
            res.put(c.getRowKey(), c.getColumnKey(), expectedPreds);
        }
        return res;
    }

    private final class AddPredicateToOtherSeed
    implements ResultsHandler {
        private final Statement statement;
        private final Value base;
        private final SootMethod callerMethod;
        private final EnsuredCrySLPredicate ensPred;
        private final AnalysisSeedWithSpecification secondSeed;

        private AddPredicateToOtherSeed(Statement statement, Value base, SootMethod callerMethod, EnsuredCrySLPredicate ensPred, AnalysisSeedWithSpecification secondSeed) {
            this.statement = statement;
            this.base = base;
            this.callerMethod = callerMethod;
            this.ensPred = ensPred;
            this.secondSeed = secondSeed;
        }

        @Override
        public void done(ForwardBoomerangResults<TransitionFunction> results) {
            if (results.asStatementValWeightTable().row(this.statement).containsKey(new Val(this.base, this.callerMethod))) {
                this.secondSeed.addEnsuredPredicate(this.ensPred);
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.base == null ? 0 : this.base.hashCode());
            result = 31 * result + (this.callerMethod == null ? 0 : this.callerMethod.hashCode());
            result = 31 * result + (this.ensPred == null ? 0 : this.ensPred.hashCode());
            result = 31 * result + (this.secondSeed == null ? 0 : this.secondSeed.hashCode());
            result = 31 * result + (this.statement == null ? 0 : this.statement.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AddPredicateToOtherSeed other = (AddPredicateToOtherSeed)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.base == null ? other.base != null : !this.base.equals(other.base)) {
                return false;
            }
            if (this.callerMethod == null ? other.callerMethod != null : !this.callerMethod.equals(other.callerMethod)) {
                return false;
            }
            if (this.ensPred == null ? other.ensPred != null : !this.ensPred.equals(other.ensPred)) {
                return false;
            }
            if (this.secondSeed == null ? other.secondSeed != null : !this.secondSeed.equals(other.secondSeed)) {
                return false;
            }
            return !(this.statement == null ? other.statement != null : !this.statement.equals(other.statement));
        }

        private PredicateHandler getOuterType() {
            return PredicateHandler.this;
        }
    }
}

