/*
 * Decompiled with CFR 0.152.
 */
package crypto.preanalysis;

import boomerang.Query;
import boomerang.WeightedForwardQuery;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import crypto.rules.CrySLRule;
import crypto.typestate.FiniteStateMachineToTypestateChangeFunction;
import crypto.typestate.SootBasedStateMachineGraph;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import soot.SootMethod;
import soot.Unit;
import typestate.TransitionFunction;

public class SeedFactory {
    private List<FiniteStateMachineToTypestateChangeFunction> idealAnalysisDefs = Lists.newLinkedList();
    private Set<Query> seeds = Sets.newHashSet();

    public SeedFactory(List<CrySLRule> rules) {
        for (CrySLRule rule : rules) {
            this.idealAnalysisDefs.add(new FiniteStateMachineToTypestateChangeFunction(new SootBasedStateMachineGraph(rule.getUsagePattern())));
        }
    }

    public void generate(SootMethod method, Unit unit) {
        for (FiniteStateMachineToTypestateChangeFunction defs : this.idealAnalysisDefs) {
            Collection<WeightedForwardQuery<TransitionFunction>> found = defs.generateSeed(method, unit);
            this.seeds.addAll(found);
        }
    }

    public boolean hasSeeds() {
        return !this.seeds.isEmpty();
    }
}

