/*
 * Decompiled with CFR 0.152.
 */
package crypto.analysis.errors;

import boomerang.jimple.Statement;
import crypto.analysis.errors.AbstractError;
import crypto.analysis.errors.ErrorVisitor;
import crypto.extractparameter.CallSiteWithExtractedValue;
import crypto.rules.CrySLPredicate;
import crypto.rules.CrySLRule;
import java.util.List;
import java.util.stream.Collectors;

public class RequiredPredicateError
extends AbstractError {
    private List<CrySLPredicate> contradictedPredicate;
    private CallSiteWithExtractedValue extractedValues;

    public RequiredPredicateError(List<CrySLPredicate> contradictedPredicates, Statement location, CrySLRule rule, CallSiteWithExtractedValue multimap) {
        super(location, rule);
        this.contradictedPredicate = contradictedPredicates;
        this.extractedValues = multimap;
    }

    public List<CrySLPredicate> getContradictedPredicates() {
        return this.contradictedPredicate;
    }

    public CallSiteWithExtractedValue getExtractedValues() {
        return this.extractedValues;
    }

    @Override
    public void accept(ErrorVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String toErrorMarkerString() {
        String msg = this.extractedValues.toString();
        msg = msg + " was not properly generated as ";
        String predicateName = this.getContradictedPredicates().stream().map(e -> e.getPredName()).collect(Collectors.joining(" OR "));
        String[] parts = predicateName.split("(?=[A-Z])");
        msg = msg + parts[0];
        for (int i = 1; i < parts.length; ++i) {
            msg = msg + parts[i];
        }
        if (predicateName.equals("preparedIV") && this.extractedValues.toString().equals("Third parameter")) {
            msg = msg + " [ with CBC, It's required to use IVParameterSpec]";
        }
        return msg;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.contradictedPredicate == null ? 0 : this.contradictedPredicate.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RequiredPredicateError other = (RequiredPredicateError)obj;
        return !(this.contradictedPredicate == null ? other.contradictedPredicate != null : !this.contradictedPredicate.equals(other.contradictedPredicate));
    }
}

