/*
 * Decompiled with CFR 0.152.
 */
package crypto.analysis.errors;

import boomerang.jimple.Statement;
import crypto.analysis.errors.AbstractError;
import crypto.analysis.errors.ErrorVisitor;
import crypto.interfaces.ISLConstraint;
import crypto.rules.CrySLRule;

public class ImpreciseValueExtractionError
extends AbstractError {
    private ISLConstraint violatedConstraint;

    public ImpreciseValueExtractionError(ISLConstraint violatedCons, Statement errorLocation, CrySLRule rule) {
        super(errorLocation, rule);
        this.violatedConstraint = violatedCons;
    }

    @Override
    public void accept(ErrorVisitor visitor) {
        visitor.visit(this);
    }

    public ISLConstraint getViolatedConstraint() {
        return this.violatedConstraint;
    }

    @Override
    public String toErrorMarkerString() {
        StringBuilder msg = new StringBuilder("Constraint ");
        msg.append(this.violatedConstraint);
        msg.append(" could not be evaluted due to insufficient information.");
        return msg.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.violatedConstraint == null ? 0 : this.violatedConstraint.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImpreciseValueExtractionError other = (ImpreciseValueExtractionError)obj;
        return !(this.violatedConstraint == null ? other.violatedConstraint != null : !this.violatedConstraint.equals(other.violatedConstraint));
    }
}

